/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectimport.eclipse.core;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.projectimport.eclipse.core.EclipseProject;
import org.netbeans.modules.projectimport.eclipse.core.EclipseProjectReference;
import org.netbeans.modules.projectimport.eclipse.core.UpdateEclipseReferencePanel;
import org.netbeans.modules.projectimport.eclipse.core.Workspace;
import org.openide.util.Mutex;
import org.openide.util.MutexException;

public final class UpgradableProject {
    private Project project;
    private EclipseProjectReference reference;
    private boolean initialized;
    private boolean createdFromEclipse;

    public UpgradableProject(Project project) {
        this.project = project;
    }

    public boolean isEclipseProjectReachable() {
        if (!this.isUpgradable()) {
            return false;
        }
        return this.getEclipseProjectReference().isEclipseProjectReachable();
    }

    public boolean isUpgradable() {
        return this.getEclipseProjectReference() != null;
    }

    public boolean isUpToDate(boolean deepTest) {
        assert (this.isUpgradable() && this.isEclipseProjectReachable());
        return this.getEclipseProjectReference().isUpToDate(deepTest);
    }

    public void update(final List<String> importProblems) throws IOException {
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws Exception {
                    UpgradableProject.this.getEclipseProjectReference().update(importProblems);
                    return null;
                }
            });
        }
        catch (MutexException ex) {
            IOException ioe = new IOException();
            ioe.initCause(ex.getCause());
            throw ioe;
        }
    }

    private EclipseProjectReference getEclipseProjectReference() {
        if (!this.initialized) {
            this.reference = EclipseProjectReference.read(this.project);
            this.initialized = this.reference == null ? true : this.reference.isEclipseProjectReachable();
            this.createdFromEclipse = this.reference != null;
        }
        return this.reference;
    }

    boolean isCreatedFromEclipse() {
        this.getEclipseProjectReference();
        return this.createdFromEclipse;
    }

    public boolean updateBrokenEclipseReference(Map<String, String> resolvedEntries) {
        return UpdateEclipseReferencePanel.showEclipseReferenceResolver(this.getEclipseProjectReference(), resolvedEntries);
    }

    File getStoredEclipseProjectFolder() {
        return this.getEclipseProjectReference().getFallbackEclipseProjectLocation();
    }

    File getStoredEclipseWorkspaceFolder() {
        return this.getEclipseProjectReference().getFallbackWorkspaceProjectLocation();
    }

    Workspace getWorkspace() {
        EclipseProject prj = this.getEclipseProject();
        return prj != null ? prj.getWorkspace() : null;
    }

    EclipseProject getEclipseProject() {
        return this.getEclipseProjectReference().getEclipseProject(false);
    }

    public Project getProject() {
        return this.project;
    }
}

