/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.gsf.GsfDataLoader;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.api.EmbeddingModel;
import org.netbeans.modules.gsf.api.GsfLanguage;
import org.netbeans.modules.gsf.api.IncrementalEmbeddingModel;
import org.netbeans.modules.gsf.api.IncrementalParser;
import org.netbeans.modules.gsf.api.Parser;
import org.netbeans.modules.gsf.api.annotations.CheckForNull;
import org.netbeans.modules.gsf.api.annotations.NonNull;
import org.netbeans.modules.gsfpath.api.classpath.ClassPath;
import org.netbeans.modules.gsfpath.spi.classpath.ClassPathFactory;
import org.netbeans.modules.gsfpath.spi.classpath.ClassPathImplementation;
import org.netbeans.modules.gsfpath.spi.classpath.PathResourceImplementation;
import org.netbeans.modules.gsfret.source.usages.ClassIndexManager;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public final class LanguageRegistry
implements Iterable<Language> {
    private static final Logger LOG = Logger.getLogger(LanguageRegistry.class.getName());
    private static LanguageRegistry instance;
    private static final String STRUCTURE = "structure.instance";
    private static final String LANGUAGE = "language.instance";
    private static final String ICON_BASE = "iconBase";
    private static final String PARSER = "parser.instance";
    private static final String COMPLETION = "completion.instance";
    private static final String RENAMER = "renamer.instance";
    private static final String FORMATTER = "formatter.instance";
    private static final String BRACKET_COMPLETION = "bracket.instance";
    private static final String DECLARATION_FINDER = "declarationfinder.instance";
    private static final String INDEXER = "indexer.instance";
    private static final String HINTS = "hints.instance";
    private static final String SEMANTIC = "semantic.instance";
    private static final String OCCURRENCES = "occurrences.instance";
    private static final String INDEX_SEARCHER = "index_searcher.instance";
    private static final String FOLDER = "GsfPlugins";
    private boolean cacheDirty = true;
    private Map<String, Language> languagesCache;
    private FileChangeListener sfsTracker;
    private Collection<? extends EmbeddingModel> embeddingModels;
    private Map<String, List<Language>> applicableLanguages = new HashMap<String, List<Language>>();
    private Map<String, Boolean> possiblyIncremental = new HashMap<String, Boolean>();
    private Map<String, Map<String, Boolean>> relevantMimes = new HashMap<String, Map<String, Boolean>>();
    private ClassPath libraryPath;
    private List<URL> urls;
    private static final Set<String> warnedPaths;

    private LanguageRegistry() {
    }

    public void addLanguages(List<Language> newLanguages) {
        if (this.languagesCache != null) {
            throw new RuntimeException("This is for testing purposes only!!!");
        }
        this.cacheDirty = false;
        this.languagesCache = new HashMap<String, Language>(2 * newLanguages.size());
        for (Language language : newLanguages) {
            String mimeType = language.getMimeType();
            this.languagesCache.put(mimeType, language);
        }
    }

    public static synchronized LanguageRegistry getInstance() {
        if (instance == null) {
            instance = new LanguageRegistry();
        }
        return instance;
    }

    public Language getLanguageByMimeType(@NonNull String mimeType) {
        Map<String, Language> map = this.getLanguages();
        return map.get(mimeType);
    }

    @CheckForNull
    public EmbeddingModel getEmbedding(@NonNull String targetMimeType, @NonNull String sourceMimeType) {
        Collection<? extends EmbeddingModel> models = this.getEmbeddingModels();
        for (EmbeddingModel embeddingModel : models) {
            if (!embeddingModel.getTargetMimeType().equals(targetMimeType) || !embeddingModel.getSourceMimeTypes().contains(sourceMimeType)) continue;
            return embeddingModel;
        }
        return null;
    }

    private Collection<? extends EmbeddingModel> getEmbeddingModels() {
        if (this.embeddingModels == null) {
            this.embeddingModels = Lookup.getDefault().lookupAll(EmbeddingModel.class);
        }
        return this.embeddingModels;
    }

    public boolean isRelevantFor(FileObject fo, String targetMimeType) {
        Boolean result;
        String fileMimeType = fo.getMIMEType();
        if (targetMimeType.equals(fileMimeType)) {
            return true;
        }
        Map<String, Boolean> mimeMap = this.relevantMimes.get(targetMimeType);
        if (mimeMap == null) {
            mimeMap = new HashMap<String, Boolean>();
            this.relevantMimes.put(targetMimeType, mimeMap);
        }
        if ((result = mimeMap.get(fileMimeType)) == null) {
            result = Boolean.FALSE;
            Collection<? extends EmbeddingModel> models = this.getEmbeddingModels();
            for (EmbeddingModel embeddingModel : models) {
                if (!embeddingModel.getTargetMimeType().equals(targetMimeType) || !embeddingModel.getSourceMimeTypes().contains(fileMimeType)) continue;
                result = Boolean.TRUE;
                break;
            }
            mimeMap.put(fileMimeType, result);
        }
        return result;
    }

    @NonNull
    public List<Language> getApplicableLanguages(String mimeType) {
        List<Language> result = this.applicableLanguages.get(mimeType);
        if (result == null) {
            result = new ArrayList<Language>(5);
            Collection<? extends EmbeddingModel> models = this.getEmbeddingModels();
            Language origLanguage = this.getLanguageByMimeType(mimeType);
            if (origLanguage != null) {
                result.add(origLanguage);
            }
            for (EmbeddingModel embeddingModel : models) {
                Language language;
                if (!embeddingModel.getSourceMimeTypes().contains(mimeType) || (language = this.getLanguageByMimeType(embeddingModel.getTargetMimeType())) == null || result.contains(language)) continue;
                result.add(language);
            }
            this.applicableLanguages.put(mimeType, result);
        }
        return result;
    }

    public boolean isIncremental(String mimeType) {
        Boolean b = this.possiblyIncremental.get(mimeType);
        if (b == null) {
            List<Language> applicable = this.getApplicableLanguages(mimeType);
            boolean incremental = false;
            for (Language language : applicable) {
                EmbeddingModel model;
                Parser parser = language.getParser();
                if (parser instanceof IncrementalParser) {
                    incremental = true;
                }
                if (language.getMimeType().equals(mimeType) || !((model = this.getEmbedding(language.getMimeType(), mimeType)) instanceof IncrementalEmbeddingModel)) continue;
                incremental = true;
                break;
            }
            b = incremental ? Boolean.TRUE : Boolean.FALSE;
            this.possiblyIncremental.put(mimeType, b);
        }
        return b == Boolean.TRUE;
    }

    public List<URL> getLibraryUrls() {
        if (this.urls == null) {
            this.urls = new ArrayList<URL>();
            for (Language language : this) {
                GsfLanguage gsfLanguage = language.getGsfLanguage();
                if (gsfLanguage == null) continue;
                for (FileObject fo : gsfLanguage.getCoreLibraries()) {
                    try {
                        if (fo == null) continue;
                        URL url = FileUtil.toFile((FileObject)fo).toURI().toURL();
                        this.urls.add(url);
                        ClassIndexManager.get(language).addBootRoot(url);
                    }
                    catch (MalformedURLException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        }
        return this.urls;
    }

    public List<FileObject> getLibraryFos() {
        ArrayList<FileObject> fos = new ArrayList<FileObject>();
        for (Language language : this) {
            GsfLanguage gsfLanguage = language.getGsfLanguage();
            if (gsfLanguage == null) continue;
            for (FileObject fo : gsfLanguage.getCoreLibraries()) {
                fos.add(fo);
            }
        }
        return fos;
    }

    public ClassPath getLibraryPaths() {
        if (this.libraryPath == null) {
            List<URL> urlList = this.getLibraryUrls();
            final URL[] urlArray = urlList.toArray(new URL[urlList.size()]);
            this.libraryPath = ClassPathFactory.createClassPath((ClassPathImplementation)new ClassPathImplementation(){

                public List<? extends PathResourceImplementation> getResources() {
                    return Collections.singletonList(new PathResourceImplementation(){

                        public URL[] getRoots() {
                            return urlArray;
                        }

                        public ClassPathImplementation getContent() {
                            return null;
                        }

                        public void addPropertyChangeListener(PropertyChangeListener listener) {
                        }

                        public void removePropertyChangeListener(PropertyChangeListener listener) {
                        }
                    });
                }

                public void addPropertyChangeListener(PropertyChangeListener listener) {
                }

                public void removePropertyChangeListener(PropertyChangeListener listener) {
                }
            });
        }
        return this.libraryPath;
    }

    private void addLanguages(List<Language> result, TokenSequence ts, int offset) {
        ts.move(offset);
        if (ts.moveNext() || ts.movePrevious()) {
            String mimeType;
            Language language;
            TokenSequence ets = ts.embedded();
            if (ets != null) {
                this.addLanguages(result, ets, offset);
            }
            if ((language = this.getLanguageByMimeType(mimeType = ts.language().mimeType())) != null) {
                result.add(language);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Language> getEmbeddedLanguages(BaseDocument doc, int offset) {
        Language language;
        ArrayList<Language> result = new ArrayList<Language>();
        doc.readLock();
        try {
            TokenSequence ts = TokenHierarchy.get((Document)doc).tokenSequence();
            if (ts != null) {
                this.addLanguages(result, ts, offset);
            }
        }
        finally {
            doc.readUnlock();
        }
        String mimeType = (String)doc.getProperty((Object)"mimeType");
        if (mimeType != null && (language = this.getLanguageByMimeType(mimeType)) != null && (result.size() == 0 || result.get(result.size() - 1) != language)) {
            result.add(language);
        }
        return result;
    }

    public boolean isSupported(@NonNull String mimeType) {
        if (mimeType == null) {
            return false;
        }
        return this.getLanguageByMimeType(mimeType) != null;
    }

    public String getLanguagesDisplayName() {
        StringBuilder sb = new StringBuilder();
        for (Language language : this) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(language.getDisplayName());
        }
        return sb.toString();
    }

    @Override
    public Iterator<Language> iterator() {
        Map<String, Language> map = this.getLanguages();
        return map.values().iterator();
    }

    private synchronized Map<String, Language> getLanguages() {
        if (this.cacheDirty) {
            FileSystem sfs;
            this.cacheDirty = false;
            try {
                sfs = FileUtil.getConfigRoot().getFileSystem();
            }
            catch (FileStateInvalidException ex) {
                sfs = null;
            }
            this.languagesCache = LanguageRegistry.readSfs(sfs, this.languagesCache);
            if (this.sfsTracker == null) {
                this.userdirCleanup();
                this.sfsTracker = new FsTracker(sfs);
            } else {
                ((GsfDataLoader)GsfDataLoader.getLoader(GsfDataLoader.class)).initExtensions();
            }
        }
        return this.languagesCache;
    }

    private static boolean isValidType(FileObject typeFile) {
        if (!typeFile.isFolder()) {
            return false;
        }
        String typeName = typeFile.getNameExt();
        return MimePath.validate((CharSequence)typeName, null);
    }

    private static boolean isValidSubtype(FileObject subtypeFile) {
        if (!subtypeFile.isFolder()) {
            return false;
        }
        String typeName = subtypeFile.getNameExt();
        return MimePath.validate(null, (CharSequence)typeName) && !typeName.equals("base");
    }

    private static Map<String, Language> readSfs(FileSystem sfs, Map<String, Language> existingMap) {
        FileObject registryFolder;
        FileObject fileObject = registryFolder = sfs == null ? null : sfs.findResource(FOLDER);
        if (registryFolder == null) {
            LOG.info("No GsfPlugins folder");
            return Collections.emptyMap();
        }
        LOG.fine("Reading GsfPlugins registry...");
        HashMap<String, Language> newMap = new HashMap<String, Language>();
        FileObject[] types = registryFolder.getChildren();
        for (int i = 0; i < types.length; ++i) {
            if (!LanguageRegistry.isValidType(types[i])) continue;
            FileObject[] subtypes = types[i].getChildren();
            for (int j = 0; j < subtypes.length; ++j) {
                String iconBase;
                FileObject loaderMimeFile;
                Language existingLanguage;
                if (!LanguageRegistry.isValidSubtype(subtypes[j])) continue;
                String mimeType = types[i].getNameExt() + "/" + subtypes[j].getNameExt();
                Language language = existingLanguage = existingMap != null ? existingMap.get(mimeType) : null;
                if (existingLanguage != null) {
                    LOG.fine("Reusing existing Language for '" + mimeType + "': " + existingLanguage);
                    newMap.put(mimeType, existingLanguage);
                    continue;
                }
                Integer attr = (Integer)subtypes[j].getAttribute("genver");
                if (attr == null) {
                    LOG.log(Level.SEVERE, "Language " + mimeType + " has not been preprocessed during jar module creation");
                }
                Language language2 = new Language(mimeType);
                newMap.put(mimeType, language2);
                LOG.fine("Adding new Language for '" + mimeType + "': " + language2);
                Boolean useCustomEditorKit = (Boolean)subtypes[j].getAttribute("useCustomEditorKit");
                if (useCustomEditorKit != null && useCustomEditorKit.booleanValue()) {
                    language2.setUseCustomEditorKit(true);
                    LOG.fine("Language for '" + mimeType + "' is using custom editor kit.");
                }
                if ((loaderMimeFile = FileUtil.getConfigFile((String)("Loaders/" + mimeType))) != null && (iconBase = (String)loaderMimeFile.getAttribute(ICON_BASE)) != null && iconBase.length() > 0) {
                    language2.setIconBase(iconBase);
                }
                boolean foundConfig = false;
                for (FileObject fo : subtypes[j].getChildren()) {
                    String name = fo.getNameExt();
                    LOG.fine("Language for '" + mimeType + "' registers: " + name);
                    if (LANGUAGE.equals(name)) {
                        foundConfig = true;
                        language2.setGsfLanguageFile(fo);
                        continue;
                    }
                    if (HINTS.equals(name)) {
                        language2.setHintsProviderFile(fo);
                        continue;
                    }
                    if (STRUCTURE.equals(name)) {
                        language2.setStructureFile(fo);
                        continue;
                    }
                    if (PARSER.equals(name)) {
                        language2.setParserFile(fo);
                        continue;
                    }
                    if (COMPLETION.equals(name)) {
                        language2.setCompletionProviderFile(fo);
                        continue;
                    }
                    if (RENAMER.equals(name)) {
                        language2.setInstantRenamerFile(fo);
                        continue;
                    }
                    if (FORMATTER.equals(name)) {
                        language2.setFormatterFile(fo);
                        continue;
                    }
                    if (DECLARATION_FINDER.equals(name)) {
                        language2.setDeclarationFinderFile(fo);
                        continue;
                    }
                    if (BRACKET_COMPLETION.equals(name)) {
                        language2.setBracketCompletionFile(fo);
                        continue;
                    }
                    if (INDEXER.equals(name)) {
                        language2.setIndexerFile(fo);
                        continue;
                    }
                    if (SEMANTIC.equals(name)) {
                        language2.setSemanticAnalyzer(fo);
                        continue;
                    }
                    if (OCCURRENCES.equals(name)) {
                        language2.setOccurrencesFinderFile(fo);
                        continue;
                    }
                    if (!INDEX_SEARCHER.equals(name)) continue;
                    language2.setIndexSearcher(fo);
                }
                if (foundConfig || !warnedPaths.add(subtypes[j].getPath())) continue;
                LOG.log(Level.WARNING, "No GsfLanguage instance registered in {0}", subtypes[j].getPath());
            }
        }
        LOG.fine("-- Finished reading GsfPlugins registry!");
        return newMap;
    }

    private void userdirCleanup() {
        boolean assertionsEnabled = false;
        if (!$assertionsDisabled) {
            assertionsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (!assertionsEnabled) {
            return;
        }
        String userDir = System.getProperty("netbeans.user");
        if (userDir == null) {
            return;
        }
        FileObject config = FileUtil.toFileObject((File)new File(userDir, "config"));
        if (config == null) {
            return;
        }
        FileObject navFo = config.getFileObject("Navigator/Panels/text/javascript/org-netbeans-modules-gsfret-navigation-ClassMemberPanel.instance");
        if (navFo == null) {
            return;
        }
        try {
            FileObject editors;
            FileObject panels;
            FileObject navigator = config.getFileObject("Navigator");
            if (navigator != null && (panels = navigator.getFileObject("Panels")) != null) {
                for (FileObject outerMime : panels.getChildren()) {
                    for (FileObject innerMime : outerMime.getChildren()) {
                        FileObject panel = innerMime.getFileObject("org-netbeans-modules-gsfret-navigation-ClassMemberPanel.instance");
                        if (panel != null) {
                            panel.delete();
                            if (innerMime.getChildren().length == 0) {
                                innerMime.delete();
                            }
                        }
                        if (outerMime.getChildren().length != 0) continue;
                        outerMime.delete();
                    }
                }
                if (panels.getChildren().length == 0) {
                    panels.delete();
                    if (navigator.getChildren().length == 0) {
                        navigator.delete();
                    }
                }
            }
            if ((editors = config.getFileObject("Editors")) != null) {
                for (FileObject outerMime : editors.getChildren()) {
                    for (FileObject innerMime : outerMime.getChildren()) {
                        FileObject old;
                        FileObject sep;
                        String completionProviders;
                        FileObject completion;
                        FileObject popup;
                        FileObject hyperlinkProvider;
                        FileObject oldSidebar;
                        FileObject f;
                        FileObject fo;
                        String mimeType = outerMime.getName() + "/" + innerMime.getName();
                        FileObject root = innerMime;
                        FileObject settings = root.getFileObject("Settings.settings");
                        if (settings != null) {
                            settings.delete();
                        }
                        if ((fo = root.getFileObject("SideBar/org-netbeans-modules-editor-gsfret-GsfCodeFoldingSideBarFactory.instance")) != null) {
                            fo.delete();
                        }
                        if ((fo = root.getFileObject("SideBar")) != null && fo.getChildren().length == 0) {
                            fo.delete();
                        }
                        if ((fo = root.getFileObject("FoldManager/org-netbeans-modules-gsfret-editor-fold-GsfFoldManagerFactory.instance")) != null) {
                            fo.delete();
                        }
                        if ((fo = root.getFileObject("FoldManager")) != null && fo.getChildren().length == 0) {
                            fo.delete();
                        }
                        if ((mimeType.equals("text/x-yaml") || mimeType.equals("text/x-json")) && (f = root.getFileObject("Popup/generate-fold-popup")) != null) {
                            f.delete();
                            f = root.getFileObject("ToolTips/org-netbeans-modules-languages-features-ToolTipAnnotation.instance");
                            if (f != null) {
                                f.delete();
                            }
                            if ((f = root.getFileObject("Popup/org-netbeans-modules-languages-features-GoToDeclarationAction.instance")) != null) {
                                f.delete();
                            }
                            if ((f = root.getFileObject("UpToDateStatusProvider/org-netbeans-modules-languages-features-UpToDateStatusProviderFactoryImpl.instance")) != null) {
                                f.delete();
                            }
                            if ((f = root.getFileObject("run_script.instance")) != null) {
                                f.delete();
                            }
                        }
                        if ((oldSidebar = root.getFileObject("SideBar/org-netbeans-modules-editor-retouche-GsfCodeFoldingSideBarFactory.instance")) != null) {
                            oldSidebar.delete();
                            oldSidebar = root.getFileObject("FoldManager/org-netbeans-modules-retouche-editor-fold-GsfFoldManagerFactory.instance");
                            if (oldSidebar != null) {
                                oldSidebar.delete();
                            }
                        }
                        if ((hyperlinkProvider = root.getFileObject("HyperlinkProviders/GsfHyperlinkProvider.instance")) != null) {
                            hyperlinkProvider.delete();
                        }
                        if ((fo = root.getFileObject("HyperlinkProviders")) != null && fo.getChildren().length == 0) {
                            fo.delete();
                        }
                        if ((popup = root.getFileObject("Popup")) != null) {
                            FileObject gotoF;
                            FileObject ref = popup.getFileObject("in-place-refactoring");
                            if (ref != null) {
                                ref.delete();
                            }
                            if ((gotoF = popup.getFileObject("goto")) != null) {
                                fo = gotoF.getFileObject("goto-declaration");
                                if (fo != null) {
                                    fo.delete();
                                }
                                if ((fo = gotoF.getFileObject("goto")) != null) {
                                    fo.delete();
                                }
                                if (gotoF.getChildren().length == 0) {
                                    gotoF.delete();
                                }
                            }
                            if ((fo = popup.getFileObject("SeparatorBeforeCut.instance")) != null) {
                                fo.delete();
                            }
                            if ((fo = popup.getFileObject("format")) != null) {
                                fo.delete();
                            }
                            if ((fo = popup.getFileObject("SeparatorAfterFormat.instance")) != null) {
                                fo.delete();
                            }
                            if ((fo = popup.getFileObject("pretty-print")) != null) {
                                fo.delete();
                            }
                            if ((fo = popup.getFileObject("generate-goto-popup")) != null) {
                                fo.delete();
                            }
                            if (popup.getChildren().length == 0) {
                                popup.delete();
                            }
                        }
                        if ((fo = root.getFileObject("UpToDateStatusProvider/org-netbeans-modules-gsfret-hints-GsfUpToDateStateProviderFactory.instance")) != null) {
                            fo.delete();
                        }
                        if ((fo = root.getFileObject("UpToDateStatusProvider/org-netbeans-modules-retouche-hints-GsfUpToDateStateProviderFactory.instance")) != null) {
                            fo.delete();
                        }
                        if ((fo = root.getFileObject("UpToDateStatusProvider/org-netbeans-modules-gsfret-editor-semantic-OccurrencesMarkProviderCreator.instance")) != null) {
                            fo.delete();
                        }
                        if ((fo = root.getFileObject("UpToDateStatusProvider/org-netbeans-modules-retouche-editor-semantic-OccurrencesMarkProviderCreator.instance")) != null) {
                            fo.delete();
                        }
                        if ((fo = root.getFileObject("UpToDateStatusProvider")) != null && fo.getChildren().length == 0) {
                            fo.delete();
                        }
                        if ((fo = root.getFileObject("org-netbeans-modules-gsfret-editor-semantic-HighlightsLayerFactoryImpl.instance")) != null) {
                            fo.delete();
                        }
                        if ((completion = root.getFileObject(completionProviders = "CompletionProviders")) != null) {
                            FileObject old2;
                            String templates = "org-netbeans-lib-editor-codetemplates-CodeTemplateCompletionProvider.instance";
                            FileObject templeteProvider = root.getFileObject(completionProviders + "/" + templates);
                            if (templeteProvider != null) {
                                templeteProvider.delete();
                            }
                            String provider = "org-netbeans-modules-gsfret-editor-completion-GsfCompletionProvider.instance";
                            FileObject completionProvider = root.getFileObject(completionProviders + "/" + provider);
                            if (completionProvider != null) {
                                completionProvider.delete();
                            }
                            if ((old2 = completion.getFileObject("org-netbeans-modules-retouche-editor-completion-GsfCompletionProvider.instance")) != null) {
                                old2.delete();
                            }
                            if (completion.getChildren().length == 0) {
                                completion.delete();
                            }
                        }
                        if ((fo = root.getFileObject("Toolbars/Default/comment")) != null) {
                            fo.delete();
                        }
                        if ((fo = root.getFileObject("Toolbars/Default/uncomment")) != null) {
                            fo.delete();
                        }
                        if ((sep = root.getFileObject("Toolbars/Default/Separator-before-comment.instance")) != null) {
                            sep.delete();
                        }
                        if ((fo = root.getFileObject("Toolbars/Default")) != null && fo.getChildren().length == 0) {
                            fo.delete();
                            fo = root.getFileObject("Toolbars");
                            if (fo != null && fo.getChildren().length == 0) {
                                fo.delete();
                            }
                        }
                        if ((fo = root.getFileObject("CodeTemplateProcessorFactories/org-netbeans-modules-gsfret-editor-codetemplates-GsfCodeTemplateProcessor$Factory.instance")) != null) {
                            fo.delete();
                        }
                        if ((old = root.getFileObject("CodeTemplateProcessorFactories/org-netbeans-modules-retouche-editor-codetemplates-GsfCodeTemplateProcessor$Factory.instance")) != null) {
                            old.delete();
                        }
                        if ((fo = root.getFileObject("CodeTemplateProcessorFactories")) != null && fo.getChildren().length == 0) {
                            fo.delete();
                        }
                        if ((fo = root.getFileObject("CodeTemplateFilterFactories/org-netbeans-modules-gsfret-editor-codetemplates-GsfCodeTemplateFilter$Factory.instance")) != null) {
                            fo.delete();
                        }
                        if ((old = root.getFileObject("CodeTemplateFilterFactories/org-netbeans-modules-retouche-editor-codetemplates-GsfCodeTemplateFilter$Factory.instance")) != null) {
                            old.delete();
                        }
                        if ((fo = root.getFileObject("CodeTemplateFilterFactories")) != null && fo.getChildren().length == 0) {
                            fo.delete();
                        }
                        if (innerMime.getChildren().length != 0) continue;
                        innerMime.delete();
                    }
                    if (outerMime.getChildren().length != 0) continue;
                    outerMime.delete();
                }
            }
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
    }

    static {
        warnedPaths = Collections.synchronizedSet(new HashSet());
    }

    private final class FsTracker
    implements FileChangeListener,
    Runnable {
        private final FileSystem fs;
        private RequestProcessor.Task slidingTask = RequestProcessor.getDefault().create((Runnable)this);

        public FsTracker(FileSystem fs) {
            this.fs = fs;
            if (this.fs != null) {
                this.fs.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this, (Object)this.fs));
            }
        }

        public void fileFolderCreated(FileEvent fe) {
            this.process(fe);
        }

        public void fileDataCreated(FileEvent fe) {
            this.process(fe);
        }

        public void fileChanged(FileEvent fe) {
            this.process(fe);
        }

        public void fileDeleted(FileEvent fe) {
            this.process(fe);
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.process((FileEvent)fe);
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
            this.process((FileEvent)fe);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void process(FileEvent fe) {
            if (fe.getFile().getPath().startsWith(LanguageRegistry.FOLDER)) {
                LanguageRegistry languageRegistry = LanguageRegistry.this;
                synchronized (languageRegistry) {
                    LanguageRegistry.this.cacheDirty = true;
                    this.slidingTask.schedule(100);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LanguageRegistry languageRegistry = LanguageRegistry.this;
            synchronized (languageRegistry) {
                if (LanguageRegistry.this.cacheDirty) {
                    LanguageRegistry.this.cacheDirty = false;
                    LanguageRegistry.this.languagesCache = LanguageRegistry.readSfs(this.fs, LanguageRegistry.this.languagesCache);
                    ((GsfDataLoader)GsfDataLoader.getLoader(GsfDataLoader.class)).initExtensions();
                }
            }
        }
    }
}

