/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jackpot.impl.pm;

import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.TreeScanner;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.jackpot.impl.Utilities;
import org.netbeans.modules.java.hints.jackpot.impl.pm.BulkSearch;
import org.netbeans.modules.java.hints.jackpot.impl.pm.NFA;
import org.openide.util.Exceptions;

public class NFABasedBulkSearch
extends BulkSearch {
    private static final Map<Tree.Kind, byte[]> kind2Encoded = new EnumMap<Tree.Kind, byte[]>(Tree.Kind.class);
    private static final Map<Integer, Tree.Kind> encoded2Kind = new HashMap<Integer, Tree.Kind>();

    public NFABasedBulkSearch() {
        super(false);
    }

    @Override
    public Map<String, Collection<TreePath>> match(CompilationInfo compilationInfo, TreePath treePath, BulkSearch.BulkPattern bulkPattern, Map<String, Long> map) {
        BulkPatternImpl bulkPatternImpl = (BulkPatternImpl)bulkPattern;
        final HashMap<String, Collection<TreePath>> hashMap = new HashMap<String, Collection<TreePath>>();
        final NFA<Input, Res> nFA = bulkPatternImpl.toNFA();
        new TreePathScanner<Void, Void>(){
            private NFA.State active;
            {
                this.active = nFA.getStartingState();
            }

            @Override
            public Void scan(Tree tree, Void void_) {
                if (tree == null) {
                    return null;
                }
                boolean[] blArray = new boolean[1];
                NFA.State state = nFA.transition(this.active, new Input(Tree.Kind.IDENTIFIER, "$", false));
                Input[] inputArray = new Input[1];
                Input input = NFABasedBulkSearch.normalizeInput(tree, blArray, inputArray);
                NFA.State state2 = inputArray[0] != null ? nFA.transition(this.active, inputArray[0]) : null;
                this.active = nFA.transition(this.active, input);
                if (blArray[0]) {
                    super.scan(tree, void_);
                }
                NFA.State state3 = nFA.transition(this.active, new Input(input.kind, input.name, true));
                NFA.State state4 = nFA.transition(state, new Input(Tree.Kind.IDENTIFIER, "$", true));
                if (state2 != null) {
                    NFA.State state5 = nFA.transition(state2, new Input(inputArray[0].kind, inputArray[0].name, true));
                    this.active = nFA.join(nFA.join(state3, state4), state5);
                } else {
                    this.active = nFA.join(state3, state4);
                }
                for (Res res : nFA.getResults(this.active)) {
                    this.addOccurrence(res, tree);
                }
                return null;
            }

            private void addOccurrence(Res res, Tree tree) {
                LinkedList<TreePath> linkedList = (LinkedList<TreePath>)hashMap.get(res.pattern);
                if (linkedList == null) {
                    linkedList = new LinkedList<TreePath>();
                    hashMap.put(res.pattern, linkedList);
                }
                linkedList.add(new TreePath(this.getCurrentPath(), tree));
            }
        }.scan(treePath, (Void)null);
        return hashMap;
    }

    @Override
    public BulkSearch.BulkPattern create(Collection<? extends String> collection, Collection<? extends Tree> collection2) {
        int n = 0;
        final int[] nArray = new int[]{1};
        final LinkedHashMap linkedHashMap = new LinkedHashMap();
        HashMap<Integer, Res> hashMap = new HashMap<Integer, Res>();
        LinkedList linkedList = new LinkedList();
        LinkedList linkedList2 = new LinkedList();
        Iterator<? extends String> iterator = collection.iterator();
        for (final Tree tree : collection2) {
            final int[] nArray2 = new int[]{n};
            final HashSet hashSet = new HashSet();
            final HashSet hashSet2 = new HashSet();
            linkedList.add(hashSet);
            linkedList2.add(hashSet2);
            class Scanner
            extends TreeScanner<Void, Void> {
                Scanner() {
                }

                @Override
                public Void scan(Tree tree2, Void void_) {
                    Input input;
                    Input[] inputArray;
                    Object object;
                    if (tree2 == null) {
                        return null;
                    }
                    if (Utilities.isMultistatementWildcardTree(tree2)) {
                        int n = nArray[0];
                        nArray[0] = n + 1;
                        int n2 = n;
                        NFABasedBulkSearch.setBit(linkedHashMap, NFA.Key.create(nArray2[0], new Input(Tree.Kind.IDENTIFIER, "$", false)), n2);
                        NFABasedBulkSearch.setBit(linkedHashMap, NFA.Key.create(n2, new Input(Tree.Kind.IDENTIFIER, "$", true)), nArray2[0]);
                        return null;
                    }
                    if (tree2.getKind() == Tree.Kind.BLOCK) {
                        object = null;
                        inputArray = (Input[])tree2;
                        if (!inputArray.isStatic()) {
                            switch (inputArray.getStatements().size()) {
                                case 1: {
                                    object = inputArray.getStatements().get(0);
                                    break;
                                }
                                case 2: {
                                    if (Utilities.isMultistatementWildcardTree(inputArray.getStatements().get(0))) {
                                        object = inputArray.getStatements().get(1);
                                        break;
                                    }
                                    if (!Utilities.isMultistatementWildcardTree(inputArray.getStatements().get(1))) break;
                                    object = inputArray.getStatements().get(0);
                                    break;
                                }
                                case 3: {
                                    if (!Utilities.isMultistatementWildcardTree(inputArray.getStatements().get(0)) || !Utilities.isMultistatementWildcardTree(inputArray.getStatements().get(2))) break;
                                    object = inputArray.getStatements().get(1);
                                }
                            }
                        }
                        if (object != null) {
                            int n = nArray2[0];
                            this.scan((Tree)object, null);
                            int n3 = nArray2[0];
                            nArray[0] = nArray[0] + 1;
                            NFABasedBulkSearch.setBit(linkedHashMap, NFA.Key.create(n, new Input(Tree.Kind.BLOCK, null, false)), nArray2[0]);
                            for (StatementTree statementTree : inputArray.getStatements()) {
                                this.scan((Tree)statementTree, null);
                            }
                            NFABasedBulkSearch.setBit(linkedHashMap, NFA.Key.create(nArray2[0], new Input(Tree.Kind.BLOCK, null, true)), n3);
                            nArray2[0] = n3;
                            return null;
                        }
                    }
                    if ((input = NFABasedBulkSearch.normalizeInput(tree2, object = new boolean[1], inputArray = new Input[1])).name == null) {
                        hashSet2.add(input.kind.name());
                    } else if (!"$".equals(input.name) && !Utilities.isPureMemberSelect(tree2, false)) {
                        hashSet.add(input.name);
                    }
                    int n = nArray2[0];
                    this.handleTree(input, (boolean[])object, tree2, inputArray);
                    if (StatementTree.class.isAssignableFrom(tree2.getKind().asInterface()) && tree2 != tree) {
                        int n4 = nArray2[0];
                        nArray[0] = nArray[0] + 1;
                        NFABasedBulkSearch.setBit(linkedHashMap, NFA.Key.create(n, new Input(Tree.Kind.BLOCK, null, false)), nArray2[0]);
                        this.handleTree(input, (boolean[])object, tree2, inputArray);
                        NFABasedBulkSearch.setBit(linkedHashMap, NFA.Key.create(nArray2[0], new Input(Tree.Kind.BLOCK, null, true)), n4);
                        nArray2[0] = n4;
                    }
                    return null;
                }

                private void handleTree(Input input, boolean[] blArray, Tree tree2, Input[] inputArray) {
                    int n = nArray2[0];
                    nArray[0] = nArray[0] + 1;
                    NFABasedBulkSearch.setBit(linkedHashMap, NFA.Key.create(n, input), nArray2[0]);
                    if (blArray[0]) {
                        super.scan(tree2, null);
                    }
                    if (inputArray[0] != null) {
                        NFABasedBulkSearch.setBit(linkedHashMap, NFA.Key.create(n, inputArray[0]), nArray2[0]);
                    }
                    int n2 = nArray[0];
                    nArray[0] = n2 + 1;
                    int n3 = n2;
                    NFABasedBulkSearch.setBit(linkedHashMap, NFA.Key.create(nArray2[0], new Input(input.kind, input.name, true)), n3);
                    if (inputArray[0] != null) {
                        NFABasedBulkSearch.setBit(linkedHashMap, NFA.Key.create(nArray2[0], new Input(inputArray[0].kind, inputArray[0].name, true)), n3);
                    }
                    nArray2[0] = n3;
                }
            }
            Scanner scanner = new Scanner();
            scanner.scan(tree, null);
            hashMap.put(nArray2[0], new Res(iterator.next()));
        }
        NFA nFA = NFA.create(n, nArray[0], null, linkedHashMap, hashMap);
        return BulkPatternImpl.create(linkedList, linkedList2, nFA);
    }

    private static void setBit(Map<NFA.Key<Input>, NFA.State> map, NFA.Key<Input> key, int n) {
        NFA.State state = map.get(key);
        if (state == null) {
            state = NFA.State.create();
            map.put(key, state);
        }
        state.mutableOr(n);
    }

    private static Input normalizeInput(Tree tree, boolean[] blArray, Input[] inputArray) {
        if (tree.getKind() == Tree.Kind.IDENTIFIER && ((IdentifierTree)tree).getName().toString().startsWith("$")) {
            blArray[0] = false;
            return new Input(Tree.Kind.IDENTIFIER, "$", false);
        }
        if (Utilities.getWildcardTreeName(tree) != null) {
            blArray[0] = false;
            return new Input(Tree.Kind.IDENTIFIER, "$", false);
        }
        if (tree.getKind() == Tree.Kind.IDENTIFIER) {
            blArray[0] = false;
            String string = ((IdentifierTree)tree).getName().toString();
            return new Input(Tree.Kind.IDENTIFIER, string, false);
        }
        if (tree.getKind() == Tree.Kind.MEMBER_SELECT) {
            String string = ((MemberSelectTree)tree).getIdentifier().toString();
            if (string.startsWith("$")) {
                blArray[0] = false;
                return new Input(Tree.Kind.IDENTIFIER, "$", false);
            }
            if (inputArray != null && Utilities.isPureMemberSelect(tree, true)) {
                inputArray[0] = new Input(Tree.Kind.IDENTIFIER, string, false);
            }
            blArray[0] = true;
            return new Input(Tree.Kind.MEMBER_SELECT, string, false);
        }
        blArray[0] = true;
        return new Input(tree.getKind(), null, false);
    }

    @Override
    public boolean matches(CompilationInfo compilationInfo, TreePath treePath, BulkSearch.BulkPattern bulkPattern) {
        return !this.match(compilationInfo, treePath, bulkPattern).isEmpty();
    }

    @Override
    public void encode(Tree tree, final BulkSearch.EncodingContext encodingContext) {
        final HashSet hashSet = new HashSet();
        final HashSet hashSet2 = new HashSet();
        new TreeScanner<Void, Void>(){

            @Override
            public Void scan(Tree tree, Void void_) {
                if (tree == null) {
                    return null;
                }
                if (tree instanceof StatementTree && Utilities.isMultistatementWildcardTree((StatementTree)tree)) {
                    return null;
                }
                boolean[] blArray = new boolean[1];
                Input input = NFABasedBulkSearch.normalizeInput(tree, blArray, null);
                try {
                    encodingContext.getOut().write(40);
                    encodingContext.getOut().write((byte[])kind2Encoded.get((Object)input.kind));
                    if (input.name == null) {
                        hashSet2.add(input.kind.name());
                    } else {
                        hashSet.add(input.name);
                        encodingContext.getOut().write(36);
                        encodingContext.getOut().write(input.name.getBytes("UTF-8"));
                        encodingContext.getOut().write(59);
                    }
                    if (blArray[0]) {
                        super.scan(tree, void_);
                    }
                    encodingContext.getOut().write(41);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
                return null;
            }
        }.scan(tree, (Void)null);
        encodingContext.setIdentifiers(hashSet);
        encodingContext.setKinds(hashSet2);
    }

    @Override
    public boolean matches(InputStream inputStream, BulkSearch.BulkPattern bulkPattern) {
        try {
            return this.matchesImpl(inputStream, bulkPattern);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return false;
        }
    }

    private boolean matchesImpl(InputStream inputStream, BulkSearch.BulkPattern bulkPattern) throws IOException {
        BulkPatternImpl bulkPatternImpl = (BulkPatternImpl)bulkPattern;
        NFA<Input, Res> nFA = bulkPatternImpl.toNFA();
        Stack<Object> stack = new Stack<Object>();
        Stack<Object> stack2 = new Stack<Object>();
        Stack<NFA.State> stack3 = new Stack<NFA.State>();
        NFA.State state = nFA.getStartingState();
        int n = inputStream.read();
        while (n != -1) {
            NFA.State state2;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            if (n == 40) {
                n = inputStream.read();
                object4 = encoded2Kind.get((n << 8) + inputStream.read());
                n = inputStream.read();
                if (n == 36) {
                    n = inputStream.read();
                    object3 = new ByteArrayOutputStream();
                    while (n != 59) {
                        ((ByteArrayOutputStream)object3).write(n);
                        n = inputStream.read();
                    }
                    n = inputStream.read();
                    object2 = new String(((ByteArrayOutputStream)object3).toByteArray(), "UTF-8");
                } else {
                    object2 = null;
                }
                object3 = nFA.transition(state, new Input(Tree.Kind.IDENTIFIER, "$", false));
                object = new Input((Tree.Kind)((Object)object4), (String)object2, false);
                state2 = object4 == Tree.Kind.MEMBER_SELECT && object2 != null ? nFA.transition(state, new Input(Tree.Kind.IDENTIFIER, (String)object2, false)) : null;
                state = nFA.transition(state, (Input)object);
                stack.push(object);
                stack2.push(object3);
                stack3.push(state2);
                continue;
            }
            object4 = (Input)stack.pop();
            object2 = (NFA.State)stack2.pop();
            object3 = nFA.transition(state, new Input(((Input)object4).kind, ((Input)object4).name, true));
            object = nFA.transition((NFA.State)object2, new Input(Tree.Kind.IDENTIFIER, "$", true));
            state2 = (NFA.State)stack3.pop();
            if (state2 != null) {
                NFA.State state3 = nFA.transition(state2, new Input(Tree.Kind.IDENTIFIER, ((Input)object4).name, true));
                state = nFA.join(nFA.join((NFA.State)object3, (NFA.State)object), state3);
            } else {
                state = nFA.join((NFA.State)object3, (NFA.State)object);
            }
            if (!nFA.getResults(state).isEmpty()) {
                return true;
            }
            n = inputStream.read();
        }
        return false;
    }

    static {
        for (Tree.Kind kind : Tree.Kind.values()) {
            String string = Integer.toHexString(kind.ordinal());
            if (string.length() < 2) {
                string = "0" + string;
            }
            try {
                byte[] byArray = string.getBytes("UTF-8");
                assert (byArray.length == 2);
                kind2Encoded.put(kind, byArray);
                encoded2Kind.put((byArray[0] << 8) + byArray[1], kind);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new IllegalStateException(unsupportedEncodingException);
            }
        }
    }

    private static final class Input {
        private final Tree.Kind kind;
        private final String name;
        private final boolean end;

        private Input(Tree.Kind kind, String string, boolean bl) {
            this.kind = kind;
            this.name = string;
            this.end = bl;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Input input = (Input)object;
            if (this.kind != input.kind) {
                return false;
            }
            if (this.name == null ? input.name != null : !this.name.equals(input.name)) {
                return false;
            }
            return this.end == input.end;
        }

        public int hashCode() {
            int n = 7;
            n = 47 * n + (this.kind != null ? this.kind.hashCode() : 17);
            n = 47 * n + (this.name != null ? this.name.hashCode() : 0);
            n = 47 * n + (this.end ? 1 : 0);
            return n;
        }

        public String toString() {
            return (Object)((Object)this.kind) + ", " + this.name + ", " + this.end;
        }
    }

    private static final class Res {
        private final String pattern;

        public Res(String string) {
            this.pattern = string;
        }
    }

    public static class BulkPatternImpl
    extends BulkSearch.BulkPattern {
        private final NFA<Input, Res> nfa;

        private BulkPatternImpl(List<? extends Set<? extends String>> list, List<? extends Set<? extends String>> list2, NFA<Input, Res> nFA) {
            super(list, list2);
            this.nfa = nFA;
        }

        NFA<Input, Res> toNFA() {
            return this.nfa;
        }

        private static BulkSearch.BulkPattern create(List<? extends Set<? extends String>> list, List<? extends Set<? extends String>> list2, NFA<Input, Res> nFA) {
            return new BulkPatternImpl(list, list2, nFA);
        }
    }
}

