/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.LoggerNotStaticFinal;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.modules.java.hints.jackpot.spi.support.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class SystemOut {
    public static ErrorDescription checkSystemOut(HintContext hintContext) {
        TreePath treePath = hintContext.getPath();
        CompilationInfo compilationInfo = hintContext.getInfo();
        return ErrorDescriptionFactory.forName(hintContext, treePath, NbBundle.getMessage(SystemOut.class, (String)"MSG_SystemOut"), new FixImpl(NbBundle.getMessage(LoggerNotStaticFinal.class, (String)"MSG_SystemOut_fix"), TreePathHandle.create((TreePath)treePath, (CompilationInfo)compilationInfo)));
    }

    private static final class FixImpl
    implements Fix {
        private final String text;
        private final TreePathHandle treePathHandle;

        public FixImpl(String string, TreePathHandle treePathHandle) {
            this.text = string;
            this.treePathHandle = treePathHandle;
        }

        public String getText() {
            return this.text;
        }

        public ChangeInfo implement() throws Exception {
            JavaSource.forFileObject((FileObject)this.treePathHandle.getFileObject()).runModificationTask((Task)new Task<WorkingCopy>(){

                public void run(WorkingCopy workingCopy) throws Exception {
                    workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                    TreePath treePath = FixImpl.this.treePathHandle.resolve((CompilationInfo)workingCopy);
                    if (treePath == null) {
                        return;
                    }
                    TreePath treePath2 = treePath.getParentPath();
                    while (!(treePath2.getLeaf() instanceof BlockTree)) {
                        treePath = treePath2;
                        if ((treePath2 = treePath2.getParentPath()) != null) continue;
                        return;
                    }
                    BlockTree blockTree = (BlockTree)treePath2.getLeaf();
                    List<? extends StatementTree> list = blockTree.getStatements();
                    ArrayList<StatementTree> arrayList = new ArrayList<StatementTree>();
                    for (StatementTree statementTree : list) {
                        if (statementTree == treePath.getLeaf()) continue;
                        arrayList.add(statementTree);
                    }
                    BlockTree blockTree2 = workingCopy.getTreeMaker().Block(arrayList, true);
                    workingCopy.rewrite((Tree)blockTree, (Tree)blockTree2);
                }
            }).commit();
            return null;
        }
    }
}

