/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.lib.ddl.DDLException;
import org.netbeans.modules.db.ExceptionListener;
import org.netbeans.modules.db.explorer.ConnectionList;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DbUtilities;
import org.netbeans.modules.db.explorer.action.BaseAction;
import org.netbeans.modules.db.explorer.dlg.ConnectionDialog;
import org.netbeans.modules.db.explorer.dlg.ConnectionDialogMediator;
import org.netbeans.modules.db.explorer.dlg.NewConnectionPanel;
import org.netbeans.modules.db.explorer.dlg.SchemaPanel;
import org.netbeans.modules.db.explorer.driver.JDBCDriverSupport;
import org.netbeans.modules.db.explorer.node.DriverNode;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ConnectUsingDriverAction
extends BaseAction {
    private static final Logger LOGGER = Logger.getLogger(ConnectUsingDriverAction.class.getName());

    public String getName() {
        return NbBundle.getMessage(ConnectUsingDriverAction.class, (String)"ConnectUsing");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ConnectUsingDriverAction.class);
    }

    protected boolean enable(Node[] activatedNodes) {
        return activatedNodes != null && activatedNodes.length == 1;
    }

    public void performAction(Node[] activatedNodes) {
        Lookup lookup = activatedNodes[0].getLookup();
        DriverNode node = (DriverNode)((Object)lookup.lookup(DriverNode.class));
        if (node != null) {
            JDBCDriver driver = node.getDatabaseDriver().getJDBCDriver();
            new NewConnectionDialogDisplayer().showDialog(driver.getName(), driver.getClassName());
        }
    }

    public static final class NewConnectionDialogDisplayer
    extends ConnectionDialogMediator {
        ConnectionDialog dlg;
        boolean advancedPanel = false;
        boolean okPressed = false;
        RequestProcessor.Task activeTask = null;
        private NewConnectionPanel basePanel = null;
        private SchemaPanel schemaPanel = null;
        private DatabaseConnection cinfo = null;

        public void showDialog(String driverName, String driverClass) {
            this.showDialog(driverName, driverClass, null, null, null);
        }

        public DatabaseConnection showDialog(JDBCDriver driver, String databaseUrl, String user, String password) {
            String driverName = driver != null ? driver.getName() : null;
            String driverClass = driver != null ? driver.getClassName() : null;
            return this.showDialog(driverName, driverClass, databaseUrl, user, password);
        }

        public DatabaseConnection showDialog(String driverName, String driverClass, String databaseUrl, String user, String password) {
            JDBCDriver[] drivers;
            String finalDriverClass = null;
            if (null != databaseUrl && null != driverClass) {
                drivers = JDBCDriverManager.getDefault().getDrivers(driverClass);
                finalDriverClass = driverClass;
            } else {
                drivers = JDBCDriverManager.getDefault().getDrivers();
            }
            String selectedDriverName = null;
            String selectedDriverClass = null;
            if (driverName == null || driverClass == null) {
                for (int i = 0; i < drivers.length; ++i) {
                    if (!JDBCDriverSupport.isAvailable(drivers[i])) continue;
                    if (selectedDriverName == null) {
                        selectedDriverName = drivers[i].getName();
                        selectedDriverClass = drivers[i].getClassName();
                    }
                    if (!"org.apache.derby.jdbc.ClientDriver".equals(drivers[i].getClassName())) continue;
                    selectedDriverName = drivers[i].getName();
                    selectedDriverClass = drivers[i].getClassName();
                    break;
                }
            } else {
                selectedDriverName = driverName;
                selectedDriverClass = driverClass;
            }
            this.cinfo = new DatabaseConnection();
            this.cinfo.setDriverName(selectedDriverName);
            this.cinfo.setDriver(selectedDriverClass);
            if (user != null) {
                this.cinfo.setUser(user);
            }
            if (password != null) {
                this.cinfo.setPassword(password);
            }
            if (null != databaseUrl) {
                this.cinfo.setDatabase(databaseUrl);
            }
            this.basePanel = new NewConnectionPanel(this, finalDriverClass, this.cinfo);
            this.schemaPanel = new SchemaPanel(this, this.cinfo);
            PropertyChangeListener argumentListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent event) {
                    if (event.getPropertyName().equals("argumentChanged")) {
                        NewConnectionDialogDisplayer.this.schemaPanel.setSchemas(Collections.EMPTY_LIST, "");
                        NewConnectionDialogDisplayer.this.schemaPanel.resetProgress();
                        try {
                            Connection conn = NewConnectionDialogDisplayer.this.cinfo.getConnection();
                            if (DatabaseConnection.isVitalConnection(conn, NewConnectionDialogDisplayer.this.cinfo)) {
                                conn.close();
                            }
                        }
                        catch (SQLException exc) {
                            LOGGER.log(Level.FINE, null, exc);
                        }
                    }
                }
            };
            this.basePanel.addPropertyChangeListener(argumentListener);
            PropertyChangeListener connectionListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent event) {
                    if (event.getPropertyName().equals("connecting")) {
                        NewConnectionDialogDisplayer.this.fireConnectionStarted();
                    } else if (event.getPropertyName().equals("failed")) {
                        NewConnectionDialogDisplayer.this.setConnected(false);
                        NewConnectionDialogDisplayer.this.fireConnectionFailed();
                    } else {
                        if (event.getPropertyName().equals("connected")) {
                            try {
                                NewConnectionDialogDisplayer.this.cinfo.getConnector().finishConnect(null, NewConnectionDialogDisplayer.this.cinfo, NewConnectionDialogDisplayer.this.cinfo.getConnection());
                            }
                            catch (DatabaseException exc) {
                                LOGGER.log(Level.INFO, exc.getLocalizedMessage(), exc);
                                DbUtilities.reportError(NbBundle.getMessage(ConnectUsingDriverAction.class, (String)"ERR_UnableToInitializeConnection"), exc.getMessage());
                                return;
                            }
                            NewConnectionDialogDisplayer.this.setConnected(true);
                            boolean result = NewConnectionDialogDisplayer.this.retrieveSchemas(NewConnectionDialogDisplayer.this.schemaPanel, NewConnectionDialogDisplayer.this.cinfo, NewConnectionDialogDisplayer.this.cinfo.getUser());
                            NewConnectionDialogDisplayer.this.fireConnectionFinished();
                            if (result) {
                                NewConnectionDialogDisplayer.this.cinfo.setSchema(NewConnectionDialogDisplayer.this.schemaPanel.getSchema());
                            } else if (!NewConnectionDialogDisplayer.this.schemaPanel.schemasAvailable()) {
                                try {
                                    ConnectionList.getDefault().add(NewConnectionDialogDisplayer.this.cinfo);
                                }
                                catch (DatabaseException dbe) {
                                    LOGGER.log(Level.INFO, dbe.getLocalizedMessage(), dbe);
                                    DbUtilities.reportError(NbBundle.getMessage(ConnectUsingDriverAction.class, (String)"ERR_UnableToAddConnection"), dbe.getMessage());
                                    NewConnectionDialogDisplayer.this.cinfo.setConnection(null);
                                }
                                if (NewConnectionDialogDisplayer.this.dlg != null) {
                                    NewConnectionDialogDisplayer.this.dlg.close();
                                    return;
                                }
                            }
                            NewConnectionDialogDisplayer.this.dlg.setSelectedComponent(NewConnectionDialogDisplayer.this.schemaPanel);
                            return;
                        }
                        NewConnectionDialogDisplayer.this.okPressed = false;
                    }
                }
            };
            ExceptionListener excListener = new ExceptionListener(){

                @Override
                public void exceptionOccurred(Exception exc) {
                    if (exc instanceof DDLException) {
                        LOGGER.log(Level.INFO, null, exc.getCause());
                    } else {
                        LOGGER.log(Level.INFO, null, exc);
                    }
                    String message = null;
                    if (exc instanceof ClassNotFoundException) {
                        message = MessageFormat.format(NbBundle.getMessage(ConnectUsingDriverAction.class, (String)"EXC_ClassNotFound"), exc.getMessage());
                    } else {
                        StringBuilder buffer = new StringBuilder();
                        buffer.append(DbUtilities.formatError(NbBundle.getMessage(ConnectUsingDriverAction.class, (String)"ERR_UnableToAddConnection"), exc.getMessage()));
                        if (exc instanceof DDLException && exc.getCause() instanceof SQLException) {
                            for (SQLException sqlEx = ((SQLException)exc.getCause()).getNextException(); sqlEx != null; sqlEx = sqlEx.getNextException()) {
                                buffer.append("\n\n").append(sqlEx.getMessage());
                            }
                        }
                        message = buffer.toString();
                    }
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
                }
            };
            this.cinfo.addPropertyChangeListener(connectionListener);
            this.cinfo.addExceptionListener(excListener);
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    if (event.getSource() == DialogDescriptor.OK_OPTION) {
                        NewConnectionDialogDisplayer.this.okPressed = true;
                        NewConnectionDialogDisplayer.this.basePanel.setConnectionInfo();
                        try {
                            if (!DatabaseConnection.isVitalConnection(NewConnectionDialogDisplayer.this.cinfo.getConnection(), NewConnectionDialogDisplayer.this.cinfo)) {
                                NewConnectionDialogDisplayer.this.activeTask = NewConnectionDialogDisplayer.this.cinfo.connectAsync();
                            } else {
                                NewConnectionDialogDisplayer.this.cinfo.setSchema(NewConnectionDialogDisplayer.this.schemaPanel.getSchema());
                                ConnectionList.getDefault().add(NewConnectionDialogDisplayer.this.cinfo);
                                if (NewConnectionDialogDisplayer.this.dlg != null) {
                                    NewConnectionDialogDisplayer.this.cancelActiveTask();
                                    NewConnectionDialogDisplayer.this.dlg.close();
                                }
                            }
                        }
                        catch (DatabaseException exc) {
                            LOGGER.log(Level.INFO, exc.getLocalizedMessage(), exc);
                            DbUtilities.reportError(NbBundle.getMessage(ConnectUsingDriverAction.class, (String)"ERR_UnableToAddConnection"), exc.getMessage());
                            NewConnectionDialogDisplayer.this.closeConnection();
                        }
                        return;
                    }
                    if (event.getSource() == DialogDescriptor.CANCEL_OPTION && NewConnectionDialogDisplayer.this.dlg != null) {
                        NewConnectionDialogDisplayer.this.cancelActiveTask();
                    }
                }
            };
            ChangeListener changeTabListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (((JTabbedPane)e.getSource()).getSelectedComponent().equals(NewConnectionDialogDisplayer.this.schemaPanel)) {
                        NewConnectionDialogDisplayer.this.advancedPanel = true;
                        NewConnectionDialogDisplayer.this.basePanel.setConnectionInfo();
                    } else {
                        NewConnectionDialogDisplayer.this.advancedPanel = false;
                    }
                }
            };
            this.dlg = new ConnectionDialog(this, this.basePanel, this.schemaPanel, this.basePanel.getTitle(), new HelpCtx("new_db_save_password"), actionListener, changeTabListener);
            this.basePanel.setWindow(this.dlg.getWindow());
            this.dlg.setVisible(true);
            this.cinfo.removeExceptionListener(excListener);
            this.cinfo.removePropertyChangeListener(connectionListener);
            this.cinfo.fireConnectionComplete();
            return ConnectionList.getDefault().getConnection(this.cinfo);
        }

        private void cancelActiveTask() {
            if (this.activeTask != null) {
                this.activeTask.cancel();
                this.activeTask = null;
            }
            this.basePanel.terminateProgress();
            this.schemaPanel.terminateProgress();
        }

        @Override
        public void closeConnection() {
            Connection conn;
            if (this.cinfo != null && (conn = this.cinfo.getConnection()) != null) {
                try {
                    conn.close();
                    this.cinfo.setConnection(null);
                }
                catch (SQLException e) {
                    this.cinfo.setConnection(null);
                }
            }
            this.setConnected(false);
        }

        @Override
        protected RequestProcessor.Task retrieveSchemasAsync(SchemaPanel schemaPanel, DatabaseConnection dbcon, String defaultSchema) {
            this.activeTask = super.retrieveSchemasAsync(schemaPanel, dbcon, defaultSchema);
            return this.activeTask;
        }

        @Override
        protected boolean retrieveSchemas(SchemaPanel schemaPanel, DatabaseConnection dbcon, String defaultSchema) {
            this.fireConnectionStep(NbBundle.getMessage(ConnectUsingDriverAction.class, (String)"ConnectionProgress_Schemas"));
            ArrayList<String> schemas = new ArrayList<String>();
            try {
                ResultSet rs;
                DatabaseMetaData dbMetaData = dbcon.getConnection().getMetaData();
                if (dbMetaData.supportsSchemasInTableDefinitions() && (rs = dbMetaData.getSchemas()) != null) {
                    while (rs.next()) {
                        schemas.add(rs.getString(1).trim());
                    }
                }
            }
            catch (SQLException exc) {
                String message = NbBundle.getMessage(ConnectUsingDriverAction.class, (String)"ERR_UnableObtainSchemas", (Object)exc.getMessage());
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
            }
            return schemaPanel.setSchemas(schemas, defaultSchema);
        }
    }
}

