/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ext.ffi;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyModule;
import org.jruby.nb.anno.JRubyClass;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.ext.ffi.AbstractMemory;
import org.jruby.nb.ext.ffi.FFIProvider;
import org.jruby.nb.ext.ffi.MemoryIO;
import org.jruby.nb.ext.ffi.Util;
import org.jruby.nb.runtime.ObjectAllocator;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

@JRubyClass(name={"AbstractMemoryPointer"}, parent="AbstractMemory")
public abstract class AbstractMemoryPointer
extends AbstractMemory {
    public static final String className = "AbstractMemoryPointer";
    private static final Map<AbstractMemoryPointer, Object> pointerSet = new ConcurrentHashMap<AbstractMemoryPointer, Object>();

    public static RubyClass createMemoryPointerClass(Ruby runtime) {
        RubyModule module = FFIProvider.getModule(runtime);
        RubyClass result = module.defineClassUnder(className, module.getClass("AbstractMemory"), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        result.defineAnnotatedMethods(AbstractMemoryPointer.class);
        result.defineAnnotatedConstants(AbstractMemoryPointer.class);
        return result;
    }

    protected AbstractMemoryPointer(Ruby runtime, RubyClass klass, MemoryIO io, long offset, long size) {
        super(runtime, klass, io, offset, size);
    }

    @JRubyMethod(name={"null?"})
    public IRubyObject null_p(ThreadContext context) {
        return context.getRuntime().newBoolean(this.getMemoryIO().isNull());
    }

    @JRubyMethod(name={"read_pointer"})
    public IRubyObject read_pointer(ThreadContext context) {
        return this.getMemoryPointer(context.getRuntime(), 0L);
    }

    @JRubyMethod(name={"get_buffer"}, required=2)
    public IRubyObject get_buffer(ThreadContext context, IRubyObject off, IRubyObject len_) {
        int len = Util.int32Value(len_);
        ByteList bl = new ByteList(len);
        this.getMemoryIO().get(this.getOffset(off), bl.unsafeBytes(), bl.begin(), len);
        bl.length(len);
        return context.getRuntime().newString(bl);
    }

    @JRubyMethod(name={"put_buffer"}, required=3)
    public IRubyObject put_buffer(ThreadContext context, IRubyObject off, IRubyObject str, IRubyObject len_) {
        ByteList bl = str.convertToString().getByteList();
        int len = Math.min(bl.length(), Util.int32Value(len_));
        this.getMemoryIO().put(this.getOffset(off), bl.unsafeBytes(), bl.begin(), len);
        return context.getRuntime().newFixnum(len);
    }

    @JRubyMethod(name={"free"})
    public IRubyObject free(ThreadContext context) {
        pointerSet.remove(this);
        return context.getRuntime().getNil();
    }

    @JRubyMethod(name={"autorelease="}, required=1)
    public IRubyObject autorelease(ThreadContext context, IRubyObject release) {
        if (release.isTrue()) {
            pointerSet.remove(this);
        } else {
            pointerSet.put(this, Boolean.TRUE);
        }
        return context.getRuntime().getNil();
    }
}

