/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import java.util.List;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyModule;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.types.INameNode;
import org.jruby.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.evaluator.Instruction;
import org.jruby.nb.exceptions.JumpException;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class Colon3Node
extends Node
implements INameNode {
    protected String name;

    public Colon3Node(ISourcePosition position, String name) {
        super(position, NodeType.COLON3NODE);
        this.name = name;
    }

    public Colon3Node(ISourcePosition position, NodeType id, String name) {
        super(position, id);
        this.name = name;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitColon3Node(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }

    public void setName(String name) {
        this.name = name;
    }

    public RubyModule getEnclosingModule(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        return runtime.getObject();
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        return runtime.getObject().fastGetConstantFrom(this.name);
    }

    @Override
    public String definition(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        try {
            RubyClass left = runtime.getObject();
            if (left.fastGetConstantAt(this.name) != null) {
                return "constant";
            }
            if (left.getMetaClass().isMethodBound(this.name, true)) {
                return "method";
            }
        }
        catch (JumpException excptn) {
            // empty catch block
        }
        return null;
    }
}

