/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLDeploymentManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WLPluginProperties {
    private static final Logger LOGGER = Logger.getLogger(WLPluginProperties.class.getName());
    private static final String CONFIG_XML = "config/config.xml";
    private static final String DOMAIN_LIB_DIR = "lib";
    public static final String SERVER_ROOT_ATTR = "serverRoot";
    public static final String DOMAIN_ROOT_ATTR = "domainRoot";
    public static final String HOST_ATTR = "host";
    public static final String PORT_ATTR = "port";
    public static final String DEBUGGER_PORT_ATTR = "debuggerPort";
    private static WLPluginProperties pluginProperties = null;
    private String installLocation;
    private static final String INSTALL_ROOT_KEY = "installRoot";
    private FileObject propertiesFile = null;
    private static Collection fileColl = new ArrayList();

    public static synchronized WLPluginProperties getInstance() {
        if (pluginProperties == null) {
            pluginProperties = new WLPluginProperties();
        }
        return pluginProperties;
    }

    @CheckForNull
    public static File getDomainLibDirectory(WLDeploymentManager wLDeploymentManager) {
        File file;
        String string = wLDeploymentManager.getInstanceProperties().getProperty(DOMAIN_ROOT_ATTR);
        if (string != null && (file = new File(new File(string), DOMAIN_LIB_DIR)).exists() && file.isDirectory()) {
            return file;
        }
        return null;
    }

    @CheckForNull
    public static File getServerLibDirectory(WLDeploymentManager wLDeploymentManager) {
        File file;
        String string = wLDeploymentManager.getInstanceProperties().getProperty(SERVER_ROOT_ATTR);
        if (string != null && (file = new File(new File(string), DOMAIN_LIB_DIR)).exists() && file.isDirectory()) {
            return file;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private WLPluginProperties() {
        InputStream inputStream = null;
        try {
            try {
                this.propertiesFile = this.getPropertiesFile();
                if (null != this.propertiesFile) {
                    inputStream = this.propertiesFile.getInputStream();
                }
                this.loadPluginProperties(inputStream);
                if (null == inputStream) return;
            }
            catch (FileNotFoundException fileNotFoundException) {
                Logger.getLogger("global").log(Level.INFO, null, fileNotFoundException);
                this.loadPluginProperties(inputStream);
                if (null == inputStream) return;
                inputStream.close();
                return;
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.INFO, null, iOException);
                this.loadPluginProperties(inputStream);
                if (null == inputStream) return;
                {
                    catch (Throwable throwable) {
                        this.loadPluginProperties(inputStream);
                        if (null == inputStream) throw throwable;
                        inputStream.close();
                        throw throwable;
                    }
                }
                inputStream.close();
                return;
            }
            inputStream.close();
            return;
        }
        catch (IOException iOException) {
            Logger.getLogger("global").log(Level.INFO, null, iOException);
        }
    }

    void loadPluginProperties(InputStream inputStream) {
        String string;
        Properties properties = new Properties();
        if (null != inputStream) {
            try {
                properties.load(inputStream);
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.INFO, null, iOException);
            }
        }
        if ((string = properties.getProperty(INSTALL_ROOT_KEY)) != null) {
            this.setInstallLocation(string);
        }
    }

    private FileObject getPropertiesFile() throws IOException {
        FileObject fileObject = FileUtil.getConfigFile((String)"J2EE");
        FileObject fileObject2 = null;
        if (null != fileObject && null == (fileObject2 = fileObject.getFileObject("weblogic", "properties"))) {
            fileObject2 = fileObject.createData("weblogic", "properties");
        }
        return fileObject2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveProperties() {
        block11: {
            Properties properties = new Properties();
            String string = this.getInstallLocation();
            if (string != null) {
                properties.setProperty(INSTALL_ROOT_KEY, string);
            }
            FileLock fileLock = null;
            OutputStream outputStream = null;
            try {
                if (null == this.propertiesFile) break block11;
                try {
                    fileLock = this.propertiesFile.lock();
                    outputStream = this.propertiesFile.getOutputStream(fileLock);
                    if (null != outputStream) {
                        properties.store(outputStream, "");
                    }
                }
                catch (IOException iOException) {
                    Logger.getLogger("global").log(Level.INFO, null, iOException);
                }
                finally {
                    if (null != outputStream) {
                        outputStream.close();
                    }
                    if (null != fileLock) {
                        fileLock.releaseLock();
                    }
                }
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.INFO, null, iOException);
            }
        }
    }

    public static boolean isGoodServerLocation(File file) {
        return null != file && file.exists() && file.canRead() && file.isDirectory() && WLPluginProperties.hasRequiredChildren(file, fileColl);
    }

    public static boolean isSupportedVersion(Version version) {
        return version != null && ("9".equals(version.getMajorNumber()) || "10".equals(version.getMajorNumber()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Version getVersion(File file) {
        File file2 = new File(file, "server/lib/weblogic.jar");
        if (!file2.exists()) {
            return null;
        }
        try {
            JarFile jarFile = new JarFile(file2);
            try {
                Manifest manifest = jarFile.getManifest();
                String string = null;
                if (manifest != null) {
                    string = manifest.getMainAttributes().getValue("Implementation-Version");
                }
                if (string == null) return null;
                string = string.trim();
                Version version = new Version(string);
                return version;
            }
            finally {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.FINEST, null, iOException);
                }
            }
        }
        catch (IOException iOException) {
            LOGGER.log(Level.FINE, null, iOException);
        }
        return null;
    }

    public static String getWeblogicDomainVersion(String string) {
        File file = new File(string, CONFIG_XML);
        if (!file.exists()) {
            return null;
        }
        try {
            InputSource inputSource = new InputSource(new FileInputStream(file));
            Document document = XMLUtil.parse((InputSource)inputSource, (boolean)false, (boolean)false, null, null);
            if (document.getElementsByTagName("domain-version").getLength() > 0) {
                return document.getElementsByTagName("domain-version").item(0).getTextContent();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.getLogger("global").log(Level.INFO, null, fileNotFoundException);
        }
        catch (IOException iOException) {
            Logger.getLogger("global").log(Level.INFO, null, iOException);
        }
        catch (SAXException sAXException) {
            Logger.getLogger("global").log(Level.INFO, null, sAXException);
        }
        return null;
    }

    private static boolean hasRequiredChildren(File file, Collection collection) {
        if (null == file) {
            return false;
        }
        String[] stringArray = file.list();
        if (null == stringArray) {
            return false;
        }
        if (null == collection) {
            return true;
        }
        for (String string : collection) {
            File file2 = new File(file.getPath() + File.separator + string);
            if (file2.exists()) continue;
            return false;
        }
        return true;
    }

    public void setInstallLocation(String string) {
        if (string.endsWith("/") || string.endsWith("\\")) {
            string = string.substring(0, string.length() - 1);
        }
        this.installLocation = string;
    }

    public String getInstallLocation() {
        return this.installLocation;
    }

    static {
        fileColl.add("common");
        fileColl.add("common/bin");
        fileColl.add("server/lib/weblogic.jar");
        fileColl.add(".product.properties");
    }

    public static final class Version
    implements Comparable<Version> {
        private String majorNumber = "0";
        private String minorNumber = "0";
        private String microNumber = "0";
        private String update = "";

        public Version(String string) {
            assert (string != null) : "Version can't be null";
            String[] stringArray = string.split("\\.");
            if (stringArray.length >= 4) {
                this.update = stringArray[3];
            }
            if (stringArray.length >= 3) {
                this.microNumber = stringArray[2];
            }
            if (stringArray.length >= 2) {
                this.minorNumber = stringArray[1];
            }
            this.majorNumber = stringArray[0];
        }

        public String getMajorNumber() {
            return this.majorNumber;
        }

        public String getMinorNumber() {
            return this.minorNumber;
        }

        public String getMicroNumber() {
            return this.microNumber;
        }

        public String getUpdate() {
            return this.update;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Version version = (Version)object;
            if (!(this.majorNumber == version.majorNumber || this.majorNumber != null && this.majorNumber.equals(version.majorNumber))) {
                return false;
            }
            if (!(this.minorNumber == version.minorNumber || this.minorNumber != null && this.minorNumber.equals(version.minorNumber))) {
                return false;
            }
            if (!(this.microNumber == version.microNumber || this.microNumber != null && this.microNumber.equals(version.microNumber))) {
                return false;
            }
            return this.update == version.update || this.update != null && this.update.equals(version.update);
        }

        public int hashCode() {
            int n = 7;
            n = 17 * n + (this.majorNumber != null ? this.majorNumber.hashCode() : 0);
            n = 17 * n + (this.minorNumber != null ? this.minorNumber.hashCode() : 0);
            n = 17 * n + (this.microNumber != null ? this.microNumber.hashCode() : 0);
            n = 17 * n + (this.update != null ? this.update.hashCode() : 0);
            return n;
        }

        @Override
        public int compareTo(Version version) {
            int n = this.compareToIgnoreUpdate(version);
            if (n != 0) {
                return n;
            }
            return this.update.compareTo(version.update);
        }

        public int compareToIgnoreUpdate(Version version) {
            int n = this.majorNumber.compareTo(version.majorNumber);
            if (n != 0) {
                return n;
            }
            n = this.minorNumber.compareTo(version.minorNumber);
            if (n != 0) {
                return n;
            }
            return this.microNumber.compareTo(version.microNumber);
        }
    }
}

