/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.netbeans.Util;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;

public final class InstalledFileLocatorImpl
extends InstalledFileLocator {
    private final File[] dirs;
    private static Map<String, Map<File, Set<String>>> fileCache = null;

    public InstalledFileLocatorImpl() {
        ArrayList<File> _dirs = new ArrayList<File>();
        InstalledFileLocatorImpl.addDir(_dirs, System.getProperty("netbeans.user"));
        String nbdirs = System.getProperty("netbeans.dirs");
        if (nbdirs != null) {
            StringTokenizer tok = new StringTokenizer(nbdirs, File.pathSeparator);
            while (tok.hasMoreTokens()) {
                InstalledFileLocatorImpl.addDir(_dirs, tok.nextToken());
            }
        }
        InstalledFileLocatorImpl.addDir(_dirs, System.getProperty("netbeans.home"));
        this.dirs = _dirs.toArray(new File[_dirs.size()]);
    }

    private static void addDir(List<File> _dirs, String d) {
        File f;
        if (d != null && (f = new File(d).getAbsoluteFile()).isDirectory()) {
            _dirs.add(FileUtil.normalizeFile((File)f));
        }
    }

    public static synchronized void prepareCache() {
        assert (fileCache == null);
        fileCache = new HashMap<String, Map<File, Set<String>>>();
    }

    public static synchronized void discardCache() {
        assert (fileCache != null);
        fileCache = null;
    }

    public File locate(String relativePath, String codeNameBase, boolean localized) {
        Set<File> files = this.doLocate(relativePath, localized, true);
        return files.isEmpty() ? null : files.iterator().next();
    }

    public Set<File> locateAll(String relativePath, String codeNameBase, boolean localized) {
        return this.doLocate(relativePath, localized, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<File> doLocate(String relativePath, boolean localized, boolean single) {
        String[] prefixAndName = InstalledFileLocatorImpl.prefixAndName(relativePath);
        String prefix = prefixAndName[0];
        String name = prefixAndName[1];
        Class<InstalledFileLocatorImpl> clazz = InstalledFileLocatorImpl.class;
        synchronized (InstalledFileLocatorImpl.class) {
            if (localized) {
                String ext;
                String baseName;
                int i = name.lastIndexOf(46);
                if (i == -1) {
                    baseName = name;
                    ext = "";
                } else {
                    baseName = name.substring(0, i);
                    ext = name.substring(i);
                }
                Set<File> files = null;
                for (String suffix : Util.getLocalizingSuffixesFast()) {
                    String locName = baseName + suffix + ext;
                    Set<File> f = this.locateExactPath(prefix, locName, single);
                    if (f.isEmpty()) continue;
                    if (single) {
                        // ** MonitorExit[var7_7] (shouldn't be in output)
                        return f;
                    }
                    if (files == null) {
                        files = f;
                        continue;
                    }
                    files = new LinkedHashSet<File>(files);
                    files.addAll(f);
                }
                // ** MonitorExit[var7_7] (shouldn't be in output)
                return files != null ? files : Collections.emptySet();
            }
            // ** MonitorExit[var7_7] (shouldn't be in output)
            return this.locateExactPath(prefix, name, single);
        }
    }

    private Set<File> locateExactPath(String prefix, String name, boolean single) {
        assert (Thread.holdsLock(InstalledFileLocatorImpl.class));
        Set<File> files = null;
        if (fileCache != null) {
            Map<File, Set<String>> fileCachePerPrefix = this.fileCachePerPrefix(prefix);
            for (int i = 0; i < this.dirs.length; ++i) {
                Set<String> names = fileCachePerPrefix.get(this.dirs[i]);
                if (names == null || !names.contains(name)) continue;
                File f = InstalledFileLocatorImpl.makeFile(this.dirs[i], prefix, name);
                if (single) {
                    return Collections.singleton(f);
                }
                if (files == null) {
                    files = Collections.singleton(f);
                    continue;
                }
                files = new LinkedHashSet<File>(files);
                files.add(f);
            }
        } else {
            for (int i = 0; i < this.dirs.length; ++i) {
                File f = InstalledFileLocatorImpl.makeFile(this.dirs[i], prefix, name);
                if (!f.exists()) continue;
                if (single) {
                    return Collections.singleton(f);
                }
                if (files == null) {
                    files = Collections.singleton(f);
                    continue;
                }
                files = new LinkedHashSet<File>(files);
                files.add(f);
            }
        }
        return files != null ? files : Collections.emptySet();
    }

    private static String[] prefixAndName(String relativePath) {
        String name;
        String prefix;
        if (relativePath.length() == 0) {
            throw new IllegalArgumentException("Cannot look up \"\" in InstalledFileLocator.locate");
        }
        if (relativePath.charAt(0) == '/') {
            throw new IllegalArgumentException("Paths passed to InstalledFileLocator.locate should not start with '/': " + relativePath);
        }
        int slashIdx = relativePath.lastIndexOf(47);
        if (slashIdx == relativePath.length() - 1) {
            throw new IllegalArgumentException("Paths passed to InstalledFileLocator.locate should not end in '/': " + relativePath);
        }
        if (slashIdx != -1) {
            prefix = relativePath.substring(0, slashIdx + 1);
            name = relativePath.substring(slashIdx + 1);
            assert (name.length() > 0);
        } else {
            prefix = "";
            name = relativePath;
        }
        return new String[]{prefix, name};
    }

    private Map<File, Set<String>> fileCachePerPrefix(String prefix) {
        assert (Thread.holdsLock(InstalledFileLocatorImpl.class));
        Map<File, Set<String>> fileCachePerPrefix = fileCache.get(prefix);
        if (fileCachePerPrefix == null) {
            fileCachePerPrefix = new HashMap<File, Set<String>>(this.dirs.length * 2);
            for (int i = 0; i < this.dirs.length; ++i) {
                File d;
                File root = this.dirs[i];
                if (prefix.length() > 0) {
                    assert (prefix.charAt(prefix.length() - 1) == '/');
                    d = new File(root, prefix.substring(0, prefix.length() - 1).replace('/', File.separatorChar));
                } else {
                    d = root;
                }
                if (!d.isDirectory()) continue;
                String[] kids = d.list();
                if (kids != null) {
                    fileCachePerPrefix.put(root, new HashSet<String>(Arrays.asList(kids)));
                    continue;
                }
                Util.err.warning("could not read files in " + d);
            }
            fileCache.put(prefix, fileCachePerPrefix);
        }
        return fileCachePerPrefix;
    }

    private static File makeFile(File dir, String prefix, String name) {
        return new File(dir, prefix.replace('/', File.separatorChar) + name);
    }
}

