/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.terminal.ioprovider;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.Action;
import org.netbeans.modules.terminal.ioprovider.TerminalInputOutput;
import org.openide.windows.IOContainer;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public final class TerminalIOProvider
extends IOProvider {
    private static final List<TerminalInputOutput> list = new ArrayList<TerminalInputOutput>();

    public String getName() {
        return "Terminal";
    }

    public InputOutput getIO(String name, Action[] additionalActions) {
        return this.getIO(name, true, additionalActions, null);
    }

    public InputOutput getIO(String name, boolean newIO) {
        return this.getIO(name, newIO, null, null);
    }

    public InputOutput getIO(String name, Action[] actions, IOContainer ioContainer) {
        return this.getIO(name, true, actions, ioContainer);
    }

    private InputOutput getIO(String name, boolean newIO, Action[] actions, IOContainer ioContainer) {
        HashSet<TerminalInputOutput> candidates = new HashSet<TerminalInputOutput>();
        if (!newIO && name != null) {
            for (TerminalInputOutput tio : list) {
                if (!name.equals(tio.name()) || tio.terminal().isConnected()) continue;
                candidates.add(tio);
            }
        }
        TerminalInputOutput tio = null;
        if (candidates.isEmpty()) {
            if (ioContainer == null) {
                ioContainer = IOContainer.getDefault();
            }
            tio = new TerminalInputOutput(name, actions, ioContainer);
            list.add(tio);
        } else {
            for (TerminalInputOutput candidate : candidates) {
                if (tio == null) {
                    tio = candidate;
                    continue;
                }
                candidate.closeInputOutput();
            }
        }
        return tio;
    }

    public OutputWriter getStdOut() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    static void dispose(TerminalInputOutput io) {
        list.remove(io);
    }
}

