/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.breakpoints;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.Event;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.StepRequest;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointEvent;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.breakpoints.BreakpointsReader;
import org.netbeans.modules.debugger.jpda.expr.EvaluatorExpression;
import org.netbeans.modules.debugger.jpda.jdi.IllegalThreadStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidRequestStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.MirrorWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.PrimitiveValueWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ThreadReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ValueWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.EventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestManagerWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.StepRequestWrapper;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.models.ReturnVariableImpl;
import org.netbeans.modules.debugger.jpda.util.ConditionedExecutor;

abstract class BreakpointImpl
implements ConditionedExecutor,
PropertyChangeListener {
    private static Logger logger = Logger.getLogger("org.netbeans.modules.debugger.jpda.breakpoints");
    private JPDADebuggerImpl debugger;
    private JPDABreakpoint breakpoint;
    private BreakpointsReader reader;
    private EvaluatorExpression compiledCondition;
    private List<EventRequest> requests = new ArrayList<EventRequest>();
    private int hitCountFilter = 0;
    private final Map<Event, Variable> processedReturnVariable = new HashMap<Event, Variable>();
    private final Map<Event, Throwable> conditionException = new HashMap<Event, Throwable>();

    protected BreakpointImpl(JPDABreakpoint jPDABreakpoint, BreakpointsReader breakpointsReader, JPDADebuggerImpl jPDADebuggerImpl, Session session) {
        this.debugger = jPDADebuggerImpl;
        this.reader = breakpointsReader;
        this.breakpoint = jPDABreakpoint;
    }

    final void set() {
        this.breakpoint.addPropertyChangeListener((PropertyChangeListener)this);
        if (this.breakpoint instanceof PropertyChangeListener && this.isApplicable()) {
            Session session = this.debugger.getSession();
            DebuggerEngine debuggerEngine = session.getEngineForLanguage("Java");
            ((PropertyChangeListener)this.breakpoint).propertyChange(new PropertyChangeEvent(this, DebuggerEngine.class.getName(), null, debuggerEngine));
        }
        this.update();
    }

    void fixed() {
        if (this.reader != null) {
            this.reader.storeCachedClassName(this.breakpoint, null);
        }
        this.update();
    }

    final void update() {
        if (this.getVirtualMachine() == null || this.getDebugger().getState() == 4) {
            return;
        }
        this.removeAllEventRequests();
        if (this.breakpoint.isEnabled() && this.isEnabled()) {
            this.setRequests();
        }
    }

    protected boolean isApplicable() {
        return true;
    }

    protected boolean isEnabled() {
        return true;
    }

    protected final void setValidity(Breakpoint.VALIDITY vALIDITY, String string) {
        if (this.breakpoint instanceof ChangeListener) {
            ((ChangeListener)this.breakpoint).stateChanged(new ValidityChangeEvent(vALIDITY, string));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("disposed".equals(string)) {
            this.remove();
        } else if (!("validity".equals(string) || "groupName".equals(string) || "groupProperties".equals(string))) {
            if (this.reader != null) {
                this.reader.storeCachedClassName(this.breakpoint, null);
            }
            this.debugger.getRequestProcessor().post(new Runnable(){

                @Override
                public void run() {
                    BreakpointImpl.this.update();
                }
            });
        }
    }

    protected abstract void setRequests();

    protected void remove() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.debugger.getRequestProcessor().post(new Runnable(){

                @Override
                public void run() {
                    BreakpointImpl.this.removeAllEventRequests();
                }
            });
        } else {
            this.removeAllEventRequests();
        }
        this.breakpoint.removePropertyChangeListener((PropertyChangeListener)this);
        this.setValidity(Breakpoint.VALIDITY.UNKNOWN, null);
        if (this.breakpoint instanceof ChangeListener) {
            Session session = this.debugger.getSession();
            DebuggerEngine debuggerEngine = session.getEngineForLanguage("Java");
            ((PropertyChangeListener)this.breakpoint).propertyChange(new PropertyChangeEvent(this, DebuggerEngine.class.getName(), debuggerEngine, null));
        }
        this.compiledCondition = null;
    }

    protected JPDABreakpoint getBreakpoint() {
        return this.breakpoint;
    }

    protected JPDADebuggerImpl getDebugger() {
        return this.debugger;
    }

    protected VirtualMachine getVirtualMachine() {
        return this.getDebugger().getVirtualMachine();
    }

    protected EventRequestManager getEventRequestManager() throws VMDisconnectedExceptionWrapper, InternalExceptionWrapper {
        VirtualMachine virtualMachine = this.getVirtualMachine();
        if (virtualMachine == null) {
            throw new VMDisconnectedExceptionWrapper(new VMDisconnectedException());
        }
        return VirtualMachineWrapper.eventRequestManager(virtualMachine);
    }

    protected void addEventRequest(EventRequest eventRequest) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper, InvalidRequestStateExceptionWrapper {
        this.addEventRequest(eventRequest, false);
    }

    protected synchronized void addEventRequest(EventRequest eventRequest, boolean bl) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper, InvalidRequestStateExceptionWrapper {
        block13: {
            block12: {
                logger.fine("BreakpointImpl addEventRequest: " + eventRequest);
                this.requests.add(eventRequest);
                this.getDebugger().getOperator().register(eventRequest, this);
                if (this.getBreakpoint().getSuspend() == 2) {
                    EventRequestWrapper.setSuspendPolicy(eventRequest, 2);
                } else {
                    EventRequestWrapper.setSuspendPolicy(eventRequest, 1);
                }
                eventRequest.putProperty("brkpSuspend", this.getBreakpoint().getSuspend());
                int n = this.getBreakpoint().getHitCountFilter();
                if (bl || n <= 0) break block12;
                EventRequestWrapper.addCountFilter(eventRequest, n);
                switch (this.getBreakpoint().getHitCountFilteringStyle()) {
                    case MULTIPLE: {
                        this.hitCountFilter = n;
                        break block13;
                    }
                    case EQUAL: {
                        this.hitCountFilter = 0;
                        break block13;
                    }
                    case GREATER: {
                        this.hitCountFilter = -1;
                        break block13;
                    }
                    default: {
                        throw new IllegalStateException(this.getBreakpoint().getHitCountFilteringStyle().name());
                    }
                }
            }
            this.hitCountFilter = 0;
        }
        try {
            EventRequestWrapper.enable(eventRequest);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            this.getDebugger().getOperator().unregister(eventRequest);
            throw internalExceptionWrapper;
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            this.getDebugger().getOperator().unregister(eventRequest);
            throw objectCollectedExceptionWrapper;
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            this.getDebugger().getOperator().unregister(eventRequest);
            throw vMDisconnectedExceptionWrapper;
        }
        catch (InvalidRequestStateExceptionWrapper invalidRequestStateExceptionWrapper) {
            this.getDebugger().getOperator().unregister(eventRequest);
            throw invalidRequestStateExceptionWrapper;
        }
    }

    private synchronized void removeAllEventRequests() {
        if (this.requests.size() == 0) {
            return;
        }
        VirtualMachine virtualMachine = this.getDebugger().getVirtualMachine();
        if (virtualMachine == null) {
            return;
        }
        int n = this.requests.size();
        try {
            for (int i = 0; i < n; ++i) {
                EventRequest eventRequest = this.requests.get(i);
                logger.fine("BreakpointImpl removeEventRequest: " + eventRequest);
                EventRequestManagerWrapper.deleteEventRequest(VirtualMachineWrapper.eventRequestManager(virtualMachine), eventRequest);
                this.getDebugger().getOperator().unregister(eventRequest);
            }
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            // empty catch block
        }
        this.requests = new LinkedList<EventRequest>();
    }

    private synchronized void removeEventRequest(EventRequest eventRequest) {
        VirtualMachine virtualMachine = this.getDebugger().getVirtualMachine();
        if (virtualMachine == null) {
            return;
        }
        try {
            logger.fine("BreakpointImpl removeEventRequest: " + eventRequest);
            EventRequestManagerWrapper.deleteEventRequest(VirtualMachineWrapper.eventRequestManager(virtualMachine), eventRequest);
            this.getDebugger().getOperator().unregister(eventRequest);
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            // empty catch block
        }
        this.requests.remove(eventRequest);
    }

    protected abstract EventRequest createEventRequest(EventRequest var1) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper;

    public boolean processCondition(Event event, String string, ThreadReference threadReference, Value value) {
        try {
            boolean bl;
            EventRequest eventRequest = EventWrapper.request(event);
            if (this.hitCountFilter > 0) {
                EventRequestWrapper.disable(eventRequest);
                EventRequestWrapper.enable(eventRequest);
            }
            if (this.hitCountFilter == -1) {
                EventRequestWrapper.disable(eventRequest);
                this.removeEventRequest(eventRequest);
                this.addEventRequest(this.createEventRequest(eventRequest), true);
            }
            ReturnVariableImpl returnVariableImpl = null;
            if (this.getBreakpoint() instanceof MethodBreakpoint && (((MethodBreakpoint)this.getBreakpoint()).getBreakpointType() & 2) != 0 && value != null) {
                JPDAThreadImpl jPDAThreadImpl = this.getDebugger().getThread(threadReference);
                ReturnVariableImpl returnVariableImpl2 = new ReturnVariableImpl(this.getDebugger(), value, "", jPDAThreadImpl.getMethodName());
                jPDAThreadImpl.setReturnVariable(returnVariableImpl2);
                returnVariableImpl = returnVariableImpl2;
            }
            if (string != null && string.length() > 0) {
                try {
                    this.getDebugger().setAltCSF(ThreadReferenceWrapper.frame(threadReference, 0));
                }
                catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                    String string2 = JPDAThreadImpl.getThreadStateLog(threadReference);
                    Logger.getLogger(BreakpointImpl.class.getName()).log(Level.INFO, string2, incompatibleThreadStateException);
                }
                catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
                }
                catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
                    return false;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
                bl = this.evaluateCondition(event, string, threadReference);
                this.getDebugger().setAltCSF(null);
            } else {
                this.compiledCondition = null;
                bl = true;
            }
            if (bl) {
                this.processedReturnVariable.put(event, returnVariableImpl);
            }
            return bl;
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return true;
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            return true;
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return false;
        }
        catch (InvalidRequestStateExceptionWrapper invalidRequestStateExceptionWrapper) {
            return false;
        }
    }

    protected boolean perform(Event event, ThreadReference threadReference, ReferenceType referenceType, Value value) {
        Throwable throwable;
        Variable variable = this.processedReturnVariable.remove(event);
        if (variable == null) {
            variable = this.debugger.getVariable(value);
        }
        JPDABreakpointEvent jPDABreakpointEvent = (throwable = this.conditionException.remove(event)) == null ? new JPDABreakpointEvent(this.getBreakpoint(), (JPDADebugger)this.debugger, 1, (JPDAThread)this.debugger.getThread(threadReference), referenceType, variable) : new JPDABreakpointEvent(this.getBreakpoint(), (JPDADebugger)this.debugger, throwable, (JPDAThread)this.debugger.getThread(threadReference), referenceType, variable);
        this.getDebugger().fireBreakpointEvent(this.getBreakpoint(), jPDABreakpointEvent);
        Integer n = (Integer)event.request().getProperty("brkpSuspend");
        if (n == null) {
            n = this.getBreakpoint().getSuspend();
        }
        boolean bl = n == 0 || jPDABreakpointEvent.getResume();
        logger.fine("BreakpointImpl: perform breakpoint: " + this + " resume: " + bl);
        if (!bl) {
            try {
                bl = this.checkWhetherResumeToFinishStep(threadReference);
            }
            catch (InternalExceptionWrapper internalExceptionWrapper) {
                return false;
            }
            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                return false;
            }
        }
        if (!bl) {
            this.getDebugger().getThread(threadReference).setCurrentBreakpoint(this.breakpoint);
        }
        return bl;
    }

    private boolean checkWhetherResumeToFinishStep(ThreadReference threadReference) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        int n;
        List<StepRequest> list = EventRequestManagerWrapper.stepRequests(VirtualMachineWrapper.eventRequestManager(MirrorWrapper.virtualMachine(threadReference)));
        if (list.size() > 0 && ((n = this.breakpoint.getSuspend()) == 2 || n == 1)) {
            Object object;
            boolean bl = false;
            ArrayList<StepRequest> arrayList = new ArrayList<StepRequest>(list);
            for (int i = 0; i < arrayList.size(); ++i) {
                int n2;
                object = (StepRequest)arrayList.get(i);
                ThreadReference threadReference2 = StepRequestWrapper.thread((StepRequest)object);
                if (!EventRequestWrapper.isEnabled((EventRequest)object)) {
                    arrayList.remove(i);
                    continue;
                }
                try {
                    n2 = ThreadReferenceWrapper.status(StepRequestWrapper.thread((StepRequest)object));
                }
                catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
                    n2 = 0;
                }
                catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
                    n2 = 0;
                }
                if (n2 == 0) {
                    EventRequestManagerWrapper.deleteEventRequest(VirtualMachineWrapper.eventRequestManager(MirrorWrapper.virtualMachine(threadReference)), (EventRequest)object);
                    this.debugger.getOperator().unregister((EventRequest)object);
                    arrayList.remove(i);
                    continue;
                }
                if (!threadReference.equals(threadReference2)) continue;
                bl = true;
            }
            if (bl) {
                return false;
            }
            if (arrayList.size() > 0 && (bl || n == 2)) {
                Boolean bl2 = this.debugger.getStepInterruptByBptResumeDecision();
                if (bl2 != null) {
                    return bl2;
                }
                object = this.debugger.getThread(threadReference);
                ((JPDAThreadImpl)object).setStepSuspendedBy(this.breakpoint);
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean evaluateCondition(Event event, String string, ThreadReference threadReference) {
        try {
            try {
                boolean bl;
                JPDAThreadImpl jPDAThreadImpl = this.debugger.getThread(threadReference);
                jPDAThreadImpl.accessLock.writeLock().lock();
                try {
                    CallStackFrame callStackFrame = jPDAThreadImpl.getCallStack(0, 1)[0];
                    bl = this.evaluateConditionIn(string, callStackFrame);
                }
                finally {
                    jPDAThreadImpl.accessLock.writeLock().unlock();
                }
                logger.fine("BreakpointImpl: perform breakpoint (condition = " + bl + "): " + this + " resume: " + !bl);
                return bl;
            }
            catch (InvalidExpressionException invalidExpressionException) {
                this.conditionException.put(event, invalidExpressionException);
                logger.fine("BreakpointImpl: perform breakpoint (bad condition): '" + string + "', got " + invalidExpressionException.getMessage());
                return true;
            }
        }
        catch (AbsentInformationException absentInformationException) {
            logger.log(Level.INFO, string, absentInformationException);
            return true;
        }
    }

    private boolean evaluateConditionIn(String string, CallStackFrame callStackFrame) throws InvalidExpressionException {
        if (this.compiledCondition == null || !this.compiledCondition.getExpression().equals(string)) {
            this.compiledCondition = new EvaluatorExpression(string);
        }
        Value value = this.getDebugger().evaluateIn(this.compiledCondition, callStackFrame);
        try {
            return PrimitiveValueWrapper.booleanValue((BooleanValue)value);
        }
        catch (ClassCastException classCastException) {
            try {
                throw new InvalidExpressionException("Expecting boolean value instead of " + ValueWrapper.type(value));
            }
            catch (InternalExceptionWrapper internalExceptionWrapper) {
                throw new InvalidExpressionException("Expecting boolean value");
            }
            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                throw new InvalidExpressionException("Expecting boolean value");
            }
            catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
                throw new InvalidExpressionException("Expecting boolean value");
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new InvalidExpressionException((Throwable)nullPointerException);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return true;
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return true;
        }
    }

    static boolean match(String string, String string2) {
        if (string2.startsWith("*")) {
            return string.endsWith(string2.substring(1));
        }
        if (string2.endsWith("*")) {
            return string.startsWith(string2.substring(0, string2.length() - 1));
        }
        return string.equals(string2);
    }

    private static final class EngineChangeEvent
    extends ChangeEvent {
        private final DebuggerEngine newEngine;

        public EngineChangeEvent(DebuggerEngine debuggerEngine, DebuggerEngine debuggerEngine2) {
            super(debuggerEngine);
            this.newEngine = debuggerEngine2;
        }

        @Override
        public Object getSource() {
            return this.newEngine;
        }
    }

    private static final class ValidityChangeEvent
    extends ChangeEvent {
        private String reason;

        public ValidityChangeEvent(Breakpoint.VALIDITY vALIDITY, String string) {
            super(vALIDITY);
            this.reason = string;
        }

        @Override
        public String toString() {
            return this.reason;
        }
    }
}

