/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.actions;

import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.actions.JPDADebuggerActionProvider;
import org.netbeans.modules.debugger.jpda.actions.MethodChooserSupport;
import org.netbeans.modules.debugger.jpda.actions.StepIntoNextMethod;
import org.netbeans.modules.debugger.jpda.jdi.IllegalThreadStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidStackFrameExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocationWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.StackFrameWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ThreadReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.netbeans.spi.debugger.ui.MethodChooser;

public class StepIntoActionProvider
extends JPDADebuggerActionProvider {
    public static final String SS_STEP_OUT = "SS_ACTION_STEPOUT";
    public static final String ACTION_SMART_STEP_INTO = "smartStepInto";
    private StepIntoNextMethod stepInto;
    private MethodChooser currentMethodChooser;

    public StepIntoActionProvider(ContextProvider contextProvider) {
        super((JPDADebuggerImpl)((Object)contextProvider.lookupFirst(null, JPDADebugger.class)));
        this.stepInto = new StepIntoNextMethod(contextProvider);
        this.setProviderToDisableOnLazyAction(this);
    }

    public Set getActions() {
        return new HashSet<Object>(Arrays.asList(ActionsManager.ACTION_STEP_INTO));
    }

    public void doAction(Object object) {
        this.runAction(object, true);
    }

    public void postAction(final Object object, final Runnable runnable) {
        this.doLazyAction(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    StepIntoActionProvider.this.runAction(object, true);
                }
                finally {
                    runnable.run();
                }
            }
        });
    }

    public void runAction(Object object, boolean bl) {
        if (ActionsManager.ACTION_STEP_INTO.equals(object) && this.doMethodSelection()) {
            return;
        }
        this.stepInto.runAction(object, bl);
    }

    @Override
    protected void checkEnabled(int n) {
        Iterator iterator = this.getActions().iterator();
        while (iterator.hasNext()) {
            this.setEnabled(iterator.next(), n == 3 && this.getDebuggerImpl().getCurrentThread() != null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doMethodSelection() {
        final String[] stringArray = this;
        synchronized (this) {
            if (this.currentMethodChooser != null) {
                this.currentMethodChooser.releaseUI(true);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            stringArray = new String[1];
            final String[] stringArray2 = new String[1];
            final int[] nArray = new int[1];
            final int[] nArray2 = new int[1];
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        EditorContext editorContext = EditorContextBridge.getContext();
                        stringArray[0] = editorContext.getSelectedMethodName();
                        nArray[0] = editorContext.getCurrentLineNumber();
                        nArray2[0] = EditorContextBridge.getCurrentOffset();
                        stringArray2[0] = editorContext.getCurrentURL();
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
                return false;
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
            int n = nArray[0];
            int n2 = nArray2[0];
            String string = stringArray2[0];
            if (n < 0 || string == null || !string.endsWith(".java")) {
                return false;
            }
            JPDAThreadImpl jPDAThreadImpl = (JPDAThreadImpl)this.debugger.getCurrentThread();
            ThreadReference threadReference = jPDAThreadImpl.getThreadReference();
            ReferenceType referenceType = null;
            try {
                if (ThreadReferenceWrapper.frameCount(threadReference) < 1) {
                    return false;
                }
                referenceType = LocationWrapper.declaringType(StackFrameWrapper.location(ThreadReferenceWrapper.frame(threadReference, 0)));
            }
            catch (InternalExceptionWrapper internalExceptionWrapper) {
            }
            catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            }
            catch (InvalidStackFrameExceptionWrapper invalidStackFrameExceptionWrapper) {
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            }
            catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
            }
            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                // empty catch block
            }
            if (referenceType != null) {
                if (this.debugger.getState() == 4) {
                    return false;
                }
                final MethodChooserSupport methodChooserSupport = new MethodChooserSupport(this.debugger, string, referenceType, n, n2);
                boolean bl = methodChooserSupport.init();
                if (methodChooserSupport.getSegmentsCount() == 0) {
                    return false;
                }
                if (bl) {
                    return true;
                }
                MethodChooser.ReleaseListener releaseListener = new MethodChooser.ReleaseListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void released(boolean bl) {
                        3 var2_2 = this;
                        synchronized (var2_2) {
                            StepIntoActionProvider.this.currentMethodChooser = null;
                            methodChooserSupport.tearDown();
                            if (bl) {
                                methodChooserSupport.doStepInto();
                            }
                        }
                    }
                };
                MethodChooser methodChooser = methodChooserSupport.createChooser();
                methodChooser.addReleaseListener(releaseListener);
                boolean bl2 = methodChooser.showUI();
                if (bl2 && methodChooser.isUIActive()) {
                    String[] stringArray3 = this;
                    synchronized (this) {
                        methodChooserSupport.tearUp(methodChooser);
                        this.currentMethodChooser = methodChooser;
                        // ** MonitorExit[var16_25] (shouldn't be in output)
                    }
                } else {
                    methodChooser.removeReleaseListener(releaseListener);
                }
                return bl2;
            }
            return false;
        }
    }
}

