/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.spi.indexing.support;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.parsing.impl.indexing.DeletedIndexable;
import org.netbeans.modules.parsing.impl.indexing.FileObjectIndexable;
import org.netbeans.modules.parsing.impl.indexing.IndexDocumentImpl;
import org.netbeans.modules.parsing.impl.indexing.SPIAccessor;
import org.netbeans.modules.parsing.impl.indexing.Util;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Parameters;

public final class IndexResult {
    private static final Logger LOG = Logger.getLogger(IndexResult.class.getName());
    private final IndexDocumentImpl spi;
    private final URL root;
    private volatile URL cachedUrl;
    private volatile FileObject cachedFile;

    IndexResult(IndexDocumentImpl spi, URL root) {
        assert (spi != null);
        assert (root != null);
        this.spi = spi;
        this.root = root;
    }

    public String getValue(String key) {
        Parameters.notEmpty((CharSequence)"key", (CharSequence)key);
        return this.spi.getValue(key);
    }

    public String[] getValues(String key) {
        Parameters.notEmpty((CharSequence)"key", (CharSequence)key);
        return this.spi.getValues(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getUrl() {
        if (this.cachedUrl == null) {
            URL url = null;
            try {
                url = Util.resolveUrl(this.root, this.spi.getSourceName());
            }
            catch (MalformedURLException ex) {
                LOG.log(Level.WARNING, null, ex);
            }
            IndexResult indexResult = this;
            synchronized (indexResult) {
                if (this.cachedUrl == null) {
                    this.cachedUrl = url;
                }
            }
        }
        return this.cachedUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject getFile() {
        if (this.cachedFile == null) {
            FileObject resource = null;
            URL url = this.getUrl();
            if (url != null) {
                resource = URLMapper.findFileObject((URL)url);
            }
            IndexResult indexResult = this;
            synchronized (indexResult) {
                if (this.cachedFile == null) {
                    this.cachedFile = resource;
                }
            }
        }
        return this.cachedFile;
    }

    public String getRelativePath() {
        return this.spi.getSourceName();
    }

    public URL getRoot() {
        return this.root;
    }

    public Indexable getIndexable() {
        FileObject rootFo;
        FileObject file = this.getFile();
        if (file != null && (rootFo = URLMapper.findFileObject((URL)this.root)) != null) {
            return SPIAccessor.getInstance().create(new FileObjectIndexable(rootFo, file));
        }
        return SPIAccessor.getInstance().create(new DeletedIndexable(this.root, this.getRelativePath()));
    }
}

