/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.externalization;

import java.io.File;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.internal.tasks.core.externalization.IExternalizationContext;
import org.eclipse.mylyn.internal.tasks.core.externalization.IExternalizationParticipant;

public abstract class AbstractExternalizationParticipant
implements IExternalizationParticipant {
    public static final String SNAPSHOT_PREFIX = ".";

    public abstract void load(File var1, IProgressMonitor var2) throws CoreException;

    public abstract void save(File var1, IProgressMonitor var2) throws CoreException;

    public abstract String getDescription();

    public abstract ISchedulingRule getSchedulingRule();

    public abstract boolean isDirty();

    public abstract String getFileName();

    protected boolean takeSnapshot(File file) {
        if (file.length() > 0L) {
            File originalFile = file.getAbsoluteFile();
            File backup = new File(file.getParentFile(), SNAPSHOT_PREFIX + file.getName());
            backup.delete();
            return originalFile.renameTo(backup);
        }
        return false;
    }

    public void execute(IExternalizationContext context, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)context);
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        File dataFile = this.getFile(context.getRootPath());
        switch (context.getKind()) {
            case SAVE: {
                if (dataFile != null) {
                    this.takeSnapshot(dataFile);
                }
                this.save(dataFile, monitor);
                break;
            }
            case LOAD: {
                this.performLoad(dataFile, monitor);
                break;
            }
        }
    }

    protected boolean performLoad(File dataFile, IProgressMonitor monitor) throws CoreException {
        try {
            this.load(dataFile, monitor);
            return true;
        }
        catch (CoreException e) {
            File backup;
            if (dataFile != null && (backup = new File(dataFile.getParentFile(), SNAPSHOT_PREFIX + dataFile.getName())).exists()) {
                StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.tasks.core", "Failed to load " + dataFile.getName() + ", restoring from snapshot", (Throwable)e));
                this.load(backup, monitor);
                return true;
            }
            return false;
        }
    }

    public File getFile(String rootPath) throws CoreException {
        String fileName = this.getFileName();
        if (fileName != null) {
            String filePath = String.valueOf(rootPath) + File.separator + this.getFileName();
            return new File(filePath);
        }
        return null;
    }
}

