/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards.targetpanel.providers;

import org.netbeans.modules.target.iterator.api.TargetChooserPanel;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.wizards.FileType;
import org.netbeans.modules.web.wizards.targetpanel.providers.TagLibUIManager;
import org.netbeans.modules.web.wizards.targetpanel.providers.WebTargetPanelProvider;
import org.openide.util.NbBundle;

public class TagLibTargetPanelProvider
extends WebTargetPanelProvider<FileType> {
    static final String TAG_LIBRARY = "tag_library";
    public static final String URI = "uri";
    public static final String PREFIX = "prefix";
    private TagLibUIManager myUIManager = new TagLibUIManager();

    @Override
    public void init(TargetChooserPanel<FileType> targetChooserPanel) {
        super.init(targetChooserPanel);
    }

    @Override
    public String getNewFileName() {
        return super.getNewFileName() + TAG_LIBRARY;
    }

    public String getWizardTitle() {
        return NbBundle.getMessage(TagLibTargetPanelProvider.class, (String)"TITLE_TLD");
    }

    @Override
    public boolean isValid(TargetChooserPanel<FileType> targetChooserPanel) {
        if (!targetChooserPanel.checkValid()) {
            return false;
        }
        String string = targetChooserPanel.getComponent().getTargetName();
        if (string.indexOf(32) >= 0 || string.indexOf(44) >= 0) {
            targetChooserPanel.getTemplateWizard().putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(TagLibTargetPanelProvider.class, (String)"TXT_wrongTagLibName", (Object)string));
            return false;
        }
        return true;
    }

    public TagLibUIManager getUIManager() {
        return this.myUIManager;
    }

    public boolean isApplicable(FileType fileType) {
        return fileType == FileType.TAGLIBRARY;
    }

    @Override
    public void storeSettings(TargetChooserPanel<FileType> targetChooserPanel) {
        targetChooserPanel.getTemplateWizard().putProperty(URI, (Object)this.getUIManager().getUri());
        targetChooserPanel.getTemplateWizard().putProperty(PREFIX, (Object)this.getUIManager().getPrefix());
    }

    @Override
    protected WebModule getWebModule() {
        return this.myUIManager.getWebModule();
    }
}

