/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import javax.swing.JInternalFrame;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.JemmyInputException;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.TimeoutExpiredException;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.JDialogOperator;
import org.netbeans.jemmy.operators.JInternalFrameOperator;
import org.netbeans.jemmy.operators.JScrollPaneOperator;
import org.netbeans.jemmy.operators.JTabbedPaneOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.jemmy.operators.WindowOperator;
import org.netbeans.jemmy.util.EmptyVisualizer;

public class DefaultVisualizer
implements Operator.ComponentVisualizer,
Cloneable {
    private boolean window = true;
    private boolean internalFrame = true;
    private boolean scroll = false;
    private boolean switchTab = false;
    private boolean modal = false;

    public void checkForModal(boolean yesOrNo) {
        this.modal = yesOrNo;
    }

    public void activateWindow(boolean yesOrNo) {
        this.window = yesOrNo;
    }

    public void activateInternalFrame(boolean yesOrNo) {
        this.internalFrame = yesOrNo;
    }

    public void scroll(boolean yesOrNo) {
        this.scroll = yesOrNo;
    }

    public void switchTab(boolean yesOrNo) {
        this.switchTab = yesOrNo;
    }

    protected boolean isWindowActive(WindowOperator winOper) {
        return winOper.isFocused() && winOper.isActive();
    }

    protected void makeWindowActive(WindowOperator winOper) {
        winOper.activate();
    }

    protected void activate(WindowOperator winOper) {
        boolean active = this.isWindowActive(winOper);
        winOper.toFront();
        if (!active) {
            this.makeWindowActive(winOper);
        }
    }

    protected void initInternalFrame(JInternalFrameOperator intOper) {
        if (!intOper.isSelected()) {
            intOper.activate();
        }
    }

    protected void scroll(JScrollPaneOperator scrollOper, Component target) {
        if (!scrollOper.checkInside(target)) {
            scrollOper.scrollToComponent(target);
        }
    }

    protected void switchTab(JTabbedPaneOperator tabOper, Component target) {
        int tabInd = 0;
        for (int j = 0; j < tabOper.getTabCount(); ++j) {
            if (target != tabOper.getComponentAt(j)) continue;
            tabInd = j;
            break;
        }
        if (tabOper.getSelectedIndex() != tabInd) {
            tabOper.selectPage(tabInd);
        }
    }

    public void makeVisible(ComponentOperator compOper) {
        try {
            Dialog modalDialog;
            if (this.modal && (modalDialog = JDialogOperator.getTopModalDialog()) != null && compOper.getWindow() != modalDialog) {
                throw new JemmyInputException("Component is not on top modal dialog.", compOper.getSource());
            }
            WindowOperator winOper = new WindowOperator(compOper.getWindow());
            if (this.window) {
                winOper.copyEnvironment(compOper);
                winOper.setVisualizer(new EmptyVisualizer());
                this.activate(winOper);
            }
            if (this.internalFrame && compOper instanceof JInternalFrameOperator) {
                this.initInternalFrame((JInternalFrameOperator)compOper);
            }
            Container[] conts = compOper.getContainers();
            for (int i = conts.length - 1; i >= 0; --i) {
                if (this.internalFrame && conts[i] instanceof JInternalFrame) {
                    JInternalFrameOperator intOper = new JInternalFrameOperator((JInternalFrame)conts[i]);
                    intOper.copyEnvironment(compOper);
                    intOper.setVisualizer(new EmptyVisualizer());
                    this.initInternalFrame(intOper);
                    continue;
                }
                if (this.scroll && conts[i] instanceof JScrollPane) {
                    JScrollPaneOperator scrollOper = new JScrollPaneOperator((JScrollPane)conts[i]);
                    scrollOper.copyEnvironment(compOper);
                    scrollOper.setVisualizer(new EmptyVisualizer());
                    this.scroll(scrollOper, compOper.getSource());
                    continue;
                }
                if (!this.switchTab || !(conts[i] instanceof JTabbedPane)) continue;
                JTabbedPaneOperator tabOper = new JTabbedPaneOperator((JTabbedPane)conts[i]);
                tabOper.copyEnvironment(compOper);
                tabOper.setVisualizer(new EmptyVisualizer());
                this.switchTab(tabOper, i == 0 ? compOper.getSource() : conts[i - 1]);
            }
        }
        catch (TimeoutExpiredException e) {
            JemmyProperties.getProperties().getOutput().printStackTrace(e);
        }
    }

    public DefaultVisualizer cloneThis() {
        try {
            return (DefaultVisualizer)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new JemmyException("Even impossible happens :)", e);
        }
    }
}

