/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual.ui.preview;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import org.netbeans.modules.css.visual.api.StyleBuilderTopComponent;
import org.netbeans.modules.css.visual.ui.preview.CssPreviewTopComponent;
import org.openide.filesystems.FileObject;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class CssTCController
implements PropertyChangeListener {
    public static WeakReference<CssTCController> instance;
    private TopComponent lastCSSTC = null;

    public static synchronized CssTCController getDefault() {
        CssTCController controllerInstance;
        if (instance == null) {
            instance = new WeakReference<CssTCController>(new CssTCController());
        }
        if ((controllerInstance = (CssTCController)instance.get()) == null) {
            controllerInstance = new CssTCController();
            instance = new WeakReference<CssTCController>(controllerInstance);
            return controllerInstance;
        }
        return (CssTCController)instance.get();
    }

    public CssTCController() {
        TopComponent.Registry reg = WindowManager.getDefault().getRegistry();
        reg.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)reg));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        TopComponent closedTC;
        if ("activated".equals(evt.getPropertyName())) {
            TopComponent activated = (TopComponent)evt.getNewValue();
            if (this.isCSSTC(activated)) {
                this.previewableActivated(activated);
            } else {
                if (activated instanceof CssPreviewTopComponent || activated instanceof StyleBuilderTopComponent) {
                    return;
                }
                if (WindowManager.getDefault().isOpenedEditorTopComponent(activated) && this.lastCSSTC != null) {
                    this.notPreviewableActivated();
                }
            }
        } else if (this.lastCSSTC != null && "tcClosed".equals(evt.getPropertyName()) && (closedTC = (TopComponent)evt.getNewValue()) == this.lastCSSTC) {
            this.notPreviewableActivated();
        }
    }

    private boolean isCSSTC(TopComponent tc) {
        String mimeType;
        if (tc == null) {
            return false;
        }
        FileObject fob = (FileObject)tc.getLookup().lookup(FileObject.class);
        return fob != null && (mimeType = fob.getMIMEType()) != null && "text/x-css".equals(mimeType);
    }

    private void previewableActivated(TopComponent tc) {
        this.lastCSSTC = tc;
        WindowManager.getDefault().findTopComponentGroup("Csswsgrp").open();
    }

    private void notPreviewableActivated() {
        this.lastCSSTC = null;
        WindowManager.getDefault().findTopComponentGroup("Csswsgrp").close();
    }
}

