/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common.project.ui;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharConversionException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.EventListener;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.j2ee.common.project.ui.DeployOnSaveUtils;
import org.netbeans.modules.j2ee.common.ui.BrokenDatasourceSupport;
import org.netbeans.modules.j2ee.common.ui.BrokenServerSupport;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.ConfigurationFilesListener;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.InstanceListener;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.project.ProjectProperties;
import org.netbeans.modules.java.api.common.project.ui.LogicalViewProvider2;
import org.netbeans.spi.java.project.support.ui.BrokenReferencesSupport;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.netbeans.spi.project.ui.support.NodeFactorySupport;
import org.netbeans.spi.project.ui.support.ProjectSensitiveActions;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.modules.SpecificationVersion;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOp;
import org.openide.util.ChangeSupport;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Element;

public abstract class AbstractLogicalViewProvider
implements LogicalViewProvider2 {
    private static final RequestProcessor RP = new RequestProcessor("AbstractLogicalViewProvider.RP");
    private final Project project;
    private final UpdateHelper helper;
    private final PropertyEvaluator evaluator;
    private final ReferenceHelper resolver;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private PropertyChangeListener pcl;
    private InstanceListener il;
    private ConfigurationFilesListener cfl;
    private final RequestProcessor.Task task = RP.create(new Runnable(){

        @Override
        public void run() {
            boolean bl;
            boolean bl2;
            boolean bl3;
            boolean bl4;
            boolean bl5;
            boolean bl6 = AbstractLogicalViewProvider.this.broken;
            if (bl6 != (bl5 = AbstractLogicalViewProvider.this.hasBrokenLinks())) {
                AbstractLogicalViewProvider.this.setBroken(bl5);
            }
            if ((bl6 = AbstractLogicalViewProvider.this.illegalState) != (bl4 = AbstractLogicalViewProvider.this.hasInvalidJdkVersion())) {
                AbstractLogicalViewProvider.this.setIllegalState(bl4);
            }
            if ((bl6 = AbstractLogicalViewProvider.this.deployOnSaveDisabled) != (bl3 = AbstractLogicalViewProvider.this.isDeployOnSaveSupportedAndDisabled())) {
                AbstractLogicalViewProvider.this.setDeployOnSaveDisabled(bl3);
            }
            if ((bl6 = AbstractLogicalViewProvider.this.brokenServer) != (bl2 = AbstractLogicalViewProvider.this.hasBrokenServer())) {
                AbstractLogicalViewProvider.this.setBrokenServer(bl2);
            }
            if ((bl6 = AbstractLogicalViewProvider.this.brokenDataSource) != (bl = AbstractLogicalViewProvider.this.hasBrokenDataSource())) {
                AbstractLogicalViewProvider.this.setBrokenDataSource(bl);
            }
        }
    });
    private boolean broken;
    private boolean illegalState;
    private boolean deployOnSaveDisabled;
    private boolean brokenServer;
    private boolean brokenDataSource;

    protected AbstractLogicalViewProvider(Project project, UpdateHelper updateHelper, PropertyEvaluator propertyEvaluator, ReferenceHelper referenceHelper, J2eeModuleProvider j2eeModuleProvider) {
        this.project = project;
        assert (project != null);
        this.helper = updateHelper;
        assert (updateHelper != null);
        this.evaluator = propertyEvaluator;
        assert (propertyEvaluator != null);
        this.resolver = referenceHelper;
        assert (j2eeModuleProvider != null);
        this.registerListeners(j2eeModuleProvider);
    }

    protected void registerListeners(J2eeModuleProvider j2eeModuleProvider) {
        this.pcl = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                AbstractLogicalViewProvider.this.testBroken();
            }
        };
        this.il = new InstanceListener(){

            public void instanceAdded(String string) {
                AbstractLogicalViewProvider.this.testBroken();
            }

            public void instanceRemoved(String string) {
                AbstractLogicalViewProvider.this.testBroken();
            }
        };
        this.cfl = new ConfigurationFilesListener(){

            public void fileCreated(FileObject fileObject) {
                AbstractLogicalViewProvider.this.testBroken();
            }

            public void fileDeleted(FileObject fileObject) {
                AbstractLogicalViewProvider.this.testBroken();
            }
        };
        this.evaluator.addPropertyChangeListener(this.pcl);
        JavaPlatformManager.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.pcl, (Object)JavaPlatformManager.getDefault()));
        j2eeModuleProvider.addInstanceListener((InstanceListener)WeakListeners.create(InstanceListener.class, (EventListener)this.il, (Object)j2eeModuleProvider));
    }

    public Node findPath(Node node, Object object) {
        Project project = (Project)node.getLookup().lookup(Project.class);
        if (project == null) {
            return null;
        }
        if (object instanceof FileObject) {
            return this.findPath(node, project, (FileObject)object);
        }
        return null;
    }

    protected Node findPath(Node node, Project project, FileObject fileObject) {
        Project project2 = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (!project.equals(project2)) {
            return null;
        }
        for (Node node2 : node.getChildren().getNodes(true)) {
            Node node3 = PackageView.findPath((Node)node2, (Object)fileObject);
            if (node3 == null) continue;
            return node3;
        }
        Node node4 = this.findNodeInConfigFiles(node, fileObject);
        if (node4 != null) {
            return node4;
        }
        return null;
    }

    protected Node findNodeInDocBase(Node node, FileObject fileObject, String string) {
        String string2 = this.evaluator.getProperty(string);
        if (string2 == null) {
            return null;
        }
        FileObject fileObject2 = this.helper.getAntProjectHelper().resolveFileObject(string2);
        String string3 = FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject);
        if (string3 == null) {
            return null;
        }
        int n = string3.lastIndexOf(47);
        string3 = n != -1 ? string3.substring(0, n) : "";
        StringTokenizer stringTokenizer = new StringTokenizer(string3, "/");
        Node node2 = NodeOp.findChild((Node)node, (String)fileObject2.getName());
        if (node2 == null) {
            return null;
        }
        while (stringTokenizer.hasMoreTokens()) {
            if ((node2 = NodeOp.findChild((Node)node2, (String)stringTokenizer.nextToken())) != null) continue;
            return null;
        }
        for (Node node3 : node2.getChildren().getNodes(true)) {
            DataObject dataObject = (DataObject)node3.getLookup().lookup(DataObject.class);
            if (dataObject == null || !dataObject.getPrimaryFile().getNameExt().equals(fileObject.getNameExt())) continue;
            node2 = node3;
            break;
        }
        return node2;
    }

    private Node findNodeInConfigFiles(Node node, FileObject fileObject) {
        String string;
        DataObject dataObject;
        try {
            dataObject = DataObject.find((FileObject)fileObject);
            string = dataObject.getName();
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            string = fileObject.getName();
        }
        dataObject = node.getChildren().findChild("configurationFiles");
        if (dataObject == null) {
            return null;
        }
        return NodeOp.findChild((Node)dataObject, (String)string);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    public void testBroken() {
        this.task.schedule(100);
    }

    private static Lookup createLookup(Project project) {
        DataFolder dataFolder = DataFolder.findFolder((FileObject)project.getProjectDirectory());
        return Lookups.fixed((Object[])new Object[]{project, dataFolder});
    }

    public boolean hasBrokenLinks() {
        return BrokenReferencesSupport.isBroken((AntProjectHelper)this.helper.getAntProjectHelper(), (ReferenceHelper)this.resolver, (String[])this.getBreakableProperties(), (String[])new String[]{"platform.active"});
    }

    protected abstract String[] getBreakableProperties();

    protected final String[] createListOfBreakableProperties(SourceRoots sourceRoots, SourceRoots sourceRoots2, String[] stringArray) {
        String[] stringArray2 = sourceRoots.getRootProperties();
        String[] stringArray3 = sourceRoots2.getRootProperties();
        String[] stringArray4 = new String[stringArray.length + stringArray2.length + stringArray3.length];
        System.arraycopy(stringArray, 0, stringArray4, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray4, stringArray.length, stringArray2.length);
        System.arraycopy(stringArray3, 0, stringArray4, stringArray.length + stringArray2.length, stringArray3.length);
        return stringArray4;
    }

    public static JavaPlatform getActivePlatform(String string) {
        JavaPlatform[] javaPlatformArray;
        JavaPlatformManager javaPlatformManager = JavaPlatformManager.getDefault();
        if (string == null) {
            return javaPlatformManager.getDefaultPlatform();
        }
        for (JavaPlatform javaPlatform : javaPlatformArray = javaPlatformManager.getPlatforms(null, new Specification("j2se", null))) {
            String string2 = (String)javaPlatform.getProperties().get("platform.ant.name");
            if (string2 == null || !string2.equals(string)) continue;
            return javaPlatform;
        }
        return null;
    }

    private boolean hasInvalidJdkVersion() {
        String string = this.evaluator.getProperty("javac.source");
        String string2 = this.evaluator.getProperty("javac.target");
        if (string == null && string2 == null) {
            return false;
        }
        String string3 = this.evaluator.getProperty("platform.active");
        JavaPlatform javaPlatform = AbstractLogicalViewProvider.getActivePlatform(string3);
        if (javaPlatform == null) {
            return true;
        }
        SpecificationVersion specificationVersion = javaPlatform.getSpecification().getVersion();
        try {
            return string != null && new SpecificationVersion(string).compareTo((Object)specificationVersion) > 0 || string2 != null && new SpecificationVersion(string2).compareTo((Object)specificationVersion) > 0;
        }
        catch (NumberFormatException numberFormatException) {
            ErrorManager.getDefault().log("Invalid javac.source: " + string + " or javac.target: " + string2 + " of project:" + this.project.getProjectDirectory().getPath());
            return true;
        }
    }

    private boolean isDeployOnSaveSupportedAndDisabled() {
        boolean bl = Boolean.valueOf(this.evaluator.getProperty("j2ee.deploy.on.save"));
        if (bl) {
            return false;
        }
        boolean bl2 = false;
        try {
            String string = this.evaluator.getProperty("j2ee.server.instance");
            if (string != null) {
                bl2 = Deployment.getDefault().getServerInstance(string).isDeployOnSaveSupported();
            }
        }
        catch (InstanceRemovedException instanceRemovedException) {
            // empty catch block
        }
        return bl2;
    }

    protected abstract void setServerInstance(Project var1, UpdateHelper var2, String var3);

    private void setBroken(boolean bl) {
        this.broken = bl;
        this.changeSupport.fireChange();
    }

    private void setIllegalState(boolean bl) {
        this.illegalState = bl;
        this.changeSupport.fireChange();
    }

    private void setDeployOnSaveDisabled(boolean bl) {
        this.deployOnSaveDisabled = bl;
        this.changeSupport.fireChange();
    }

    private void setBrokenDataSource(boolean bl) {
        this.brokenDataSource = bl;
        this.changeSupport.fireChange();
    }

    private void setBrokenServer(boolean bl) {
        this.brokenServer = bl;
        this.changeSupport.fireChange();
    }

    public static Action brokenLinksActionFactory() {
        return new ActionFactory(1);
    }

    public static Action brokenServerActionFactory() {
        return new ActionFactory(2);
    }

    public static Action brokenDataSourceActionFactory() {
        return new ActionFactory(3);
    }

    public static Action redeploy() {
        return ProjectSensitiveActions.projectCommandAction((String)"redeploy", (String)NbBundle.getBundle(AbstractLogicalViewProvider.class).getString("LBL_RedeployAction_Name"), null);
    }

    private boolean hasBrokenServer() {
        String string = this.evaluator.getProperty("j2ee.server.instance");
        return BrokenServerSupport.isBroken(string);
    }

    private boolean isVisualWebLegacyProject() {
        String string;
        boolean bl = false;
        AuxiliaryConfiguration auxiliaryConfiguration = ProjectUtils.getAuxiliaryConfiguration((Project)this.project);
        Element element = auxiliaryConfiguration.getConfigurationFragment("creator-data", "http://www.sun.com/creator/ns", true);
        if (element != null && (string = element.getAttribute("jsf.project.version")) != null && !string.equals("4.0")) {
            bl = true;
        }
        return bl;
    }

    private boolean hasBrokenDataSource() {
        if (this.isVisualWebLegacyProject()) {
            return false;
        }
        return !BrokenDatasourceSupport.getBrokenDatasources(this.project).isEmpty();
    }

    private class BrokenDataSourceAction
    extends AbstractAction {
        public BrokenDataSourceAction() {
            this.putValue("Name", NbBundle.getMessage(AbstractLogicalViewProvider.class, (String)"LBL_Fix_Broken_Datasource_Action"));
            this.setEnabled(AbstractLogicalViewProvider.this.brokenDataSource);
            this.putValue("hideWhenDisabled", true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                AbstractLogicalViewProvider.this.helper.requestUpdate();
                BrokenDatasourceSupport.fixDatasources(AbstractLogicalViewProvider.this.project);
                BrokenDatasourceSupport.showAlert();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
    }

    private class BrokenServerAction
    extends AbstractAction {
        public BrokenServerAction() {
            this.putValue("Name", NbBundle.getMessage(AbstractLogicalViewProvider.class, (String)"LBL_Fix_Missing_Server_Action"));
            this.setEnabled(AbstractLogicalViewProvider.this.brokenServer);
            this.putValue("hideWhenDisabled", true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                String string;
                AbstractLogicalViewProvider.this.helper.requestUpdate();
                Profile profile = Profile.fromPropertiesString((String)AbstractLogicalViewProvider.this.helper.getProperties("nbproject/project.properties").getProperty("j2ee.platform"));
                if (profile == null) {
                    profile = Profile.JAVA_EE_5;
                    Logger.getLogger(AbstractLogicalViewProvider.class.getName()).warning("project [" + AbstractLogicalViewProvider.this.project.getProjectDirectory() + "] is missing " + "j2ee.platform" + ". " + "default value will be used instead: " + profile);
                    this.updateJ2EESpec(AbstractLogicalViewProvider.this.project, AbstractLogicalViewProvider.this.helper.getAntProjectHelper(), profile);
                }
                if ((string = BrokenServerSupport.selectServer(profile, J2eeModule.Type.WAR)) != null) {
                    AbstractLogicalViewProvider.this.setServerInstance(AbstractLogicalViewProvider.this.project, AbstractLogicalViewProvider.this.helper, string);
                }
                AbstractLogicalViewProvider.this.testBroken();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }

        private void updateJ2EESpec(final Project project, final AntProjectHelper antProjectHelper, final Profile profile) {
            ProjectManager.mutex().postWriteRequest(new Runnable(){

                @Override
                public void run() {
                    try {
                        EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
                        editableProperties.put("j2ee.platform", profile.toPropertiesString());
                        antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
                        ProjectManager.getDefault().saveProject(project);
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                }
            });
        }
    }

    private class BrokenLinksAction
    extends AbstractAction {
        public BrokenLinksAction() {
            this.putValue("Name", NbBundle.getMessage(AbstractLogicalViewProvider.class, (String)"LBL_Fix_Broken_Links_Action"));
            this.setEnabled(AbstractLogicalViewProvider.this.broken);
            this.putValue("hideWhenDisabled", true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                AbstractLogicalViewProvider.this.helper.requestUpdate();
                BrokenReferencesSupport.showCustomizer((AntProjectHelper)AbstractLogicalViewProvider.this.helper.getAntProjectHelper(), (ReferenceHelper)AbstractLogicalViewProvider.this.resolver, (String[])AbstractLogicalViewProvider.this.getBreakableProperties(), (String[])new String[]{"platform.active"});
                AbstractLogicalViewProvider.this.testBroken();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
    }

    public static final class VerifyAction
    extends AbstractAction
    implements ContextAwareAction {
        public VerifyAction() {
            this.setEnabled(false);
            this.putValue("hideWhenDisabled", true);
            this.putValue("Name", NbBundle.getMessage(AbstractLogicalViewProvider.class, (String)"LBL_VerifyAction_Name"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            assert (false);
        }

        public Action createContextAwareInstance(Lookup lookup) {
            Project project = (Project)lookup.lookup(Project.class);
            if (project == null) {
                return this;
            }
            J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
            if (j2eeModuleProvider == null) {
                return this;
            }
            if (!j2eeModuleProvider.hasVerifierSupport()) {
                return this;
            }
            return ProjectSensitiveActions.projectCommandAction((String)"verify", (String)NbBundle.getMessage(AbstractLogicalViewProvider.class, (String)"LBL_VerifyAction_Name"), null);
        }
    }

    private static final class ActionFactory
    extends AbstractAction
    implements ContextAwareAction {
        private int mode;

        private ActionFactory(int n) {
            this.mode = n;
            this.setEnabled(false);
            this.putValue("hideWhenDisabled", true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            assert (false);
        }

        public Action createContextAwareInstance(Lookup lookup) {
            Collection collection = lookup.lookupAll(Project.class);
            if (collection.size() != 1) {
                return this;
            }
            AbstractLogicalViewProvider abstractLogicalViewProvider = (AbstractLogicalViewProvider)((Project)collection.iterator().next()).getLookup().lookup(AbstractLogicalViewProvider.class);
            if (abstractLogicalViewProvider == null) {
                return this;
            }
            switch (this.mode) {
                case 1: {
                    return abstractLogicalViewProvider.new BrokenLinksAction();
                }
                case 2: {
                    return abstractLogicalViewProvider.new BrokenServerAction();
                }
            }
            return abstractLogicalViewProvider.new BrokenDataSourceAction();
        }
    }

    public final class LogicalViewRootNode
    extends AbstractNode
    implements ChangeListener {
        private String shortDesc;
        private String actionsFolderLayer;
        private Class helpContext;

        public LogicalViewRootNode(String string, String string2, String string3, String string4, Class clazz) {
            super(NodeFactorySupport.createCompositeChildren((Project)AbstractLogicalViewProvider.this.project, (String)string), AbstractLogicalViewProvider.createLookup(AbstractLogicalViewProvider.this.project));
            this.shortDesc = string4;
            this.actionsFolderLayer = string2;
            this.helpContext = clazz;
            this.setIconBaseWithExtension(string3);
            super.setName(ProjectUtils.getInformation((Project)AbstractLogicalViewProvider.this.project).getDisplayName());
            AbstractLogicalViewProvider.this.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)AbstractLogicalViewProvider.this));
            AbstractLogicalViewProvider.this.testBroken();
        }

        public String getShortDescription() {
            String string = FileUtil.getFileDisplayName((FileObject)AbstractLogicalViewProvider.this.project.getProjectDirectory());
            return MessageFormat.format(this.shortDesc, string);
        }

        public Image getIcon(int n) {
            Image image = super.getIcon(n);
            if (this.isBroken()) {
                return ImageUtilities.mergeImages((Image)image, (Image)ProjectProperties.ICON_BROKEN_BADGE.getImage(), (int)8, (int)0);
            }
            if (AbstractLogicalViewProvider.this.deployOnSaveDisabled) {
                return DeployOnSaveUtils.badgeDisabledDeployOnSave(image);
            }
            return image;
        }

        public Image getOpenedIcon(int n) {
            Image image = super.getOpenedIcon(n);
            if (this.isBroken()) {
                return ImageUtilities.mergeImages((Image)image, (Image)ProjectProperties.ICON_BROKEN_BADGE.getImage(), (int)8, (int)0);
            }
            if (AbstractLogicalViewProvider.this.deployOnSaveDisabled) {
                return DeployOnSaveUtils.badgeDisabledDeployOnSave(image);
            }
            return image;
        }

        public String getHtmlDisplayName() {
            String string = super.getDisplayName();
            try {
                string = XMLUtil.toElementContent((String)string);
            }
            catch (CharConversionException charConversionException) {
                return string;
            }
            return this.isBroken() ? "<font color=\"#A40000\">" + string + "</font>" : null;
        }

        public Action[] getActions(boolean bl) {
            return CommonProjectActions.forType((String)this.actionsFolderLayer);
        }

        public boolean canRename() {
            return true;
        }

        public void setName(String string) {
            DefaultProjectOperations.performDefaultRenameOperation((Project)AbstractLogicalViewProvider.this.project, (String)string);
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(this.helpContext);
        }

        private boolean isBroken() {
            return AbstractLogicalViewProvider.this.broken || AbstractLogicalViewProvider.this.brokenServer || AbstractLogicalViewProvider.this.brokenDataSource || AbstractLogicalViewProvider.this.illegalState;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.fireIconChange();
            this.fireOpenedIconChange();
            this.fireDisplayNameChange(null, null);
        }
    }
}

