/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.service.profiles;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.websvc.wsitconf.spi.SecurityProfile;
import org.netbeans.modules.websvc.wsitconf.spi.features.SecureConversationFeature;
import org.netbeans.modules.websvc.wsitconf.ui.service.profiles.ProfileBaseForm;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.AlgoSuiteModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityTokensModelHelper;
import org.netbeans.modules.websvc.wsitmodelext.security.BootstrapPolicy;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.ProtectionToken;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.SecureConversationToken;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class UsernameAuthPasswordDerivedKeys
extends ProfileBaseForm {
    private JComboBox algoSuiteCombo;
    private JLabel algoSuiteLabel;
    private JCheckBox derivedKeysChBox;
    private JComboBox layoutCombo;
    private JLabel layoutLabel;
    private JCheckBox protectTokensChBox;
    private JCheckBox reqDerivedKeys;
    private JCheckBox secConvChBox;

    public UsernameAuthPasswordDerivedKeys(WSDLComponent comp, SecurityProfile secProfile) {
        super(comp, secProfile);
        this.initComponents();
        this.comp = comp;
        this.secProfile = secProfile;
        this.inSync = true;
        this.fillLayoutCombo(this.layoutCombo);
        this.fillAlgoSuiteCombo(this.algoSuiteCombo);
        this.inSync = false;
        this.sync();
    }

    @Override
    protected void sync() {
        this.inSync = true;
        ExtensibilityElement secBinding = null;
        ExtensibilityElement topSecBinding = SecurityPolicyModelHelper.getSecurityBindingTypeElement(this.comp);
        WSDLComponent protTokenKind = SecurityTokensModelHelper.getTokenElement((WSDLComponent)topSecBinding, ProtectionToken.class);
        WSDLComponent protToken = SecurityTokensModelHelper.getTokenTypeElement(protTokenKind);
        boolean secConv = protToken instanceof SecureConversationToken;
        if (secConv) {
            WSDLComponent bootPolicy = SecurityTokensModelHelper.getTokenElement(protToken, BootstrapPolicy.class);
            secBinding = SecurityPolicyModelHelper.getSecurityBindingTypeElement(bootPolicy);
            this.setChBox(this.derivedKeysChBox, SecurityPolicyModelHelper.isRequireDerivedKeys(protToken));
        } else {
            secBinding = SecurityPolicyModelHelper.getSecurityBindingTypeElement(this.comp);
        }
        this.setChBox(this.secConvChBox, secConv);
        WSDLComponent tokenKind = SecurityTokensModelHelper.getTokenElement((WSDLComponent)secBinding, ProtectionToken.class);
        WSDLComponent token = SecurityTokensModelHelper.getTokenTypeElement(tokenKind);
        this.setChBox(this.reqDerivedKeys, SecurityPolicyModelHelper.isRequireDerivedKeys(token));
        this.setCombo(this.algoSuiteCombo, AlgoSuiteModelHelper.getAlgorithmSuite((WSDLComponent)secBinding));
        this.setCombo(this.layoutCombo, SecurityPolicyModelHelper.getMessageLayout((WSDLComponent)secBinding));
        this.setChBox(this.protectTokensChBox, SecurityPolicyModelHelper.isProtectTokens((WSDLComponent)secBinding));
        this.enableDisable();
        this.inSync = false;
    }

    @Override
    public void setValue(JComponent source) {
        if (this.inSync) {
            return;
        }
        ExtensibilityElement secBinding = null;
        ExtensibilityElement topSecBinding = SecurityPolicyModelHelper.getSecurityBindingTypeElement(this.comp);
        WSDLComponent protTokenKind = SecurityTokensModelHelper.getTokenElement((WSDLComponent)topSecBinding, ProtectionToken.class);
        WSDLComponent protToken = SecurityTokensModelHelper.getTokenTypeElement(protTokenKind);
        boolean secConv = protToken instanceof SecureConversationToken;
        if (source.equals(this.secConvChBox)) {
            ((SecureConversationFeature)((Object)this.secProfile)).enableSecureConversation(this.comp, this.secConvChBox.isSelected());
            this.sync();
        }
        SecurityPolicyModelHelper spmh = SecurityPolicyModelHelper.getInstance(this.cfgVersion);
        AlgoSuiteModelHelper asmh = AlgoSuiteModelHelper.getInstance(this.cfgVersion);
        if (secConv) {
            WSDLComponent bootPolicy = SecurityTokensModelHelper.getTokenElement(protToken, BootstrapPolicy.class);
            secBinding = SecurityPolicyModelHelper.getSecurityBindingTypeElement(bootPolicy);
            if (source.equals(this.derivedKeysChBox)) {
                spmh.enableRequireDerivedKeys(protToken, this.derivedKeysChBox.isSelected());
            }
        } else {
            secBinding = SecurityPolicyModelHelper.getSecurityBindingTypeElement(this.comp);
        }
        if (source.equals(this.protectTokensChBox)) {
            spmh.enableProtectTokens((WSDLComponent)secBinding, this.protectTokensChBox.isSelected());
        }
        if (source.equals(this.layoutCombo)) {
            spmh.setLayout((WSDLComponent)secBinding, (String)this.layoutCombo.getSelectedItem());
            if (secConv) {
                spmh.setLayout((WSDLComponent)topSecBinding, (String)this.layoutCombo.getSelectedItem());
            }
        }
        if (source.equals(this.algoSuiteCombo)) {
            asmh.setAlgorithmSuite((WSDLComponent)secBinding, (String)this.algoSuiteCombo.getSelectedItem());
            if (secConv) {
                asmh.setAlgorithmSuite((WSDLComponent)topSecBinding, (String)this.algoSuiteCombo.getSelectedItem());
            }
        }
        if (source.equals(this.reqDerivedKeys)) {
            WSDLComponent tokenKind = SecurityTokensModelHelper.getTokenElement((WSDLComponent)secBinding, ProtectionToken.class);
            WSDLComponent token = SecurityTokensModelHelper.getTokenTypeElement(tokenKind);
            spmh.enableRequireDerivedKeys(token, this.reqDerivedKeys.isSelected());
            return;
        }
        this.enableDisable();
    }

    @Override
    protected void enableDisable() {
        boolean secConvEnabled = this.secConvChBox.isSelected();
        this.derivedKeysChBox.setEnabled(secConvEnabled);
    }

    private void initComponents() {
        this.secConvChBox = new JCheckBox();
        this.protectTokensChBox = new JCheckBox();
        this.derivedKeysChBox = new JCheckBox();
        this.algoSuiteLabel = new JLabel();
        this.algoSuiteCombo = new JComboBox();
        this.layoutLabel = new JLabel();
        this.layoutCombo = new JComboBox();
        this.reqDerivedKeys = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.secConvChBox, (String)NbBundle.getMessage(UsernameAuthPasswordDerivedKeys.class, (String)"LBL_SecConvLabel"));
        this.secConvChBox.setMargin(new Insets(0, 0, 0, 0));
        this.secConvChBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UsernameAuthPasswordDerivedKeys.this.secConvChBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.protectTokensChBox, (String)NbBundle.getMessage(UsernameAuthPasswordDerivedKeys.class, (String)"LBL_ProtectTokens"));
        this.protectTokensChBox.setMargin(new Insets(0, 0, 0, 0));
        this.protectTokensChBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UsernameAuthPasswordDerivedKeys.this.protectTokensChBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.derivedKeysChBox, (String)NbBundle.getMessage(UsernameAuthPasswordDerivedKeys.class, (String)"LBL_RequireDerivedKeysForSecConv"));
        this.derivedKeysChBox.setMargin(new Insets(0, 0, 0, 0));
        this.derivedKeysChBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UsernameAuthPasswordDerivedKeys.this.derivedKeysChBoxActionPerformed(evt);
            }
        });
        this.algoSuiteLabel.setLabelFor(this.algoSuiteCombo);
        Mnemonics.setLocalizedText((JLabel)this.algoSuiteLabel, (String)NbBundle.getMessage(UsernameAuthPasswordDerivedKeys.class, (String)"LBL_AlgoSuiteLabel"));
        this.algoSuiteCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UsernameAuthPasswordDerivedKeys.this.algoSuiteComboActionPerformed(evt);
            }
        });
        this.layoutLabel.setLabelFor(this.layoutCombo);
        Mnemonics.setLocalizedText((JLabel)this.layoutLabel, (String)NbBundle.getMessage(UsernameAuthPasswordDerivedKeys.class, (String)"LBL_LayoutLabel"));
        this.layoutCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UsernameAuthPasswordDerivedKeys.this.layoutComboActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.reqDerivedKeys, (String)NbBundle.getMessage(UsernameAuthPasswordDerivedKeys.class, (String)"LBL_RequireDerivedKeys"));
        this.reqDerivedKeys.setMargin(new Insets(0, 0, 0, 0));
        this.reqDerivedKeys.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UsernameAuthPasswordDerivedKeys.this.reqDerivedKeysActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.reqDerivedKeys).add((Component)this.protectTokensChBox).add((Component)this.secConvChBox).add((Component)this.derivedKeysChBox).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.layoutLabel).add((Component)this.algoSuiteLabel)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.algoSuiteCombo, -2, -1, -2).add((Component)this.layoutCombo, -2, -1, -2)))).addContainerGap()));
        layout.linkSize(new Component[]{this.algoSuiteCombo, this.layoutCombo}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.algoSuiteLabel).add((Component)this.algoSuiteCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.layoutLabel).add((Component)this.layoutCombo, -2, -1, -2)).addPreferredGap(0).add((Component)this.reqDerivedKeys).addPreferredGap(0).add((Component)this.secConvChBox).addPreferredGap(0).add((Component)this.derivedKeysChBox).addPreferredGap(0).add((Component)this.protectTokensChBox).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(new Component[]{this.algoSuiteCombo, this.layoutCombo}, 2);
    }

    private void reqDerivedKeysActionPerformed(ActionEvent evt) {
        this.setValue(this.reqDerivedKeys);
    }

    private void protectTokensChBoxActionPerformed(ActionEvent evt) {
        this.setValue(this.protectTokensChBox);
    }

    private void derivedKeysChBoxActionPerformed(ActionEvent evt) {
        this.setValue(this.derivedKeysChBox);
    }

    private void secConvChBoxActionPerformed(ActionEvent evt) {
        this.setValue(this.secConvChBox);
    }

    private void layoutComboActionPerformed(ActionEvent evt) {
        this.setValue(this.layoutCombo);
    }

    private void algoSuiteComboActionPerformed(ActionEvent evt) {
        this.setValue(this.algoSuiteCombo);
    }
}

