/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.service.profiles;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.websvc.wsitconf.spi.SecurityProfile;
import org.netbeans.modules.websvc.wsitconf.spi.features.SecureConversationFeature;
import org.netbeans.modules.websvc.wsitconf.ui.ComboConstants;
import org.netbeans.modules.websvc.wsitconf.ui.service.profiles.ProfileBaseForm;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.AlgoSuiteModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.PolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityTokensModelHelper;
import org.netbeans.modules.websvc.wsitmodelext.policy.Policy;
import org.netbeans.modules.websvc.wsitmodelext.security.BootstrapPolicy;
import org.netbeans.modules.websvc.wsitmodelext.security.WssElement;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.SecureConversationToken;
import org.netbeans.modules.websvc.wsitmodelext.versioning.ConfigVersion;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class MessageAuthentication
extends ProfileBaseForm {
    private JComboBox algoSuiteCombo;
    private JLabel algoSuiteLabel;
    private JCheckBox derivedKeysSecConvChBox;
    private JComboBox layoutCombo;
    private JLabel layoutLabel;
    private JCheckBox reqSigConfChBox;
    private JCheckBox secConvChBox;
    private JComboBox supportTokenCombo;
    private JLabel supportTokenLabel;
    private JComboBox wssVersionCombo;
    private JLabel wssVersionLabel;

    public MessageAuthentication(WSDLComponent comp, SecurityProfile secProfile) {
        super(comp, secProfile);
        this.initComponents();
        this.inSync = true;
        this.supportTokenCombo.removeAllItems();
        this.supportTokenCombo.addItem(ComboConstants.X509);
        this.supportTokenCombo.addItem(ComboConstants.USERNAME);
        this.fillWssCombo(this.wssVersionCombo);
        this.fillLayoutCombo(this.layoutCombo);
        this.fillAlgoSuiteCombo(this.algoSuiteCombo);
        this.inSync = false;
        this.sync();
    }

    @Override
    protected void sync() {
        this.inSync = true;
        ExtensibilityElement secBinding = null;
        WSDLComponent endToken = SecurityTokensModelHelper.getSupportingToken(this.comp, 2);
        WSDLComponent secConvT = SecurityTokensModelHelper.getTokenElement(endToken, SecureConversationToken.class);
        boolean secConv = secConvT instanceof SecureConversationToken;
        if (secConv) {
            WSDLComponent bootPolicy = SecurityTokensModelHelper.getTokenElement(secConvT, BootstrapPolicy.class);
            secBinding = SecurityPolicyModelHelper.getSecurityBindingTypeElement(bootPolicy);
            Policy p = (Policy)secBinding.getParent();
            this.setChBox(this.secConvChBox, true);
            this.setChBox(this.derivedKeysSecConvChBox, SecurityPolicyModelHelper.isRequireDerivedKeys(secConvT));
            this.setCombo(this.wssVersionCombo, SecurityPolicyModelHelper.isWss11((WSDLComponent)p));
            this.setChBox(this.reqSigConfChBox, SecurityPolicyModelHelper.isRequireSignatureConfirmation((WSDLComponent)p));
            p = (Policy)PolicyModelHelper.getTopLevelElement(bootPolicy, Policy.class, false);
            WSDLComponent tokenKind = SecurityTokensModelHelper.getSupportingToken((WSDLComponent)p, 2);
            if (tokenKind == null) {
                tokenKind = ConfigVersion.CONFIG_1_0.equals((Object)this.cfgVersion) ? SecurityTokensModelHelper.getSupportingToken((WSDLComponent)p, 1) : SecurityTokensModelHelper.getSupportingToken((WSDLComponent)p, 5);
            }
            String tokenType = SecurityTokensModelHelper.getTokenType(tokenKind);
            this.setCombo(this.supportTokenCombo, tokenType);
        } else {
            secBinding = SecurityPolicyModelHelper.getSecurityBindingTypeElement(this.comp);
            this.setChBox(this.secConvChBox, false);
            this.setChBox(this.derivedKeysSecConvChBox, false);
            this.setCombo(this.wssVersionCombo, SecurityPolicyModelHelper.isWss11(this.comp));
            this.setChBox(this.reqSigConfChBox, SecurityPolicyModelHelper.isRequireSignatureConfirmation(this.comp));
            WSDLComponent tokenKind = SecurityTokensModelHelper.getSupportingToken(this.comp, 2);
            if (tokenKind == null) {
                tokenKind = ConfigVersion.CONFIG_1_0.equals((Object)this.cfgVersion) ? SecurityTokensModelHelper.getSupportingToken(this.comp, 1) : SecurityTokensModelHelper.getSupportingToken(this.comp, 5);
            }
            String tokenType = SecurityTokensModelHelper.getTokenType(tokenKind);
            this.setCombo(this.supportTokenCombo, tokenType);
        }
        this.setCombo(this.algoSuiteCombo, AlgoSuiteModelHelper.getAlgorithmSuite((WSDLComponent)secBinding));
        this.setCombo(this.layoutCombo, SecurityPolicyModelHelper.getMessageLayout((WSDLComponent)secBinding));
        this.enableDisable();
        this.inSync = false;
    }

    @Override
    public void setValue(JComponent source) {
        if (this.inSync) {
            return;
        }
        ExtensibilityElement secBinding = null;
        ExtensibilityElement topSecBinding = SecurityPolicyModelHelper.getSecurityBindingTypeElement(this.comp);
        WSDLComponent endToken = SecurityTokensModelHelper.getSupportingToken(this.comp, 2);
        WSDLComponent secConvT = SecurityTokensModelHelper.getTokenElement(endToken, SecureConversationToken.class);
        boolean secConv = secConvT instanceof SecureConversationToken;
        ConfigVersion configVersion = PolicyModelHelper.getConfigVersion(this.comp);
        SecurityPolicyModelHelper spmh = SecurityPolicyModelHelper.getInstance(configVersion);
        if (source.equals(this.secConvChBox)) {
            ((SecureConversationFeature)((Object)this.secProfile)).enableSecureConversation(this.comp, this.secConvChBox.isSelected());
            if (this.secConvChBox.isSelected()) {
                endToken = SecurityTokensModelHelper.getSupportingToken(this.comp, 2);
                secConvT = SecurityTokensModelHelper.getTokenElement(endToken, SecureConversationToken.class);
                spmh.enableRequireDerivedKeys(secConvT, true);
            }
            this.sync();
        }
        SecurityTokensModelHelper stmh = SecurityTokensModelHelper.getInstance(configVersion);
        AlgoSuiteModelHelper apmh = AlgoSuiteModelHelper.getInstance(configVersion);
        if (secConv) {
            WSDLComponent bootPolicy = SecurityTokensModelHelper.getTokenElement(secConvT, BootstrapPolicy.class);
            secBinding = SecurityPolicyModelHelper.getSecurityBindingTypeElement(bootPolicy);
            Policy p = (Policy)secBinding.getParent();
            if (source.equals(this.derivedKeysSecConvChBox)) {
                spmh.enableRequireDerivedKeys(secConvT, this.derivedKeysSecConvChBox.isSelected());
            }
            if (source.equals(this.wssVersionCombo)) {
                boolean wss11 = ComboConstants.WSS11.equals(this.wssVersionCombo.getSelectedItem());
                WssElement wss = spmh.enableWss((WSDLComponent)p, wss11);
                if (wss11) {
                    spmh.enableRequireSignatureConfirmation((WssElement)SecurityPolicyModelHelper.getWss11((WSDLComponent)p), this.reqSigConfChBox.isSelected());
                }
            }
            p = (Policy)PolicyModelHelper.getTopLevelElement(bootPolicy, Policy.class, false);
            if (source.equals(this.supportTokenCombo)) {
                if (this.supportTokenCombo.getSelectedItem().equals(ComboConstants.X509)) {
                    SecurityTokensModelHelper.removeSupportingTokens((WSDLComponent)p);
                    stmh.setSupportingTokens((WSDLComponent)p, (String)this.supportTokenCombo.getSelectedItem(), 2);
                } else {
                    SecurityTokensModelHelper.removeSupportingTokens((WSDLComponent)p);
                    if (ConfigVersion.CONFIG_1_0.equals((Object)this.cfgVersion)) {
                        stmh.setSupportingTokens((WSDLComponent)p, (String)this.supportTokenCombo.getSelectedItem(), 1);
                    } else {
                        stmh.setSupportingTokens((WSDLComponent)p, (String)this.supportTokenCombo.getSelectedItem(), 5);
                    }
                }
            }
        } else {
            secBinding = SecurityPolicyModelHelper.getSecurityBindingTypeElement(this.comp);
            if (source.equals(this.reqSigConfChBox)) {
                spmh.enableRequireSignatureConfirmation((WssElement)SecurityPolicyModelHelper.getWss11(this.comp), this.reqSigConfChBox.isSelected());
            }
            if (source.equals(this.wssVersionCombo)) {
                boolean wss11 = ComboConstants.WSS11.equals(this.wssVersionCombo.getSelectedItem());
                WssElement wss = spmh.enableWss(this.comp, wss11);
                if (wss11) {
                    spmh.enableRequireSignatureConfirmation((WssElement)SecurityPolicyModelHelper.getWss11(this.comp), this.reqSigConfChBox.isSelected());
                }
            }
            if (source.equals(this.supportTokenCombo)) {
                if (this.supportTokenCombo.getSelectedItem().equals(ComboConstants.X509)) {
                    SecurityTokensModelHelper.removeSupportingTokens(this.comp);
                    stmh.setSupportingTokens(this.comp, (String)this.supportTokenCombo.getSelectedItem(), 2);
                } else {
                    SecurityTokensModelHelper.removeSupportingTokens(this.comp);
                    if (ConfigVersion.CONFIG_1_0.equals((Object)this.cfgVersion)) {
                        stmh.setSupportingTokens(this.comp, (String)this.supportTokenCombo.getSelectedItem(), 1);
                    } else {
                        stmh.setSupportingTokens(this.comp, (String)this.supportTokenCombo.getSelectedItem(), 5);
                    }
                }
            }
        }
        if (source.equals(this.layoutCombo)) {
            spmh.setLayout((WSDLComponent)secBinding, (String)this.layoutCombo.getSelectedItem());
            if (secConv) {
                spmh.setLayout((WSDLComponent)topSecBinding, (String)this.layoutCombo.getSelectedItem());
            }
        }
        if (source.equals(this.algoSuiteCombo)) {
            apmh.setAlgorithmSuite((WSDLComponent)secBinding, (String)this.algoSuiteCombo.getSelectedItem());
            if (secConv) {
                apmh.setAlgorithmSuite((WSDLComponent)topSecBinding, (String)this.algoSuiteCombo.getSelectedItem());
            }
        }
        this.enableDisable();
    }

    @Override
    protected void enableDisable() {
        boolean secConvEnabled = this.secConvChBox.isSelected();
        this.derivedKeysSecConvChBox.setEnabled(secConvEnabled);
        this.reqSigConfChBox.setEnabled(!secConvEnabled);
        boolean wss11 = ComboConstants.WSS11.equals(this.wssVersionCombo.getSelectedItem());
        this.reqSigConfChBox.setEnabled(wss11);
    }

    private void initComponents() {
        this.supportTokenLabel = new JLabel();
        this.supportTokenCombo = new JComboBox();
        this.secConvChBox = new JCheckBox();
        this.reqSigConfChBox = new JCheckBox();
        this.derivedKeysSecConvChBox = new JCheckBox();
        this.wssVersionLabel = new JLabel();
        this.wssVersionCombo = new JComboBox();
        this.algoSuiteLabel = new JLabel();
        this.algoSuiteCombo = new JComboBox();
        this.layoutLabel = new JLabel();
        this.layoutCombo = new JComboBox();
        this.supportTokenLabel.setLabelFor(this.supportTokenCombo);
        Mnemonics.setLocalizedText((JLabel)this.supportTokenLabel, (String)NbBundle.getMessage(MessageAuthentication.class, (String)"LBL_AuthToken"));
        this.supportTokenCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MessageAuthentication.this.supportTokenComboActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.secConvChBox, (String)NbBundle.getMessage(MessageAuthentication.class, (String)"LBL_SecConvLabel"));
        this.secConvChBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.secConvChBox.setMargin(new Insets(0, 0, 0, 0));
        this.secConvChBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MessageAuthentication.this.secConvChBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.reqSigConfChBox, (String)NbBundle.getMessage(MessageAuthentication.class, (String)"LBL_RequireSigConfirmation"));
        this.reqSigConfChBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.reqSigConfChBox.setMargin(new Insets(0, 0, 0, 0));
        this.reqSigConfChBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MessageAuthentication.this.reqSigConfChBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.derivedKeysSecConvChBox, (String)NbBundle.getMessage(MessageAuthentication.class, (String)"LBL_RequireDerivedKeysForSecConv"));
        this.derivedKeysSecConvChBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.derivedKeysSecConvChBox.setMargin(new Insets(0, 0, 0, 0));
        this.derivedKeysSecConvChBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MessageAuthentication.this.derivedKeysSecConvChBoxActionPerformed(evt);
            }
        });
        this.wssVersionLabel.setLabelFor(this.wssVersionCombo);
        Mnemonics.setLocalizedText((JLabel)this.wssVersionLabel, (String)NbBundle.getMessage(MessageAuthentication.class, (String)"LBL_WSSVersionLabel"));
        this.wssVersionCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MessageAuthentication.this.wssVersionComboActionPerformed(evt);
            }
        });
        this.algoSuiteLabel.setLabelFor(this.algoSuiteCombo);
        Mnemonics.setLocalizedText((JLabel)this.algoSuiteLabel, (String)NbBundle.getMessage(MessageAuthentication.class, (String)"LBL_AlgoSuiteLabel"));
        this.algoSuiteCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MessageAuthentication.this.algoSuiteComboActionPerformed(evt);
            }
        });
        this.layoutLabel.setLabelFor(this.layoutCombo);
        Mnemonics.setLocalizedText((JLabel)this.layoutLabel, (String)NbBundle.getMessage(MessageAuthentication.class, (String)"LBL_LayoutLabel"));
        this.layoutCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MessageAuthentication.this.layoutComboActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.reqSigConfChBox).add((Component)this.secConvChBox).add((Component)this.derivedKeysSecConvChBox).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.layoutLabel).add((Component)this.supportTokenLabel).add((Component)this.wssVersionLabel).add((Component)this.algoSuiteLabel)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.supportTokenCombo, -2, -1, -2).add(2, (Component)this.wssVersionCombo, -2, -1, -2).add(2, (Component)this.algoSuiteCombo, -2, -1, -2).add(2, (Component)this.layoutCombo, -2, -1, -2)))).add(33, 33, 33)));
        layout.linkSize(new Component[]{this.algoSuiteCombo, this.layoutCombo, this.supportTokenCombo, this.wssVersionCombo}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.supportTokenLabel).add((Component)this.supportTokenCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.wssVersionLabel).add((Component)this.wssVersionCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.algoSuiteLabel).add((Component)this.algoSuiteCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.layoutLabel).add((Component)this.layoutCombo, -2, -1, -2)).addPreferredGap(0).add((Component)this.secConvChBox).addPreferredGap(0).add((Component)this.derivedKeysSecConvChBox).addPreferredGap(0).add((Component)this.reqSigConfChBox).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(new Component[]{this.layoutCombo, this.supportTokenCombo, this.wssVersionCombo}, 2);
    }

    private void reqSigConfChBoxActionPerformed(ActionEvent evt) {
        this.setValue(this.reqSigConfChBox);
    }

    private void derivedKeysSecConvChBoxActionPerformed(ActionEvent evt) {
        this.setValue(this.derivedKeysSecConvChBox);
    }

    private void secConvChBoxActionPerformed(ActionEvent evt) {
        this.setValue(this.secConvChBox);
    }

    private void wssVersionComboActionPerformed(ActionEvent evt) {
        this.setValue(this.wssVersionCombo);
    }

    private void supportTokenComboActionPerformed(ActionEvent evt) {
        this.setValue(this.supportTokenCombo);
    }

    private void layoutComboActionPerformed(ActionEvent evt) {
        this.setValue(this.layoutCombo);
    }

    private void algoSuiteComboActionPerformed(ActionEvent evt) {
        this.setValue(this.algoSuiteCombo);
    }
}

