/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.server;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.remote.server.RemoteServerRecord;
import org.netbeans.modules.cnd.remote.support.RemoteCommandSupport;
import org.netbeans.modules.cnd.remote.support.RemoteProjectSupport;
import org.netbeans.modules.cnd.remote.support.RemoteUtil;
import org.netbeans.modules.cnd.spi.remote.RemoteSyncFactory;
import org.netbeans.modules.cnd.spi.remote.ServerListImplementation;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.util.PasswordManager;
import org.openide.util.ChangeSupport;
import org.openide.util.NbPreferences;

public class RemoteServerList
implements ServerListImplementation {
    private static final String CND_REMOTE = "cnd.remote";
    private static final String REMOTE_SERVERS = "cnd.remote.servers";
    private static final char SERVER_RECORD_SEPARATOR = '|';
    private static final String SERVER_LIST_SEPARATOR = ",";
    private static final String DEFAULT_INDEX = "cnd.remote.default";
    private int defaultIndex;
    private final PropertyChangeSupport pcs;
    private final ChangeSupport cs;
    private final ArrayList<RemoteServerRecord> unlisted;
    private final ArrayList<RemoteServerRecord> items = new ArrayList();
    private static final Comparator<RemoteServerRecord> RECORDS_COMPARATOR = new Comparator<RemoteServerRecord>(){

        @Override
        public int compare(RemoteServerRecord o1, RemoteServerRecord o2) {
            boolean o2local;
            if (o1 == o2) {
                return 0;
            }
            boolean o1local = o1.getExecutionEnvironment().isLocal();
            if (o1local != (o2local = o2.getExecutionEnvironment().isLocal())) {
                if (o1local) {
                    return -1;
                }
                if (o2local) {
                    return 1;
                }
            }
            return o1.getServerName().compareTo(o2.getServerName());
        }
    };

    public RemoteServerList() {
        String slist = RemoteServerList.getPreferences().get(REMOTE_SERVERS, null);
        this.defaultIndex = RemoteServerList.getPreferences().getInt(DEFAULT_INDEX, 0);
        this.pcs = new PropertyChangeSupport(this);
        this.cs = new ChangeSupport((Object)this);
        this.unlisted = new ArrayList();
        this.addServer(ExecutionEnvironmentFactory.getLocal(), null, RemoteSyncFactory.getDefault(), false, RemoteServerRecord.State.ONLINE);
        if (slist != null) {
            for (String serverString : slist.split(SERVER_LIST_SEPARATOR)) {
                String syncId;
                String displayName = null;
                RemoteSyncFactory syncFactory = RemoteSyncFactory.getDefault();
                String[] arr = serverString.split("\\|");
                CndUtils.assertTrue((arr.length > 0 ? 1 : 0) != 0);
                String hostKey = arr[0];
                if (arr.length > 1) {
                    displayName = arr[1];
                }
                ExecutionEnvironment env = ExecutionEnvironmentFactory.fromUniqueID((String)hostKey);
                if (arr.length > 2 && (syncFactory = RemoteSyncFactory.fromID((String)(syncId = arr[2]))) == null) {
                    syncFactory = RemoteSyncFactory.getDefault();
                    RemoteUtil.LOGGER.log(Level.WARNING, "Unsupported synchronization mode \"{0}\" for {1}. Switching to default one.", new Object[]{syncId, env.toString()});
                }
                if (!env.isRemote()) continue;
                RemoteServerRecord record = this.addServer(env, displayName, syncFactory, false, RemoteServerRecord.State.OFFLINE);
                if (arr.length <= 3) continue;
                record.setX11Forwarding(Boolean.parseBoolean(arr[3]));
            }
        }
        this.defaultIndex = Math.min(this.defaultIndex, this.items.size() - 1);
        this.refresh();
    }

    public synchronized ServerRecord get(ExecutionEnvironment env) {
        for (RemoteServerRecord record : this.items) {
            if (!env.equals(record.getExecutionEnvironment())) continue;
            return record;
        }
        for (RemoteServerRecord record : this.unlisted) {
            if (!env.equals(record.getExecutionEnvironment())) continue;
            return record;
        }
        RemoteServerRecord record = new RemoteServerRecord(env, null, RemoteSyncFactory.getDefault(), false);
        this.unlisted.add(record);
        return record;
    }

    @SuppressWarnings(value={"UG"})
    public ServerRecord get(Project project) {
        ExecutionEnvironment execEnv = RemoteProjectSupport.getExecutionEnvironment(project);
        if (execEnv != null) {
            return this.get(execEnv);
        }
        return null;
    }

    public synchronized ServerRecord getDefaultRecord() {
        return this.items.get(this.defaultIndex);
    }

    private synchronized void setDefaultIndexImpl(int defaultIndex) {
        int oldValue = this.defaultIndex;
        this.defaultIndex = defaultIndex;
        RemoteServerList.getPreferences().putInt(DEFAULT_INDEX, defaultIndex);
        this.firePropertyChange("DEFAULT_RECORD", oldValue, defaultIndex);
    }

    public void setDefaultRecord(ServerRecord record) {
        assert (record != null);
        for (int i = 0; i < this.items.size(); ++i) {
            if (!this.items.get(i).equals(record)) continue;
            this.setDefaultIndexImpl(i);
            return;
        }
        CndUtils.assertTrue((boolean)false, (String)"Can not set nonexistent record as default");
    }

    public synchronized List<ExecutionEnvironment> getEnvironments() {
        ArrayList<ExecutionEnvironment> result = new ArrayList<ExecutionEnvironment>(this.items.size());
        for (RemoteServerRecord item : this.items) {
            result.add(item.getExecutionEnvironment());
        }
        return result;
    }

    private RemoteServerRecord addServer(ExecutionEnvironment execEnv, String displayName, RemoteSyncFactory syncFactory, boolean asDefault, RemoteServerRecord.State state) {
        RemoteServerRecord record = (RemoteServerRecord)this.addServer(execEnv, displayName, syncFactory, asDefault, false);
        record.setState(state);
        return record;
    }

    public synchronized ServerRecord addServer(ExecutionEnvironment execEnv, String displayName, RemoteSyncFactory syncFactory, boolean asDefault, boolean connect) {
        RemoteServerRecord record = null;
        if (syncFactory == null) {
            syncFactory = RemoteSyncFactory.getDefault();
        }
        for (RemoteServerRecord r : this.items) {
            if (!r.getExecutionEnvironment().equals(execEnv)) continue;
            if (asDefault) {
                this.defaultIndex = this.items.indexOf(r);
                RemoteServerList.getPreferences().putInt(DEFAULT_INDEX, this.defaultIndex);
            }
            return r;
        }
        for (RemoteServerRecord r : this.unlisted) {
            if (!r.getExecutionEnvironment().equals(execEnv)) continue;
            record = r;
            break;
        }
        if (record == null) {
            record = new RemoteServerRecord(execEnv, displayName, syncFactory, connect);
        } else {
            record.setDeleted(false);
            record.setDisplayName(displayName);
            record.setSyncFactory(syncFactory);
            this.unlisted.remove(record);
        }
        ArrayList<RemoteServerRecord> oldItems = new ArrayList<RemoteServerRecord>(this.items);
        this.items.add(record);
        Collections.sort(this.items, RECORDS_COMPARATOR);
        if (asDefault) {
            this.defaultIndex = this.items.indexOf(record);
        }
        this.refresh();
        RemoteServerList.storePreferences(record);
        RemoteServerList.getPreferences().putInt(DEFAULT_INDEX, this.defaultIndex);
        this.firePropertyChange("RECORD_LIST", oldItems, new ArrayList<RemoteServerRecord>(this.items));
        return record;
    }

    public static void storePreferences(RemoteServerRecord record) {
        String displayName = record.getRawDisplayName();
        String slist = RemoteServerList.getPreferences().get(REMOTE_SERVERS, null);
        String hostKey = ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)record.getExecutionEnvironment());
        String preferencesKey = hostKey + '|' + (displayName == null ? "" : displayName) + '|' + record.getSyncFactory().getID() + '|' + record.getX11Forwarding();
        if (slist == null) {
            RemoteServerList.getPreferences().put(REMOTE_SERVERS, preferencesKey);
        } else {
            StringBuilder sb = new StringBuilder(preferencesKey);
            for (String server : slist.split(SERVER_LIST_SEPARATOR)) {
                String serverKey;
                int sepPos = server.indexOf(124);
                String string = serverKey = sepPos > 0 ? server.substring(0, sepPos) : server;
                if (serverKey.equals(hostKey)) continue;
                sb.append(SERVER_LIST_SEPARATOR);
                sb.append(server);
            }
            RemoteServerList.getPreferences().put(REMOTE_SERVERS, sb.toString());
        }
    }

    public synchronized void set(List<ServerRecord> records, ServerRecord defaultRecord) {
        ArrayList<RemoteServerRecord> oldItems = new ArrayList<RemoteServerRecord>(this.items);
        RemoteUtil.LOGGER.log(Level.FINEST, "ServerList: set {0}", records);
        Collection<ExecutionEnvironment> removed = this.clear();
        ArrayList<ExecutionEnvironment> allEnv = new ArrayList<ExecutionEnvironment>();
        for (ServerRecord rec : records) {
            this.addServer(rec.getExecutionEnvironment(), rec.getDisplayName(), rec.getSyncFactory(), false, false);
            removed.remove(rec.getExecutionEnvironment());
            allEnv.add(rec.getExecutionEnvironment());
        }
        this.setDefaultRecord(defaultRecord);
        PasswordManager.getInstance().setServerList(allEnv);
        this.firePropertyChange("RECORD_LIST", oldItems, new ArrayList<RemoteServerRecord>(this.items));
    }

    private Collection<ExecutionEnvironment> clear() {
        ArrayList<ExecutionEnvironment> removed = new ArrayList<ExecutionEnvironment>();
        for (RemoteServerRecord record : this.items) {
            record.setDeleted(true);
            removed.add(record.getExecutionEnvironment());
        }
        RemoteServerList.getPreferences().remove(REMOTE_SERVERS);
        this.unlisted.addAll(this.items);
        this.items.clear();
        return removed;
    }

    private void removeFromPreferences(ServerRecord recordToRemove) {
        StringBuilder sb = new StringBuilder();
        for (RemoteServerRecord record : this.items) {
            if (recordToRemove.equals(record)) continue;
            sb.append(record.getDisplayName());
            sb.append(',');
        }
        RemoteServerList.getPreferences().put(REMOTE_SERVERS, sb.toString());
    }

    private void refresh() {
        this.cs.fireChange();
    }

    public synchronized RemoteServerRecord getLocalhostRecord() {
        return this.items.get(0);
    }

    public boolean isValidExecutable(ExecutionEnvironment env, String path) {
        int exit_status;
        if (path == null || path.length() == 0) {
            return false;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            RemoteUtil.LOGGER.warning("RemoteServerList.isValidExecutable from EDT");
        }
        if ((exit_status = RemoteCommandSupport.run(env, "test", "-x", path)) != 0 && !CndPathUtilitities.isPathAbsolute((String)path)) {
            exit_status = RemoteCommandSupport.run(env, "test", "-x", "`which " + path + "`");
        }
        return exit_status == 0;
    }

    public synchronized Collection<? extends ServerRecord> getRecords() {
        return new ArrayList<RemoteServerRecord>(this.items);
    }

    public void addChangeListener(ChangeListener listener) {
        this.cs.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.cs.removeChangeListener(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    private void firePropertyChange(String property, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(property, oldValue, newValue);
    }

    private static Preferences getPreferences() {
        return NbPreferences.forModule(RemoteServerList.class);
    }

    public ServerRecord createServerRecord(ExecutionEnvironment env, String displayName, RemoteSyncFactory syncFactory) {
        return new RemoteServerRecord(env, displayName, syncFactory, false);
    }
}

