/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.results.ExportDataDumper;
import org.netbeans.lib.profiler.results.monitor.VMTelemetryDataManager;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.graphs.GraphPanel;
import org.netbeans.lib.profiler.ui.graphs.MemoryGraphPanel;
import org.netbeans.lib.profiler.ui.graphs.SurvivingGenerationsGraphPanel;
import org.netbeans.lib.profiler.ui.graphs.ThreadsGraphPanel;
import org.netbeans.lib.profiler.ui.monitor.VMTelemetryModels;
import org.netbeans.modules.profiler.ExportAction;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.SaveViewAction;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public final class TelemetryWindow
extends TopComponent {
    private static final String THREADS_STATISTICS_TAB_NAME = NbBundle.getMessage(TelemetryWindow.class, (String)"TelemetryWindow_ThreadsStatisticsTabName");
    private static final String MEMORY_HEAP_TAB_NAME = NbBundle.getMessage(TelemetryWindow.class, (String)"TelemetryWindow_MemoryHeapTabName");
    private static final String MEMORY_GC_TAB_NAME = NbBundle.getMessage(TelemetryWindow.class, (String)"TelemetryWindow_MemoryGCTabName");
    private static final String THREADS_STATISTICS_TAB_DESCR = NbBundle.getMessage(TelemetryWindow.class, (String)"TelemetryWindow_ThreadsStatisticsTabDescr");
    private static final String MEMORY_HEAP_TAB_DESCR = NbBundle.getMessage(TelemetryWindow.class, (String)"TelemetryWindow_MemoryHeapTabDescr");
    private static final String MEMORY_GC_TAB_DESCR = NbBundle.getMessage(TelemetryWindow.class, (String)"TelemetryWindow_MemoryGCTabDescr");
    private static final String TELEMETRY_ACCESS_DESCR = NbBundle.getMessage(TelemetryWindow.class, (String)"TelemetryWindow_TelemetryAccessDescr");
    private static final String HELP_CTX_KEY = "TelemetryWindow.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("TelemetryWindow.HelpCtx");
    private static TelemetryWindow defaultInstance;
    private static final Image windowIcon;
    private final GraphTab generationsPanel;
    private final GraphTab heapPanel;
    private final GraphTab threadsStatsPanel;
    private final JTabbedPane tabs;
    private final MemoryGraphPanel heapGraph;
    private final SurvivingGenerationsGraphPanel generationsGraph;
    private final ThreadsGraphPanel threadsStatsGraph;
    private Component lastFocusOwner;

    public TelemetryWindow() {
        this.setName(NbBundle.getMessage(TelemetryWindow.class, (String)"LAB_TelemetryWindowName"));
        this.setIcon(windowIcon);
        this.getAccessibleContext().setAccessibleDescription(TELEMETRY_ACCESS_DESCR);
        this.setLayout(new BorderLayout());
        this.tabs = new JTabbedPane();
        this.tabs.setTabPlacement(3);
        this.add(this.tabs, "Center");
        this.heapGraph = MemoryGraphPanel.createBigPanel((VMTelemetryModels)NetBeansProfiler.getDefaultNB().getVMTelemetryModels());
        this.generationsGraph = SurvivingGenerationsGraphPanel.createBigPanel((VMTelemetryModels)NetBeansProfiler.getDefaultNB().getVMTelemetryModels());
        this.threadsStatsGraph = ThreadsGraphPanel.createBigPanel((VMTelemetryModels)NetBeansProfiler.getDefaultNB().getVMTelemetryModels());
        this.heapPanel = new GraphTab((GraphPanel)this.heapGraph);
        this.generationsPanel = new GraphTab((GraphPanel)this.generationsGraph);
        this.threadsStatsPanel = new GraphTab((GraphPanel)this.threadsStatsGraph);
        this.tabs.addTab(MEMORY_HEAP_TAB_NAME, null, this.heapPanel, MEMORY_HEAP_TAB_DESCR);
        this.tabs.addTab(MEMORY_GC_TAB_NAME, null, this.generationsPanel, MEMORY_GC_TAB_DESCR);
        this.tabs.addTab(THREADS_STATISTICS_TAB_NAME, null, this.threadsStatsPanel, THREADS_STATISTICS_TAB_DESCR);
        this.tabs.getActionMap().getParent().remove("navigatePageUp");
        this.tabs.getActionMap().getParent().remove("navigatePageDown");
        this.getActionMap().put("PreviousViewAction", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TelemetryWindow.this.moveToPreviousSubTab();
            }
        });
        this.getActionMap().put("NextViewAction", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TelemetryWindow.this.moveToNextSubTab();
            }
        });
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
    }

    public static TelemetryWindow getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new TelemetryWindow();
        }
        return defaultInstance;
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    public static void closeIfOpened() {
        if (defaultInstance != null) {
            IDEUtils.runInEventDispatchThread(new Runnable(){

                @Override
                public void run() {
                    if (defaultInstance.isOpened()) {
                        defaultInstance.close();
                    }
                }
            });
        }
    }

    public int getPersistenceType() {
        return 2;
    }

    public void componentActivated() {
        if (this.lastFocusOwner != null) {
            this.lastFocusOwner.requestFocus();
        } else if (this.threadsStatsGraph != null) {
            this.threadsStatsGraph.requestFocus();
        }
    }

    public void componentDeactivated() {
        this.lastFocusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
    }

    public void showGC() {
        this.tabs.setSelectedComponent(this.generationsPanel);
        this.open();
        this.requestActive();
    }

    public void showHeap() {
        this.tabs.setSelectedComponent(this.heapPanel);
        this.open();
        this.requestActive();
    }

    public void showThreads() {
        this.tabs.setSelectedComponent(this.threadsStatsPanel);
        this.open();
        this.requestActive();
    }

    protected String preferredID() {
        return ((Object)((Object)this)).getClass().getName();
    }

    private void moveToNextSubTab() {
        this.tabs.setSelectedIndex(UIUtils.getNextSubTabIndex((JTabbedPane)this.tabs, (int)this.tabs.getSelectedIndex()));
    }

    private void moveToPreviousSubTab() {
        this.tabs.setSelectedIndex(UIUtils.getPreviousSubTabIndex((JTabbedPane)this.tabs, (int)this.tabs.getSelectedIndex()));
    }

    static {
        windowIcon = ImageUtilities.loadImage((String)"org/netbeans/modules/profiler/resources/telemetryWindow.png");
    }

    private static final class GraphTab
    extends JPanel
    implements SaveViewAction.ViewProvider,
    ExportAction.ExportProvider {
        private static final String timestamp = "Timestamp";
        private static final String heapSize = "Heap_Size_in_Bytes";
        private static final String usedHeap = "Used_Heap_in_Bytes";
        private static final String survivingGenerations = "Surviving_Generations";
        private static final String timeInGC = "Relative_Time_Spent_in_GC";
        private static final String threadsCount = "Number_of_Threads";
        private static final String loadedClasses = "Loaded_Classes_Count";
        private final GraphPanel panel;
        private final ExportAction exportActionButton;

        public GraphTab(GraphPanel panel) {
            this.panel = panel;
            this.setLayout(new BorderLayout());
            JToolBar toolBar = new JToolBar(){

                @Override
                public Component add(Component comp) {
                    if (comp instanceof JButton) {
                        UIUtils.fixButtonUI((AbstractButton)((JButton)comp));
                    }
                    return super.add(comp);
                }
            };
            this.exportActionButton = new ExportAction(this, null);
            toolBar.setFloatable(false);
            toolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
            toolBar.setBorder(BorderFactory.createEmptyBorder(2, 0, 4, 0));
            toolBar.add(this.exportActionButton);
            toolBar.add(new SaveViewAction(this));
            toolBar.addSeparator();
            for (Action action : panel.getActions()) {
                toolBar.add(action);
            }
            this.add((Component)toolBar, "North");
            this.add((Component)panel, "Center");
        }

        @Override
        public BufferedImage getViewImage(boolean onlyVisibleArea) {
            return UIUtils.createScreenshot((Component)this.panel);
        }

        @Override
        public String getViewName() {
            if (this.panel instanceof MemoryGraphPanel) {
                return "memory-heap";
            }
            if (this.panel instanceof SurvivingGenerationsGraphPanel) {
                return "memory-gc";
            }
            if (this.panel instanceof ThreadsGraphPanel) {
                return "threads-statistics";
            }
            return null;
        }

        @Override
        public boolean fitsVisibleArea() {
            return true;
        }

        @Override
        public boolean hasView() {
            return true;
        }

        private void exportCSVData(String separator, ExportDataDumper eDD) {
            VMTelemetryDataManager data = Profiler.getDefault().getVMTelemetryManager();
            String newLine = "\r\n";
            String quote = "\"";
            int nItems = data.getItemCount();
            long[] col1 = new long[nItems];
            long[] col2 = new long[nItems];
            long[] col3 = new long[nItems];
            String col1Name = timestamp;
            String col2Name = new String();
            String col3Name = new String();
            System.arraycopy(data.timeStamps, 0, col1, 0, nItems);
            if (this.panel instanceof MemoryGraphPanel) {
                System.arraycopy(data.totalMemory, 0, col2, 0, nItems);
                System.arraycopy(data.usedMemory, 0, col3, 0, nItems);
                col2Name = heapSize;
                col3Name = usedHeap;
            } else if (this.panel instanceof SurvivingGenerationsGraphPanel) {
                System.arraycopy(data.nSurvivingGenerations, 0, col2, 0, nItems);
                System.arraycopy(data.relativeGCTimeInPerMil, 0, col3, 0, nItems);
                col2Name = survivingGenerations;
                col3Name = timeInGC;
            } else if (this.panel instanceof ThreadsGraphPanel) {
                System.arraycopy(data.nUserThreads, 0, col2, 0, nItems);
                System.arraycopy(data.loadedClassesCount, 0, col3, 0, nItems);
                col2Name = threadsCount;
                col3Name = loadedClasses;
            }
            eDD.dumpData(new StringBuffer(quote + col1Name + quote + separator + quote + col2Name + quote + separator + quote + col3Name + quote + newLine));
            Date d = new Date();
            for (int i = 0; i < nItems; ++i) {
                d.setTime(col1[i]);
                eDD.dumpData(new StringBuffer(quote + DateFormat.getDateTimeInstance().format(d) + quote + separator + quote + col2[i] + quote + separator + quote + col3[i] + quote + newLine));
            }
            eDD.close();
        }

        private void exportHTMLData(ExportDataDumper eDD) {
            VMTelemetryDataManager data = Profiler.getDefault().getVMTelemetryManager();
            int nItems = data.getItemCount();
            long[] col1 = new long[nItems];
            long[] col2 = new long[nItems];
            long[] col3 = new long[nItems];
            String col1Name = NbBundle.getMessage(TelemetryWindow.class, (String)timestamp);
            String col2Name = new String();
            String col3Name = new String();
            String viewName = new String();
            System.arraycopy(data.timeStamps, 0, col1, 0, nItems);
            if (this.panel instanceof MemoryGraphPanel) {
                System.arraycopy(data.totalMemory, 0, col2, 0, nItems);
                System.arraycopy(data.usedMemory, 0, col3, 0, nItems);
                viewName = MEMORY_HEAP_TAB_NAME;
                col2Name = NbBundle.getMessage(TelemetryWindow.class, (String)heapSize);
                col3Name = NbBundle.getMessage(TelemetryWindow.class, (String)usedHeap);
            } else if (this.panel instanceof SurvivingGenerationsGraphPanel) {
                System.arraycopy(data.nSurvivingGenerations, 0, col2, 0, nItems);
                System.arraycopy(data.relativeGCTimeInPerMil, 0, col3, 0, nItems);
                viewName = MEMORY_GC_TAB_NAME;
                col2Name = NbBundle.getMessage(TelemetryWindow.class, (String)survivingGenerations);
                col3Name = NbBundle.getMessage(TelemetryWindow.class, (String)timeInGC);
            } else if (this.panel instanceof ThreadsGraphPanel) {
                System.arraycopy(data.nUserThreads, 0, col2, 0, nItems);
                System.arraycopy(data.loadedClassesCount, 0, col3, 0, nItems);
                viewName = THREADS_STATISTICS_TAB_NAME;
                col2Name = NbBundle.getMessage(TelemetryWindow.class, (String)threadsCount);
                col3Name = NbBundle.getMessage(TelemetryWindow.class, (String)loadedClasses);
            }
            StringBuffer result = new StringBuffer("<HTML><HEAD><meta http-equiv=\"Content-type\" content=\"text/html; charset=utf-8\" /><TITLE>" + viewName + "</TITLE></HEAD><BODY><table border=\"1\"><tr>");
            result.append("<th>" + col1Name + "</th><th>" + col2Name + "</th><th>" + col3Name + "</th></tr>");
            eDD.dumpData(result);
            Date d = new Date();
            for (int i = 0; i < nItems; ++i) {
                d.setTime(col1[i]);
                eDD.dumpData(new StringBuffer("<tr><td>" + DateFormat.getDateTimeInstance().format(d) + "</td><td align=right>" + col2[i] + "</td><td align=right>" + col3[i] + "</td></tr>"));
            }
            eDD.dumpDataAndClose(new StringBuffer("</table></BODY></HTML>"));
        }

        private void exportXMLData(ExportDataDumper eDD) {
            VMTelemetryDataManager data = Profiler.getDefault().getVMTelemetryManager();
            int nItems = data.getItemCount();
            long[] col1 = new long[nItems];
            long[] col2 = new long[nItems];
            long[] col3 = new long[nItems];
            String col1Name = NbBundle.getMessage(TelemetryWindow.class, (String)timestamp);
            String col2Name = new String();
            String col3Name = new String();
            String viewName = new String();
            System.arraycopy(data.timeStamps, 0, col1, 0, nItems);
            if (this.panel instanceof MemoryGraphPanel) {
                System.arraycopy(data.totalMemory, 0, col2, 0, nItems);
                System.arraycopy(data.usedMemory, 0, col3, 0, nItems);
                viewName = MEMORY_HEAP_TAB_NAME;
                col2Name = heapSize;
                col3Name = usedHeap;
            } else if (this.panel instanceof SurvivingGenerationsGraphPanel) {
                System.arraycopy(data.nSurvivingGenerations, 0, col2, 0, nItems);
                System.arraycopy(data.relativeGCTimeInPerMil, 0, col3, 0, nItems);
                viewName = MEMORY_GC_TAB_NAME;
                col2Name = survivingGenerations;
                col3Name = timeInGC;
            } else if (this.panel instanceof ThreadsGraphPanel) {
                System.arraycopy(data.nUserThreads, 0, col2, 0, nItems);
                System.arraycopy(data.loadedClassesCount, 0, col3, 0, nItems);
                viewName = THREADS_STATISTICS_TAB_NAME;
                col2Name = threadsCount;
                col3Name = loadedClasses;
            }
            String newline = System.getProperty("line.separator");
            StringBuffer result = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + newline + "<ExportedView Name=\"" + viewName + "\">" + newline);
            result.append("<TableData NumRows=\"" + nItems + "\" NumColumns=\"3\">" + newline + " <TableHeader>");
            result.append(" <TableColumn>" + col1Name + " </TableColumn>" + newline + " <TableColumn>" + col2Name + " </TableColumn>" + newline + " <TableColumn>" + col3Name + " </TableColumn>" + newline);
            result.append(" </TableHeader>" + newline + " <TableBody>" + newline);
            eDD.dumpData(result);
            Date d = new Date();
            for (int i = 0; i < nItems; ++i) {
                d.setTime(col1[i]);
                result = new StringBuffer("  <TableRow>" + newline + "   <TableCell>" + DateFormat.getDateTimeInstance().format(d) + "</TableCell>" + newline);
                result.append("   <TableCell>" + col2[i] + "</TableCell>" + newline);
                result.append("   <TableCell>" + col3[i] + "</TableCell>" + newline + "  </TableRow>" + newline);
                eDD.dumpData(result);
            }
            eDD.dumpDataAndClose(new StringBuffer(" </TableBody>" + newline + "</TableData>" + newline + "</ExportedView>"));
        }

        @Override
        public void exportData(int exportedFileType, ExportDataDumper eDD) {
            if (this.panel instanceof MemoryGraphPanel || this.panel instanceof SurvivingGenerationsGraphPanel || this.panel instanceof ThreadsGraphPanel) {
                switch (exportedFileType) {
                    case 1: {
                        this.exportCSVData(",", eDD);
                        break;
                    }
                    case 2: {
                        this.exportCSVData(";", eDD);
                        break;
                    }
                    case 3: {
                        this.exportXMLData(eDD);
                        break;
                    }
                    case 4: {
                        this.exportHTMLData(eDD);
                    }
                }
            }
        }

        @Override
        public boolean hasExportableView() {
            return Profiler.getDefault().getVMTelemetryManager().getItemCount() > 0;
        }

        @Override
        public boolean hasLoadedSnapshot() {
            return false;
        }
    }
}

