/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.repository;

import java.awt.EventQueue;
import java.awt.Image;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;
import org.netbeans.modules.bugtracking.kenai.spi.KenaiUtil;
import org.netbeans.modules.bugtracking.kenai.spi.OwnerInfo;
import org.netbeans.modules.bugtracking.spi.BugtrackingController;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.Query;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.spi.RepositoryUser;
import org.netbeans.modules.bugtracking.ui.issue.cache.IssueCache;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.bugtracking.util.MylynUtils;
import org.netbeans.modules.bugzilla.Bugzilla;
import org.netbeans.modules.bugzilla.BugzillaConfig;
import org.netbeans.modules.bugzilla.commands.BugzillaExecutor;
import org.netbeans.modules.bugzilla.commands.GetMultiTaskDataCommand;
import org.netbeans.modules.bugzilla.commands.PerformQueryCommand;
import org.netbeans.modules.bugzilla.issue.BugzillaIssue;
import org.netbeans.modules.bugzilla.issue.BugzillaIssueProvider;
import org.netbeans.modules.bugzilla.query.BugzillaQuery;
import org.netbeans.modules.bugzilla.query.QueryController;
import org.netbeans.modules.bugzilla.query.QueryParameter;
import org.netbeans.modules.bugzilla.repository.BugzillaConfiguration;
import org.netbeans.modules.bugzilla.repository.RepositoryController;
import org.netbeans.modules.bugzilla.util.BugzillaUtil;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public class BugzillaRepository
extends Repository {
    private static final String ICON_PATH = "org/netbeans/modules/bugtracking/ui/resources/repository.png";
    private String name;
    private TaskRepository taskRepository;
    private RepositoryController controller;
    private Set<Query> queries = null;
    private IssueCache<TaskData> cache;
    private BugzillaExecutor executor;
    private Image icon;
    private BugzillaConfiguration bc;
    private RequestProcessor refreshProcessor;
    private final Set<String> issuesToRefresh = new HashSet<String>(5);
    private final Set<BugzillaQuery> queriesToRefresh = new HashSet<BugzillaQuery>(3);
    private RequestProcessor.Task refreshIssuesTask;
    private RequestProcessor.Task refreshQueryTask;
    private String id;
    public static final String ATTRIBUTE_URL = "bugzilla.repository.attribute.url";
    public static final String ATTRIBUTE_DISPLAY_NAME = "bugzilla.repository.attribute.displayName";
    private Lookup lookup;

    public BugzillaRepository() {
        this.icon = ImageUtilities.loadImage((String)ICON_PATH, (boolean)true);
    }

    public BugzillaRepository(String id, String repoName, String url, String user, String password, String httpUser, String httpPassword) {
        this(id, repoName, url, user, password, httpUser, httpPassword, false);
    }

    public BugzillaRepository(String id, String repoName, String url, String user, String password, String httpUser, String httpPassword, boolean shortLoginEnabled) {
        this();
        this.id = id;
        this.name = repoName;
        if (user == null) {
            user = "";
        }
        if (password == null) {
            password = "";
        }
        this.taskRepository = BugzillaRepository.createTaskRepository(this.name, url, user, password, httpUser, httpPassword, shortLoginEnabled);
    }

    public String getID() {
        if (this.id == null) {
            this.id = this.name + System.currentTimeMillis();
        }
        return this.id;
    }

    public TaskRepository getTaskRepository() {
        return this.taskRepository;
    }

    public Query createQuery() {
        BugzillaConfiguration conf = this.getConfiguration();
        if (conf == null || !conf.isValid()) {
            return null;
        }
        BugzillaQuery q = new BugzillaQuery(this);
        return q;
    }

    public Issue createIssue() {
        BugzillaConfiguration conf = this.getConfiguration();
        if (conf == null || !conf.isValid()) {
            return null;
        }
        TaskAttributeMapper attributeMapper = Bugzilla.getInstance().getRepositoryConnector().getTaskDataHandler().getAttributeMapper(this.taskRepository);
        TaskData data = new TaskData(attributeMapper, this.taskRepository.getConnectorKind(), this.taskRepository.getRepositoryUrl(), "");
        return new BugzillaIssue(data, this);
    }

    public void remove() {
        Query[] qs;
        for (Query q : qs = this.getQueries()) {
            this.removeQuery((BugzillaQuery)q);
        }
        Bugzilla.getInstance().removeRepository(this);
        this.resetRepository(true);
    }

    public Lookup getLookup() {
        if (this.lookup == null) {
            this.lookup = Lookups.fixed((Object[])this.getLookupObjects());
        }
        return this.lookup;
    }

    protected Object[] getLookupObjects() {
        return new Object[]{this.getIssueCache()};
    }

    synchronized void resetRepository(boolean keepConfiguration) {
        if (!keepConfiguration) {
            this.bc = null;
        }
        if (this.getTaskRepository() != null) {
            Bugzilla.getInstance().getRepositoryConnector().getClientManager().repositoryRemoved(this.getTaskRepository());
        }
    }

    void setName(String name) {
        this.name = name;
    }

    public void fireQueryListChanged() {
        super.fireQueryListChanged();
    }

    protected void fireAttributesChanged(Map<String, Object> oldAttributes, Map<String, Object> newAttributes) {
        LinkedList<String> equalAttributes = new LinkedList<String>();
        for (Map.Entry<String, Object> e : newAttributes.entrySet()) {
            String key = e.getKey();
            Object value = e.getValue();
            Object oldValue = oldAttributes.get(key);
            if ((value != null || oldValue != null) && (value == null || !value.equals(oldValue))) continue;
            equalAttributes.add(key);
        }
        for (String equalAttribute : equalAttributes) {
            if (oldAttributes != null) {
                oldAttributes.remove(equalAttribute);
            }
            newAttributes.remove(equalAttribute);
        }
        if (!newAttributes.isEmpty()) {
            super.fireAttributesChanged(oldAttributes, newAttributes);
        }
    }

    public String getDisplayName() {
        return this.name;
    }

    public String getTooltip() {
        return this.name + " : " + this.taskRepository.getCredentials(AuthenticationType.REPOSITORY).getUserName() + "@" + this.taskRepository.getUrl();
    }

    public Image getIcon() {
        return this.icon;
    }

    public String getUsername() {
        AuthenticationCredentials c = this.getTaskRepository().getCredentials(AuthenticationType.REPOSITORY);
        return c != null ? c.getUserName() : "";
    }

    public String getPassword() {
        AuthenticationCredentials c = this.getTaskRepository().getCredentials(AuthenticationType.REPOSITORY);
        return c != null ? c.getPassword() : "";
    }

    public String getHttpUsername() {
        AuthenticationCredentials c = this.getTaskRepository().getCredentials(AuthenticationType.HTTP);
        return c != null ? c.getUserName() : "";
    }

    public String getHttpPassword() {
        AuthenticationCredentials c = this.getTaskRepository().getCredentials(AuthenticationType.HTTP);
        return c != null ? c.getPassword() : "";
    }

    public Issue getIssue(String id) {
        assert (!SwingUtilities.isEventDispatchThread()) : "Accessing remote host. Do not call in awt";
        TaskData taskData = BugzillaUtil.getTaskData(this, id);
        if (taskData == null) {
            return null;
        }
        try {
            return this.getIssueCache().setIssueData(id, (Object)taskData);
        }
        catch (IOException ex) {
            Bugzilla.LOG.log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public Issue[] simpleSearch(String criteria) {
        QueryParameter[] additionalParams;
        TaskData taskData;
        assert (this.taskRepository != null);
        assert (!SwingUtilities.isEventDispatchThread()) : "Accessing remote host. Do not call in awt";
        String[] keywords = criteria.split(" ");
        final ArrayList<BugzillaIssue> issues = new ArrayList<BugzillaIssue>();
        TaskDataCollector collector = new TaskDataCollector(){

            public void accept(TaskData taskData) {
                BugzillaIssue issue = new BugzillaIssue(taskData, BugzillaRepository.this);
                issues.add(issue);
            }
        };
        if (keywords.length == 1 && this.isInteger(keywords[0]) && (taskData = BugzillaUtil.getTaskData(this, keywords[0], false)) != null) {
            BugzillaIssue issue = new BugzillaIssue(taskData, this);
            issues.add(issue);
        }
        StringBuffer url = new StringBuffer();
        url.append("/buglist.cgi?query_format=advanced&short_desc_type=allwordssubstr&short_desc=");
        for (int i = 0; i < keywords.length; ++i) {
            String val = keywords[i].trim();
            if (val.equals("")) continue;
            try {
                val = URLEncoder.encode(val, this.getTaskRepository().getCharacterEncoding());
            }
            catch (UnsupportedEncodingException ueex) {
                Bugzilla.LOG.log(Level.INFO, null, ueex);
                try {
                    val = URLEncoder.encode(val, "UTF-8");
                }
                catch (UnsupportedEncodingException ex) {
                    // empty catch block
                }
            }
            url.append(val);
            if (i >= keywords.length - 1) continue;
            url.append("+");
        }
        for (QueryParameter qp : additionalParams = this.getSimpleSearchParameters()) {
            url.append(qp.get());
        }
        PerformQueryCommand queryCmd = new PerformQueryCommand(this, url.toString(), collector);
        this.getExecutor().execute(queryCmd);
        if (queryCmd.hasFailed()) {
            return new Issue[0];
        }
        return issues.toArray(new BugzillaIssue[issues.size()]);
    }

    public BugtrackingController getController() {
        if (this.controller == null) {
            this.controller = new RepositoryController(this);
        }
        return this.controller;
    }

    public Query[] getQueries() {
        Set<Query> l = this.getQueriesIntern();
        return l.toArray(new Query[l.size()]);
    }

    public IssueCache<TaskData> getIssueCache() {
        if (this.cache == null) {
            this.cache = new Cache();
        }
        return this.cache;
    }

    public void removeQuery(BugzillaQuery query) {
        BugzillaConfig.getInstance().removeQuery(this, query);
        this.getIssueCache().removeQuery(query.getStoredQueryName());
        this.getQueriesIntern().remove((Object)query);
        this.stopRefreshing(query);
    }

    public void saveQuery(BugzillaQuery query) {
        assert (this.id != null);
        BugzillaConfig.getInstance().putQuery(this, query);
        this.getQueriesIntern().add(query);
    }

    private Set<Query> getQueriesIntern() {
        if (this.queries == null) {
            String[] qs;
            this.queries = new HashSet<Query>(10);
            for (String queryName : qs = BugzillaConfig.getInstance().getQueries(this.id)) {
                BugzillaQuery q = BugzillaConfig.getInstance().getQuery(this, queryName);
                if (q != null) {
                    this.queries.add(q);
                    continue;
                }
                Bugzilla.LOG.warning("Couldn't find query with stored name " + queryName);
            }
        }
        return this.queries;
    }

    public void setCredentials(String user, String password, String httpUser, String httpPassword) {
        MylynUtils.setCredentials((TaskRepository)this.taskRepository, (String)user, (String)password, (String)httpUser, (String)httpPassword);
        this.resetRepository(false);
    }

    protected void setTaskRepository(String name, String url, String user, String password, String httpUser, String httpPassword, boolean shortLoginEnabled) {
        HashMap<String, Object> oldAttributes = this.createAttributesMap();
        String oldUrl = this.taskRepository != null ? this.taskRepository.getUrl() : "";
        AuthenticationCredentials c = this.taskRepository != null ? this.taskRepository.getCredentials(AuthenticationType.REPOSITORY) : null;
        String oldUser = c != null ? c.getUserName() : "";
        String oldPassword = c != null ? c.getPassword() : "";
        this.taskRepository = BugzillaRepository.createTaskRepository(name, url, user, password, httpUser, httpPassword, shortLoginEnabled);
        Bugzilla.getInstance().addRepository(this);
        this.resetRepository(oldUrl.equals(url) && oldUser.equals(user) && oldPassword.equals(password));
        HashMap<String, Object> newAttributes = this.createAttributesMap();
        this.fireAttributesChanged(oldAttributes, newAttributes);
    }

    static TaskRepository createTaskRepository(String name, String url, String user, String password, String httpUser, String httpPassword, boolean shortLoginEnabled) {
        TaskRepository repository = MylynUtils.createTaskRepository((String)Bugzilla.getInstance().getRepositoryConnector().getConnectorKind(), (String)name, (String)url, (String)user, (String)password, (String)httpUser, (String)httpPassword);
        repository.setProperty("bugzilla.shortLoginEnabled", shortLoginEnabled ? "true" : "false");
        return repository;
    }

    public String getUrl() {
        return this.taskRepository != null ? this.taskRepository.getUrl() : null;
    }

    private boolean isInteger(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public BugzillaExecutor getExecutor() {
        if (this.executor == null) {
            this.executor = new BugzillaExecutor(this);
        }
        return this.executor;
    }

    public boolean authenticate(String errroMsg) {
        return BugtrackingUtil.editRepository((Repository)this, (String)errroMsg);
    }

    public boolean isShortUsernamesEnabled() {
        return this.taskRepository != null && "true".equals(this.taskRepository.getProperty("bugzilla.shortLoginEnabled"));
    }

    public Collection<RepositoryUser> getUsers() {
        return Collections.emptyList();
    }

    public OwnerInfo getOwnerInfo(Node[] nodes) {
        OwnerInfo ownerInfo;
        if (nodes == null || nodes.length == 0) {
            return null;
        }
        if (BugzillaUtil.isNbRepository(this) && nodes != null && nodes.length > 0 && (ownerInfo = KenaiUtil.getOwnerInfo((Node)nodes[0])) != null) {
            return ownerInfo;
        }
        return null;
    }

    public synchronized BugzillaConfiguration getConfiguration() {
        if (this.bc == null) {
            this.bc = this.createConfiguration(false);
        }
        return this.bc;
    }

    public synchronized void refreshConfiguration() {
        BugzillaConfiguration conf;
        this.bc = conf = this.createConfiguration(true);
    }

    protected BugzillaConfiguration createConfiguration(boolean forceRefresh) {
        BugzillaConfiguration conf = new BugzillaConfiguration();
        conf.initialize(this, forceRefresh);
        return conf;
    }

    private void setupIssueRefreshTask() {
        if (this.refreshIssuesTask == null) {
            this.refreshIssuesTask = this.getRefreshProcessor().create(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    HashSet<String> ids;
                    Set set = BugzillaRepository.this.issuesToRefresh;
                    synchronized (set) {
                        ids = new HashSet<String>(BugzillaRepository.this.issuesToRefresh);
                    }
                    if (ids.size() == 0) {
                        Bugzilla.LOG.log(Level.FINE, "no issues to refresh {0}", new Object[]{BugzillaRepository.this.name});
                        return;
                    }
                    Bugzilla.LOG.log(Level.FINER, "preparing to refresh issue {0} - {1}", new Object[]{BugzillaRepository.this.name, ids});
                    GetMultiTaskDataCommand cmd = new GetMultiTaskDataCommand(BugzillaRepository.this, ids, new IssuesCollector());
                    BugzillaRepository.this.getExecutor().execute(cmd, false);
                    BugzillaRepository.this.scheduleIssueRefresh();
                }
            });
            this.scheduleIssueRefresh();
        }
    }

    private void setupQueryRefreshTask() {
        if (this.refreshQueryTask == null) {
            this.refreshQueryTask = this.getRefreshProcessor().create(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        HashSet queries;
                        RequestProcessor.Task task = BugzillaRepository.this.refreshQueryTask;
                        synchronized (task) {
                            queries = new HashSet(BugzillaRepository.this.queriesToRefresh);
                        }
                        if (queries.size() == 0) {
                            Bugzilla.LOG.log(Level.FINE, "no queries to refresh {0}", new Object[]{BugzillaRepository.this.name});
                            return;
                        }
                        for (BugzillaQuery q : queries) {
                            Bugzilla.LOG.log(Level.FINER, "preparing to refresh query {0} - {1}", new Object[]{q.getDisplayName(), BugzillaRepository.this.name});
                            QueryController qc = q.getController();
                            qc.autoRefresh();
                        }
                    }
                    finally {
                        BugzillaRepository.this.scheduleQueryRefresh();
                    }
                }
            });
            this.scheduleQueryRefresh();
        }
    }

    private void scheduleIssueRefresh() {
        int delay = BugzillaConfig.getInstance().getIssueRefreshInterval();
        Bugzilla.LOG.log(Level.FINE, "scheduling issue refresh for repository {0} in {1} minute(s)", new Object[]{this.name, delay});
        if (delay < 5 && System.getProperty("netbeans.t9y.bugzilla.force.refresh.delay") == null) {
            Bugzilla.LOG.log(Level.WARNING, " wrong issue refresh delay {0}. Falling back to default {0}", new Object[]{delay, 15});
            delay = 15;
        }
        this.refreshIssuesTask.schedule(delay * 60 * 1000);
    }

    private void scheduleQueryRefresh() {
        int delay = BugzillaConfig.getInstance().getQueryRefreshInterval();
        Bugzilla.LOG.log(Level.FINE, "scheduling query refresh for repository {0} in {1} minute(s)", new Object[]{this.name, delay});
        if (delay < 5 && System.getProperty("netbeans.t9y.bugzilla.force.refresh.delay") == null) {
            Bugzilla.LOG.log(Level.WARNING, " wrong query refresh delay {0}. Falling back to default {0}", new Object[]{delay, 30});
            delay = 30;
        }
        this.refreshQueryTask.schedule(delay * 60 * 1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleForRefresh(String id) {
        Bugzilla.LOG.log(Level.FINE, "scheduling issue {0} for refresh on repository {0}", new Object[]{id, this.name});
        Set<String> set = this.issuesToRefresh;
        synchronized (set) {
            this.issuesToRefresh.add(id);
        }
        this.setupIssueRefreshTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRefreshing(String id) {
        Bugzilla.LOG.log(Level.FINE, "removing issue {0} from refresh on repository {1}", new Object[]{id, this.name});
        Set<String> set = this.issuesToRefresh;
        synchronized (set) {
            this.issuesToRefresh.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleForRefresh(BugzillaQuery query) {
        Bugzilla.LOG.log(Level.FINE, "scheduling query {0} for refresh on repository {1}", new Object[]{query.getDisplayName(), this.name});
        Set<BugzillaQuery> set = this.queriesToRefresh;
        synchronized (set) {
            this.queriesToRefresh.add(query);
        }
        this.setupQueryRefreshTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRefreshing(BugzillaQuery query) {
        Bugzilla.LOG.log(Level.FINE, "removing query {0} from refresh on repository {1}", new Object[]{query.getDisplayName(), this.name});
        Set<BugzillaQuery> set = this.queriesToRefresh;
        synchronized (set) {
            this.queriesToRefresh.remove((Object)query);
        }
    }

    public void refreshAllQueries() {
        this.refreshAllQueries(true);
    }

    protected void refreshAllQueries(final boolean onlyOpened) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Query[] qs;
                for (Query q : qs = BugzillaRepository.this.getQueries()) {
                    if (!onlyOpened || !BugtrackingUtil.isOpened((Query)q)) continue;
                    Bugzilla.LOG.log(Level.FINER, "preparing to refresh query {0} - {1}", new Object[]{q.getDisplayName(), BugzillaRepository.this.name});
                    QueryController qc = ((BugzillaQuery)q).getController();
                    qc.onRefresh();
                }
            }
        });
    }

    private RequestProcessor getRefreshProcessor() {
        if (this.refreshProcessor == null) {
            this.refreshProcessor = new RequestProcessor("Bugzilla refresh - " + this.name);
        }
        return this.refreshProcessor;
    }

    public String toString() {
        return super.toString() + " (" + this.getDisplayName() + ')';
    }

    protected QueryParameter[] getSimpleSearchParameters() {
        return new QueryParameter[0];
    }

    private HashMap<String, Object> createAttributesMap() {
        HashMap<String, Object> attributes = new HashMap<String, Object>(2);
        attributes.put(ATTRIBUTE_DISPLAY_NAME, this.getDisplayName());
        attributes.put(ATTRIBUTE_URL, this.getUrl());
        return attributes;
    }

    private class IssueAccessorImpl
    implements IssueCache.IssueAccessor<TaskData> {
        private IssueAccessorImpl() {
        }

        public Issue createIssue(TaskData taskData) {
            BugzillaIssue issue = new BugzillaIssue(taskData, BugzillaRepository.this);
            BugzillaIssueProvider.getInstance().notifyIssueCreated(issue);
            return issue;
        }

        public void setIssueData(Issue issue, TaskData taskData) {
            assert (issue != null && taskData != null);
            ((BugzillaIssue)issue).setTaskData(taskData);
        }

        public String getRecentChanges(Issue issue) {
            assert (issue != null);
            return ((BugzillaIssue)issue).getRecentChanges();
        }

        public long getLastModified(Issue issue) {
            assert (issue != null);
            return ((BugzillaIssue)issue).getLastModify();
        }

        public long getCreated(Issue issue) {
            assert (issue != null);
            return ((BugzillaIssue)issue).getCreated();
        }

        public String getID(TaskData issueData) {
            assert (issueData != null);
            return BugzillaIssue.getID(issueData);
        }

        public Map<String, String> getAttributes(Issue issue) {
            assert (issue != null);
            return ((BugzillaIssue)issue).getAttributes();
        }
    }

    private class Cache
    extends IssueCache<TaskData> {
        Cache() {
            super(BugzillaRepository.this.getUrl(), (IssueCache.IssueAccessor)new IssueAccessorImpl());
        }
    }

    private class IssuesCollector
    extends TaskDataCollector {
        private IssuesCollector() {
        }

        public void accept(TaskData taskData) {
            String id = BugzillaIssue.getID(taskData);
            Bugzilla.LOG.log(Level.FINE, "refreshed issue {0} - {1}", new Object[]{BugzillaRepository.this.name, id});
            try {
                BugzillaRepository.this.getIssueCache().setIssueData(id, (Object)taskData);
            }
            catch (IOException ex) {
                Bugzilla.LOG.log(Level.SEVERE, null, ex);
                return;
            }
        }
    }
}

