/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.terminal.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.dlight.terminal.ui.TerminalContainerTopComponent;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.NativeProcessChangeEvent;
import org.netbeans.modules.nativeexecution.api.execution.NativeExecutionDescriptor;
import org.netbeans.modules.nativeexecution.api.execution.NativeExecutionService;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.terminal.api.IONotifier;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.windows.IOContainer;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

abstract class TerminalAction
implements ActionListener {
    private static final RequestProcessor RP = new RequestProcessor("Terminal Action RP", 100);
    private static Action[] actions;

    TerminalAction() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final TerminalContainerTopComponent instance = TerminalContainerTopComponent.findInstance();
        instance.open();
        instance.requestActive();
        final IOContainer ioContainer = instance.getIOContainer();
        final IOProvider term = IOProvider.get((String)"Terminal");
        if (term != null) {
            final ExecutionEnvironment env = this.getEnvironment();
            final AtomicBoolean destroyed = new AtomicBoolean(false);
            if (env != null) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        if (SwingUtilities.isEventDispatchThread()) {
                            instance.requestActive();
                        } else {
                            this.doWork();
                        }
                    }

                    private void doWork() {
                        if (!ConnectionManager.getInstance().isConnectedTo(env)) {
                            try {
                                ConnectionManager.getInstance().connectTo(env);
                            }
                            catch (IOException ex) {
                                if (!destroyed.get()) {
                                    String error = ex.getCause() == null ? ex.getMessage() : ex.getCause().getMessage();
                                    String msg = NbBundle.getMessage(TerminalAction.class, (String)"TerminalAction.FailedToStart.text", (Object)error);
                                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 0));
                                }
                                return;
                            }
                            catch (CancellationException ex) {
                                return;
                            }
                        }
                        InputOutput io = null;
                        try {
                            io = term.getIO(env.getDisplayName(), null, ioContainer);
                            NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)env);
                            npb.addNativeProcessListener((ChangeListener)new NativeProcessListener(io, destroyed));
                            HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)env);
                            String shell = hostInfo.getShell();
                            npb.setExecutable(shell);
                            NativeExecutionDescriptor descr = new NativeExecutionDescriptor().controllable(true).frontWindow(true).inputVisible(false).inputOutput(io);
                            NativeExecutionService es = NativeExecutionService.newService((NativeProcessBuilder)npb, (NativeExecutionDescriptor)descr, (String)"Terminal Emulator");
                            Future result = es.run();
                            SwingUtilities.invokeLater(this);
                            try {
                                result.get();
                            }
                            catch (InterruptedException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                            catch (ExecutionException ex) {
                                if (!destroyed.get()) {
                                    String error = ex.getCause() == null ? ex.getMessage() : ex.getCause().getMessage();
                                    String msg = NbBundle.getMessage(TerminalAction.class, (String)"TerminalAction.FailedToStart.text", (Object)error);
                                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 0));
                                }
                            }
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                            this.reportInIO(io, ex);
                        }
                        catch (CancellationException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                            this.reportInIO(io, ex);
                        }
                    }

                    private void reportInIO(InputOutput io, Exception ex) {
                        if (io != null && ex != null) {
                            io.getErr().print(ex.getLocalizedMessage());
                        }
                    }
                };
                RP.post(runnable);
            }
        }
    }

    protected abstract ExecutionEnvironment getEnvironment();

    private static synchronized Action[] getActions() {
        if (actions == null) {
            List termActions = Utilities.actionsForPath((String)"Actions/Terminal");
            actions = termActions.toArray(new Action[termActions.size()]);
        }
        return actions;
    }

    private static final class NativeProcessListener
    implements ChangeListener,
    PropertyChangeListener {
        private final InputOutput io;
        private NativeProcess process;
        private final AtomicBoolean destroyed;

        public NativeProcessListener(InputOutput io, AtomicBoolean destroyed) {
            this.io = io;
            assert (destroyed != null);
            this.destroyed = destroyed;
            IONotifier.addPropertyChangeListener((InputOutput)io, (PropertyChangeListener)WeakListeners.propertyChange((PropertyChangeListener)this, (Object)io));
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (e instanceof NativeProcessChangeEvent) {
                NativeProcessChangeEvent npce = (NativeProcessChangeEvent)e;
                System.err.printf("%s:%d[%s]\n", npce.getSource(), npce.pid, npce.state);
                this.initProcess(npce);
                if (this.destroyed.get()) {
                    return;
                }
                switch (npce.state) {
                    case RUNNING: {
                        break;
                    }
                    case CANCELLED: 
                    case FINISHED: {
                        this.io.closeInputOutput();
                        break;
                    }
                    case ERROR: {
                        this.io.getErr().close();
                        this.io.getOut().close();
                    }
                }
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            NativeProcess proc;
            if ("IOVisibility.PROP_VISIBILITY".equals(evt.getPropertyName()) && Boolean.FALSE.equals(evt.getNewValue()) && this.destroyed.compareAndSet(false, true) && (proc = this.process) != null) {
                proc.destroy();
            }
        }

        private void initProcess(NativeProcessChangeEvent npce) {
            if (this.process == null) {
                this.process = (NativeProcess)npce.getSource();
            }
        }
    }
}

