/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers.threadmap;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import org.netbeans.modules.dlight.api.datafilter.support.TimeIntervalDataFilter;
import org.netbeans.modules.dlight.core.stack.api.ThreadState;
import org.netbeans.modules.dlight.util.Range;
import org.netbeans.modules.dlight.visualizers.api.ThreadStateResources;
import org.netbeans.modules.dlight.visualizers.threadmap.OrderedEnumStateIterator;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadStateColumnImpl;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadStateHeaderRenderer;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadsPanel;
import org.netbeans.modules.dlight.visualizers.threadmap.TimeLine;
import org.netbeans.modules.dlight.visualizers.threadmap.TimeLineUtils;
import org.netbeans.modules.dlight.visualizers.threadmap.UIUtils;
import org.openide.util.NbBundle;

public class ThreadStateCellRenderer
extends JPanel
implements TableCellRenderer,
Serializable {
    private Color unselectedBackground;
    private Color unselectedForeground;
    private ThreadStateColumnImpl threadData;
    private ThreadsPanel viewManager;
    private long dataEnd;
    private long dataStart;
    private long viewEnd;
    private long viewStart;
    private TimeLine timeLine;
    private Collection<TimeIntervalDataFilter> timeFilters;
    private EnumMap<ThreadState.MSAState, AtomicInteger> map = new EnumMap(ThreadState.MSAState.class);
    private JTable table;
    private boolean isShiftCounted;
    private float BorderDarkerFactor = 0.9f;
    private float AlphaCompositeConstant = 0.5f;
    private Color TIME_SELECTION_BORDER = new Color(255, 150, 150);

    public ThreadStateCellRenderer(ThreadsPanel viewManager) {
        this.viewManager = viewManager;
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        this.unselectedBackground = UIUtils.getProfilerResultsBackground();
    }

    @Override
    public void setForeground(Color c) {
        super.setForeground(c);
        this.unselectedForeground = c;
    }

    @Override
    public boolean isOpaque() {
        Color back = this.getBackground();
        Container p = this.getParent();
        if (p != null) {
            p = p.getParent();
        }
        boolean colorMatch = back != null && p != null && back.equals(p.getBackground()) && p.isOpaque();
        return !colorMatch && super.isOpaque();
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            super.setForeground(table.isFocusOwner() ? table.getSelectionForeground() : UIUtils.getUnfocusedSelectionForeground());
            super.setBackground(table.isFocusOwner() ? table.getSelectionBackground() : UIUtils.getUnfocusedSelectionBackground());
        } else if ((row & 1) == 0) {
            super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : table.getForeground());
            super.setBackground(UIUtils.getDarker(this.unselectedBackground != null ? this.unselectedBackground : table.getBackground()));
        } else {
            super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : table.getForeground());
            super.setBackground(this.unselectedBackground != null ? this.unselectedBackground : table.getBackground());
        }
        if (value instanceof ThreadStateColumnImpl) {
            this.threadData = (ThreadStateColumnImpl)value;
        }
        this.viewStart = this.viewManager.getViewStart();
        this.viewEnd = this.viewManager.getViewEnd();
        this.dataStart = this.viewManager.getDataStart();
        this.dataEnd = this.viewManager.getDataEnd();
        this.timeLine = this.viewManager.getTimeLine();
        this.timeFilters = this.viewManager.getTimeIntervalSelection();
        this.table = table;
        return this;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        String tip = this.getToolTipText(event.getPoint());
        if (tip != null) {
            return tip;
        }
        return super.getToolTipText(event);
    }

    public String getToolTipText(Point point) {
        int index = this.getStateIndex(point);
        if (index >= 0) {
            ThreadState state = this.threadData.getThreadStateAt(index);
            long ms = ThreadStateColumnImpl.timeStampToMilliSeconds(state.getTimeStamp()) - this.dataStart;
            StringBuilder buf = new StringBuilder();
            buf.append("<html>");
            buf.append(NbBundle.getMessage(ThreadStateCellRenderer.class, (String)"StateColumnTimeTip", (Object)TimeLineUtils.getMillisValue(ms)));
            EnumMap<ThreadState.MSAState, AtomicInteger> aMap = new EnumMap<ThreadState.MSAState, AtomicInteger>(ThreadState.MSAState.class);
            ThreadStateColumnImpl.fillMap(this.viewManager, state, aMap);
            ThreadStateColumnImpl.roundMap(aMap);
            buf.append("<table>");
            OrderedEnumStateIterator it = new OrderedEnumStateIterator(aMap);
            while (it.hasNext()) {
                Object entry = it.next();
                int value = ((AtomicInteger)entry.getValue()).get();
                ThreadState.MSAState s = (ThreadState.MSAState)entry.getKey();
                ThreadStateResources res = ThreadStateResources.forState(s);
                if (res == null) continue;
                buf.append("<tr>");
                buf.append("<td>");
                buf.append("<font bgcolor=\"#");
                buf.append(ThreadStateCellRenderer.colorToHexString(res.color));
                buf.append("\">&nbsp;&nbsp;");
                buf.append("</font></td>");
                buf.append("<td>");
                buf.append(res.name);
                buf.append("</td>");
                buf.append("<td>");
                buf.append("" + value + "%");
                buf.append("</td>");
                buf.append("</tr>");
            }
            buf.append("</table>");
            buf.append("</html>");
            return buf.toString();
        }
        return null;
    }

    private int getStateIndex(Point point) {
        int index;
        if (this.threadData != null && (index = this.getFirstVisibleDataUnit()) != -1) {
            int width = Math.abs(this.getX());
            if (this.viewEnd - this.viewStart > 0L) {
                float factor = (float)width / (float)(this.viewEnd - this.viewStart);
                while (index < this.threadData.size() && ThreadStateColumnImpl.timeStampToMilliSeconds(this.threadData.getThreadStateAt(index).getTimeStamp()) <= this.viewEnd) {
                    if (this.threadData.isAlive(index)) {
                        int xx;
                        ThreadState threadStateAt = this.threadData.getThreadStateAt(index);
                        int x = Math.max((int)((float)(ThreadStateColumnImpl.timeStampToMilliSeconds(threadStateAt.getTimeStamp()) - this.viewStart) * factor), 0);
                        if (index < this.threadData.size() - 1) {
                            xx = Math.min((int)((float)(ThreadStateColumnImpl.timeStampToMilliSeconds(this.threadData.getThreadStateAt(index + 1).getTimeStamp()) - this.viewStart) * factor), width);
                        } else {
                            int interval = ThreadStateColumnImpl.timeInervalToMilliSeconds(threadStateAt.getMSASamplePeriod());
                            xx = Math.min((int)((float)(ThreadStateColumnImpl.timeStampToMilliSeconds(threadStateAt.getTimeStamp()) + (long)interval - this.viewStart) * factor + 0.5f), width);
                        }
                        if (x <= point.x && point.x < xx) {
                            return index;
                        }
                    }
                    ++index;
                }
            }
        }
        return -1;
    }

    private static String colorToHexString(Color c) {
        return String.format("%06x", c.getRGB() & 0xFFFFFF);
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    private void calculateShift() {
        if (!this.isShiftCounted) {
            Point header = this.table.getTableHeader().getLocationOnScreen();
            Point stateRow = new Point(0, 0);
            SwingUtilities.convertPointToScreen(stateRow, this);
            int nameWidth = this.table.getTableHeader().getColumnModel().getColumn(0).getWidth();
            int shift = stateRow.x - header.x - nameWidth;
            this.isShiftCounted = true;
            ThreadStateHeaderRenderer.shift = shift;
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.calculateShift();
        this.paintTimeMarks(g);
        if (this.threadData != null) {
            int index = this.getFirstVisibleDataUnit();
            if (index != -1) {
                int width = this.getWidth();
                if (this.viewEnd - this.viewStart > 0L) {
                    float factor = (float)width / (float)(this.viewEnd - this.viewStart);
                    while (index < this.threadData.size() && ThreadStateColumnImpl.timeStampToMilliSeconds(this.threadData.getThreadStateAt(index).getTimeStamp()) <= this.viewEnd) {
                        if (this.threadData.isAlive(index)) {
                            this.paintThreadState(g, index, this.threadData.getThreadStateAt(index), factor, width);
                        }
                        ++index;
                    }
                }
            }
            this.paintGray(g);
        }
        this.paintTimeLine(g);
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public void repaint(Rectangle r) {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setForeground(null);
        this.setBackground(null);
    }

    @Override
    public void validate() {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    }

    private int getFirstVisibleDataUnit() {
        for (int i = 0; i < this.threadData.size(); ++i) {
            long timestamp = ThreadStateColumnImpl.timeStampToMilliSeconds(this.threadData.getThreadStateAt(i).getTimeStamp());
            if (timestamp <= this.viewEnd && i == this.threadData.size() - 1) {
                return i;
            }
            if (!(timestamp <= this.viewStart ? ThreadStateColumnImpl.timeStampToMilliSeconds(this.threadData.getThreadStateAt(i + 1).getTimeStamp()) > this.viewStart : timestamp <= this.viewEnd)) continue;
            return i;
        }
        return -1;
    }

    private List<Range<Long>> getGray() {
        Collection<TimeIntervalDataFilter> aTimeFilters = this.timeFilters;
        if (aTimeFilters == null || aTimeFilters.isEmpty()) {
            return Collections.emptyList();
        }
        Range range = new Range((Number)ThreadStateColumnImpl.timeInervalToNanoSeconds(this.viewStart - this.dataStart), (Number)ThreadStateColumnImpl.timeInervalToNanoSeconds(this.viewEnd - this.dataStart));
        ArrayList<Range> ranges = new ArrayList<Range>(this.timeFilters.size());
        for (TimeIntervalDataFilter filter : aTimeFilters) {
            ranges.add(filter.getInterval());
        }
        return range.subtract(ranges);
    }

    private void paintThreadState(Graphics g, int index, ThreadState threadStateColor, float factor, int width) {
        int xx;
        int x = Math.max((int)((float)(ThreadStateColumnImpl.timeStampToMilliSeconds(threadStateColor.getTimeStamp()) - this.viewStart) * factor), 0);
        if (index < this.threadData.size() - 1) {
            xx = Math.min((int)((float)(ThreadStateColumnImpl.timeStampToMilliSeconds(this.threadData.getThreadStateAt(index + 1).getTimeStamp()) - this.viewStart) * factor), width);
        } else {
            int interval = ThreadStateColumnImpl.timeInervalToMilliSeconds(threadStateColor.getMSASamplePeriod());
            xx = Math.min((int)((float)(ThreadStateColumnImpl.timeStampToMilliSeconds(threadStateColor.getTimeStamp()) + (long)interval - this.viewStart) * factor + 0.5f), width);
        }
        int delta = this.getHeight() - 6;
        if (this.viewManager.isMSAMode()) {
            for (AtomicInteger i : this.map.values()) {
                i.set(0);
            }
            ThreadStateColumnImpl.fillMap(this.viewManager, threadStateColor, this.map);
            ThreadStateColumnImpl.roundMap(this.map);
            int y = 0;
            int rest = 50;
            int oldRest = 0;
            OrderedEnumStateIterator it = new OrderedEnumStateIterator(this.map);
            while (it.hasNext()) {
                Object entry = it.next();
                int v = ((AtomicInteger)entry.getValue()).get();
                Color c = ThreadStateColumnImpl.getThreadStateColor((ThreadState.MSAState)entry.getKey());
                oldRest = rest;
                rest = (v * delta + oldRest) % 100;
                int d = (v * delta + oldRest) / 100;
                y += d;
                if (d <= 0) continue;
                g.setColor(c);
                g.fillRect(x, 3 + delta - y, xx - x, d);
            }
        } else {
            Color c = ThreadStateColumnImpl.getThreadStateColor(threadStateColor.getMSAState(threadStateColor.getSamplingStateIndex(this.viewManager.isFullMode()), this.viewManager.isFullMode()));
            g.setColor(c);
            g.fillRect(x, 3, xx - x, delta);
        }
    }

    private void paintGray(Graphics g) {
        if (this.viewEnd - this.viewStart > 0L) {
            int width = this.getWidth();
            float factor = (float)width / (float)(this.viewEnd - this.viewStart);
            long firstValue = this.viewStart - this.dataStart;
            int i = 0;
            for (Range<Long> range : this.getGray()) {
                g.setColor(UIUtils.getDarker(this.getBackground(), this.BorderDarkerFactor));
                int x1 = (int)((float)((long)ThreadStateColumnImpl.timeInervalToMilliSeconds((Long)range.getStart()) - firstValue) * factor);
                int x2 = (int)((float)((long)ThreadStateColumnImpl.timeInervalToMilliSeconds((Long)range.getEnd()) - firstValue) * factor);
                Composite composite = ((Graphics2D)g).getComposite();
                ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, this.AlphaCompositeConstant));
                g.fillRect(x1, 0, x2, this.getHeight() - 1);
                ((Graphics2D)g).setComposite(composite);
                g.setColor(this.TIME_SELECTION_BORDER);
                if (x1 > 0) {
                    g.drawLine(x1, 0, x1, this.getHeight() - 1);
                }
                if (x2 < width) {
                    g.drawLine(x2, 0, x2, this.getHeight() - 1);
                }
                ++i;
            }
        }
    }

    private void paintTimeMarks(Graphics g) {
        if (this.viewEnd - this.viewStart > 0L) {
            int firstValue = (int)(this.viewStart - this.dataStart);
            int lastValue = (int)(this.viewEnd - this.dataStart);
            float factor = (float)this.getWidth() / (float)(this.viewEnd - this.viewStart);
            int optimalUnits = TimeLineUtils.getOptimalUnits(factor);
            int firstMark = Math.max((int)(Math.ceil((double)firstValue / (double)optimalUnits) * (double)optimalUnits), 0);
            for (int currentMark = firstMark - optimalUnits; currentMark <= lastValue + optimalUnits; currentMark += optimalUnits) {
                if (currentMark < 0) continue;
                float currentMarkRel = currentMark - firstValue;
                int markPosition = (int)(currentMarkRel * factor);
                this.paintTimeTicks(g, (int)(currentMarkRel * factor), (int)((currentMarkRel + (float)optimalUnits) * factor), TimeLineUtils.getTicksCount(optimalUnits));
                g.setColor(TimeLineUtils.MAIN_TIMELINE_COLOR);
                g.drawLine(markPosition, 0, markPosition, this.getHeight() - 1);
            }
        }
    }

    private void paintTimeLine(Graphics g) {
        long time;
        if (this.viewEnd - this.viewStart > 0L && this.timeLine != null && this.viewStart < (time = this.timeLine.getTimeStamp() + (long)(this.timeLine.getInterval() / 2)) && time < this.viewEnd) {
            int x = (int)((long)this.getWidth() * (time - this.viewStart) / (this.viewEnd - this.viewStart));
            g.setColor(TimeLineUtils.TIMELINE_CURSOR_COLOR);
            g.drawLine(x, 0, x, this.getHeight() - 1);
        }
    }

    private void paintTimeTicks(Graphics g, int startPos, int endPos, int count) {
        float factor = (float)(endPos - startPos) / (float)count;
        g.setColor(TimeLineUtils.TICK_TIMELINE_COLOR);
        for (int i = 1; i < count; ++i) {
            int x = startPos + (int)((float)i * factor);
            g.drawLine(x, 0, x, this.getHeight() - 1);
        }
    }
}

