/*
 * Decompiled with CFR 0.152.
 */
package java.nio.charset;

import gnu.classpath.ServiceFactory;
import gnu.classpath.SystemProperties;
import gnu.java.nio.charset.Provider;
import gnu.java.nio.charset.iconv.IconvProvider;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.charset.spi.CharsetProvider;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class Charset
implements Comparable {
    private static CharsetProvider[] providers;
    private CharsetEncoder cachedEncoder;
    private CharsetDecoder cachedDecoder;
    private final String canonicalName;
    private final String[] aliases;
    static /* synthetic */ Class class$java$nio$charset$spi$CharsetProvider;

    private static final void checkName(String string) {
        int n = string.length();
        if (n == 0) {
            throw new IllegalCharsetNameException(string);
        }
        char c = string.charAt(0);
        if (!('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z' || '0' <= c && c <= '9')) {
            throw new IllegalCharsetNameException(string);
        }
        int n2 = 1;
        while (n2 < n) {
            c = string.charAt(n2);
            if (!('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z' || '0' <= c && c <= '9' || c == '-' || c == '.' || c == ':' || c == '_')) {
                throw new IllegalCharsetNameException(string);
            }
            ++n2;
        }
    }

    public static Charset defaultCharset() {
        String string;
        try {
            string = SystemProperties.getProperty("file.encoding");
        }
        catch (SecurityException securityException) {
            string = "ISO-8859-1";
        }
        catch (IllegalArgumentException illegalArgumentException) {
            string = "ISO-8859-1";
        }
        try {
            return Charset.forName(string);
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        throw new IllegalStateException("Can't get default charset!");
    }

    public static boolean isSupported(String string) {
        boolean bl = false;
        if (Charset.charsetForName(string) != null) {
            bl = true;
        }
        return bl;
    }

    public static Charset forName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Charset name must not be null.");
        }
        Charset charset = Charset.charsetForName(string);
        if (charset == null) {
            throw new UnsupportedCharsetException(string);
        }
        return charset;
    }

    private static final Charset charsetForName(String string) {
        Charset.checkName(string);
        Charset charset = Charset.provider().charsetForName(string);
        if (charset == null) {
            CharsetProvider[] charsetProviderArray = Charset.providers2();
            int n = 0;
            while (n < charsetProviderArray.length) {
                charset = charsetProviderArray[n].charsetForName(string);
                if (charset != null) break;
                ++n;
            }
        }
        return charset;
    }

    public static SortedMap availableCharsets() {
        TreeMap treeMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        CharsetProvider[] charsetProviderArray = Charset.provider().charsets();
        while (charsetProviderArray.hasNext()) {
            Charset charset = (Charset)charsetProviderArray.next();
            treeMap.put(charset.name(), charset);
        }
        charsetProviderArray = Charset.providers2();
        int n = 0;
        while (n < charsetProviderArray.length) {
            Iterator iterator = charsetProviderArray[n].charsets();
            while (iterator.hasNext()) {
                Charset charset = (Charset)iterator.next();
                treeMap.put(charset.name(), charset);
            }
            ++n;
        }
        return Collections.unmodifiableSortedMap(treeMap);
    }

    private static final CharsetProvider provider() {
        String string = SystemProperties.getProperty("gnu.classpath.nio.charset.provider.iconv");
        if (string != null) {
            return IconvProvider.provider();
        }
        return Provider.provider();
    }

    private static final CharsetProvider[] providers2() {
        if (providers == null) {
            try {
                Class clazz = class$java$nio$charset$spi$CharsetProvider;
                if (clazz == null) {
                    clazz = class$java$nio$charset$spi$CharsetProvider = Charset.class("[Ljava.nio.charset.spi.CharsetProvider;", false);
                }
                Iterator iterator = ServiceFactory.lookupProviders(clazz);
                LinkedHashSet linkedHashSet = new LinkedHashSet();
                while (iterator.hasNext()) {
                    linkedHashSet.add(iterator.next());
                }
                providers = new CharsetProvider[linkedHashSet.size()];
                linkedHashSet.toArray(providers);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return providers;
    }

    public final String name() {
        return this.canonicalName;
    }

    public final Set aliases() {
        if (this.aliases == null) {
            return Collections.EMPTY_SET;
        }
        int n = this.aliases.length;
        HashSet hashSet = new HashSet(n);
        int n2 = 0;
        while (n2 < n) {
            hashSet.add(this.aliases[n2]);
            ++n2;
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public String displayName() {
        return this.canonicalName;
    }

    public String displayName(Locale locale) {
        return this.canonicalName;
    }

    public final boolean isRegistered() {
        boolean bl = false;
        if (!this.canonicalName.startsWith("x-") && !this.canonicalName.startsWith("X-")) {
            bl = true;
        }
        return bl;
    }

    public abstract boolean contains(Charset var1);

    public abstract CharsetDecoder newDecoder();

    public abstract CharsetEncoder newEncoder();

    public boolean canEncode() {
        return true;
    }

    public final synchronized ByteBuffer encode(CharBuffer charBuffer) {
        try {
            if (this.cachedEncoder == null) {
                this.cachedEncoder = this.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
            } else {
                this.cachedEncoder.reset();
            }
            return this.cachedEncoder.encode(charBuffer);
        }
        catch (CharacterCodingException characterCodingException) {
            throw new AssertionError((Object)characterCodingException);
        }
    }

    public final ByteBuffer encode(String string) {
        return this.encode(CharBuffer.wrap(string));
    }

    public final synchronized CharBuffer decode(ByteBuffer byteBuffer) {
        try {
            if (this.cachedDecoder == null) {
                this.cachedDecoder = this.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
            } else {
                this.cachedDecoder.reset();
            }
            return this.cachedDecoder.decode(byteBuffer);
        }
        catch (CharacterCodingException characterCodingException) {
            throw new AssertionError((Object)characterCodingException);
        }
    }

    public final int compareTo(Object object) {
        return this.canonicalName.compareToIgnoreCase(((Charset)object).canonicalName);
    }

    public final int hashCode() {
        return this.canonicalName.hashCode();
    }

    public final boolean equals(Object object) {
        if (object instanceof Charset) {
            return this.canonicalName.equalsIgnoreCase(((Charset)object).canonicalName);
        }
        return false;
    }

    public final String toString() {
        return this.canonicalName;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    protected Charset(String string, String[] stringArray) {
        Charset.checkName(string);
        if (stringArray != null) {
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                Charset.checkName(stringArray[n2]);
                ++n2;
            }
        }
        this.cachedEncoder = null;
        this.cachedDecoder = null;
        this.canonicalName = string;
        this.aliases = stringArray;
    }
}

