/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.jce.sig;

import gnu.java.security.jce.sig.KeyPairGeneratorAdapter;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.SecureRandom;
import java.security.interfaces.DSAKeyPairGenerator;
import java.security.interfaces.DSAParams;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.util.HashMap;

public class DSSKeyPairGeneratorSpi
extends KeyPairGeneratorAdapter
implements DSAKeyPairGenerator {
    public void initialize(int n, SecureRandom secureRandom) {
        this.initialize(n, false, secureRandom);
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        HashMap hashMap = new HashMap();
        if (algorithmParameterSpec != null) {
            if (!(algorithmParameterSpec instanceof DSAParameterSpec)) {
                throw new InvalidAlgorithmParameterException("Parameters argument is not a non-null instance, or sub-instance, of java.security.spec.DSAParameterSpec");
            }
            hashMap.put("gnu.crypto.dss.params", algorithmParameterSpec);
        }
        if (secureRandom != null) {
            hashMap.put("gnu.crypto.dss.prng", secureRandom);
        }
        hashMap.put("gnu.crypto.dss.encoding", new Integer(4));
        try {
            this.adaptee.setup(hashMap);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            InvalidAlgorithmParameterException invalidAlgorithmParameterException = new InvalidAlgorithmParameterException();
            invalidAlgorithmParameterException.initCause(illegalArgumentException);
            throw invalidAlgorithmParameterException;
        }
    }

    public void initialize(DSAParams dSAParams, SecureRandom secureRandom) throws InvalidParameterException {
        if (dSAParams == null || !(dSAParams instanceof DSAParameterSpec)) {
            throw new InvalidParameterException("Parameters argument is either null or is not an instance, or sub-instance, of java.security.spec.DSAParameterSpec");
        }
        DSAParameterSpec dSAParameterSpec = (DSAParameterSpec)dSAParams;
        try {
            this.initialize(dSAParameterSpec, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            InvalidParameterException invalidParameterException = new InvalidParameterException();
            invalidParameterException.initCause(invalidAlgorithmParameterException);
            throw invalidParameterException;
        }
    }

    public void initialize(int n, boolean bl, SecureRandom secureRandom) throws InvalidParameterException {
        HashMap hashMap = new HashMap();
        hashMap.put("gnu.crypto.dss.L", new Integer(n));
        if (secureRandom != null) {
            hashMap.put("gnu.crypto.dss.prng", secureRandom);
        }
        hashMap.put("gnu.crypto.dss.use.defaults", bl ^ true);
        hashMap.put("gnu.crypto.dss.strict.defaults", Boolean.TRUE);
        hashMap.put("gnu.crypto.dss.encoding", new Integer(4));
        try {
            this.adaptee.setup(hashMap);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            InvalidParameterException invalidParameterException = new InvalidParameterException();
            invalidParameterException.initCause(illegalArgumentException);
            throw invalidParameterException;
        }
    }

    public DSSKeyPairGeneratorSpi() {
        super("dss");
    }
}

