/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.structure;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.TextEditorBasedStructureViewModel;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.structure.GroovyInheritFilter;
import org.jetbrains.plugins.groovy.structure.elements.impl.GroovyFileStructureViewElement;

public class GroovyStructureViewModel
extends TextEditorBasedStructureViewModel {
    private final GroovyFileBase myRootElement;
    private static final Class[] SUITABLE_CLASSES = new Class[]{GroovyFileBase.class, GrTypeDefinition.class, GrMethod.class, GrVariable.class};

    public GroovyStructureViewModel(GroovyFileBase rootElement) {
        super((PsiFile)rootElement);
        this.myRootElement = rootElement;
    }

    protected PsiFile getPsiFile() {
        return this.myRootElement;
    }

    @NotNull
    public StructureViewTreeElement getRoot() {
        GroovyFileStructureViewElement groovyFileStructureViewElement = new GroovyFileStructureViewElement(this.myRootElement);
        if (groovyFileStructureViewElement == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/structure/GroovyStructureViewModel.getRoot must not return null");
        }
        return groovyFileStructureViewElement;
    }

    @NotNull
    public Sorter[] getSorters() {
        Sorter[] sorterArray = new Sorter[]{Sorter.ALPHA_SORTER};
        if (sorterArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/structure/GroovyStructureViewModel.getSorters must not return null");
        }
        return sorterArray;
    }

    @NotNull
    public Filter[] getFilters() {
        Filter[] filterArray = new Filter[]{new GroovyInheritFilter()};
        if (filterArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/structure/GroovyStructureViewModel.getFilters must not return null");
        }
        return filterArray;
    }

    public boolean shouldEnterElement(Object element) {
        return element instanceof GrTypeDefinition;
    }

    @NotNull
    protected Class[] getSuitableClasses() {
        if (SUITABLE_CLASSES == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/structure/GroovyStructureViewModel.getSuitableClasses must not return null");
        }
        return SUITABLE_CLASSES;
    }

    protected Object findAcceptableElement(PsiElement element) {
        while (element != null && !(element instanceof PsiDirectory)) {
            if (this.isSuitable(element)) {
                if (element instanceof GroovyFileBase && ((GroovyFileBase)element).getTypeDefinitions().length == 1) {
                    return ((GroovyFileBase)element).getTypeDefinitions()[0];
                }
                return element;
            }
            element = element.getParent();
        }
        return null;
    }

    protected boolean isSuitable(PsiElement element) {
        if (super.isSuitable(element)) {
            if (element instanceof GrMethod) {
                GrMethod method = (GrMethod)element;
                PsiElement parent = method.getParent().getParent();
                if (parent instanceof GrTypeDefinition) {
                    return ((GrTypeDefinition)parent).getQualifiedName() != null;
                }
            } else if (element instanceof GrVariable) {
                GrVariable field = (GrVariable)element;
                PsiElement parent = field.getParent().getParent().getParent();
                if (parent instanceof GrTypeDefinition) {
                    return ((GrTypeDefinition)parent).getQualifiedName() != null;
                }
            } else {
                if (element instanceof GrTypeDefinition) {
                    return ((GrTypeDefinition)element).getQualifiedName() != null;
                }
                if (element instanceof GroovyFileBase) {
                    return true;
                }
            }
        }
        return false;
    }
}

