/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.stubs.impl;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.io.StringRef;
import org.jetbrains.plugins.groovy.lang.parser.GroovyParserDefinition;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrFileStub;

public class GrFileStubImpl
extends PsiFileStubImpl<GroovyFile>
implements GrFileStub {
    private final StringRef myPackageName;
    private final StringRef myName;
    private final boolean isScript;

    public GrFileStubImpl(GroovyFile file) {
        super((PsiFile)file);
        this.myPackageName = StringRef.fromString((String)file.getPackageName());
        this.myName = StringRef.fromString((String)StringUtil.trimEnd((String)file.getName(), (String)".groovy"));
        this.isScript = file.isScript();
    }

    public GrFileStubImpl(StringRef packName, StringRef name, boolean isScript) {
        super(null);
        this.myPackageName = packName;
        this.myName = name;
        this.isScript = isScript;
    }

    public IStubFileElementType getType() {
        return GroovyParserDefinition.GROOVY_FILE;
    }

    @Override
    public StringRef getPackageName() {
        return this.myPackageName;
    }

    @Override
    public StringRef getName() {
        return this.myName;
    }

    @Override
    public boolean isScript() {
        return this.isScript;
    }
}

