/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.stubs.elements;

import com.intellij.lang.Language;
import com.intellij.psi.StubBuilder;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrFileStub;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GroovyFileStubBuilder;
import org.jetbrains.plugins.groovy.lang.psi.stubs.impl.GrFileStubImpl;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrFullScriptNameIndex;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrScriptClassNameIndex;

public class GrStubFileElementType
extends IStubFileElementType<GrFileStub> {
    public GrStubFileElementType(Language language) {
        super(language);
    }

    public StubBuilder getBuilder() {
        return new GroovyFileStubBuilder();
    }

    public int getStubVersion() {
        return super.getStubVersion() + 5;
    }

    public String getExternalId() {
        return "groovy.FILE";
    }

    public void indexStub(PsiFileStub stub, IndexSink sink) {
        super.indexStub(stub, sink);
    }

    public void serialize(GrFileStub stub, StubOutputStream dataStream) throws IOException {
        dataStream.writeName(stub.getPackageName().toString());
        dataStream.writeName(stub.getName().toString());
        dataStream.writeBoolean(stub.isScript());
    }

    public GrFileStub deserialize(StubInputStream dataStream, StubElement parentStub) throws IOException {
        StringRef packName = dataStream.readName();
        StringRef name = dataStream.readName();
        boolean isScript = dataStream.readBoolean();
        return new GrFileStubImpl(packName, name, isScript);
    }

    public void indexStub(GrFileStub stub, IndexSink sink) {
        String name = stub.getName().toString();
        if (stub.isScript() && name != null) {
            sink.occurrence(GrScriptClassNameIndex.KEY, (Object)name);
            String pName = stub.getPackageName().toString();
            String fqn = pName == null || pName.length() == 0 ? name : pName + "." + name;
            sink.occurrence(GrFullScriptNameIndex.KEY, (Object)fqn.hashCode());
        }
    }
}

