/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public class GrConditionalExprImpl
extends GrExpressionImpl
implements GrConditionalExpression {
    public GrConditionalExprImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrConditionalExprImpl.<init> must not be null");
        }
        super(node);
    }

    public String toString() {
        return "Conditional expression";
    }

    @Override
    public GrExpression getCondition() {
        GrExpression[] exprs = (GrExpression[])this.findChildrenByClass(GrExpression.class);
        if (exprs.length > 0) {
            return exprs[0];
        }
        return null;
    }

    @Override
    public GrExpression getThenBranch() {
        GrExpression[] exprs = (GrExpression[])this.findChildrenByClass(GrExpression.class);
        if (exprs.length > 1) {
            return exprs[1];
        }
        return null;
    }

    @Override
    public GrExpression getElseBranch() {
        GrExpression[] exprs = (GrExpression[])this.findChildrenByClass(GrExpression.class);
        if (exprs.length > 2) {
            return exprs[2];
        }
        return null;
    }

    @Override
    public PsiType getType() {
        GrExpression thenBranch = this.getThenBranch();
        GrExpression elseBranch = this.getElseBranch();
        if (thenBranch == null) {
            if (elseBranch != null) {
                return elseBranch.getType();
            }
        } else {
            if (elseBranch == null) {
                return thenBranch.getType();
            }
            PsiType thenType = thenBranch.getType();
            PsiType elseType = elseBranch.getType();
            if (thenType == null || elseType == null) {
                return elseType;
            }
            if (elseType.equals(thenType)) {
                return thenType;
            }
            return TypesUtil.getLeastUpperBound(thenType, elseType, (PsiManager)this.getManager());
        }
        return null;
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitConditionalExpression(this);
    }
}

