/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyIcons;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrTupleDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrVariableDeclarationOwner;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyBaseElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public abstract class GrVariableBaseImpl<T extends StubElement>
extends GroovyBaseElementImpl<T>
implements GrVariable {
    public static final Logger LOG = Logger.getInstance((String)"org.jetbrains.plugins.groovy.lang.psi.impl.statements.GrVariableImpl");

    public GrVariableBaseImpl(ASTNode node) {
        super(node);
    }

    protected GrVariableBaseImpl(T stub, IStubElementType nodeType) {
        super(stub, nodeType);
    }

    @Nullable
    public PsiTypeElement getTypeElement() {
        return null;
    }

    @Nullable
    public PsiExpression getInitializer() {
        return null;
    }

    public boolean hasInitializer() {
        return false;
    }

    public void normalizeDeclaration() throws IncorrectOperationException {
    }

    @Nullable
    public Object computeConstantValue() {
        return null;
    }

    public void delete() throws IncorrectOperationException {
        PsiElement parent = this.getParent();
        PsiElement prev = PsiUtil.getPrevNonSpace(this);
        PsiElement next = PsiUtil.getNextNonSpace(this);
        ASTNode parentNode = parent.getNode();
        assert (parentNode != null);
        parentNode.removeChild(this.getNode());
        if (prev != null && prev.getNode() != null && prev.getNode().getElementType() == GroovyTokenTypes.mCOMMA) {
            parentNode.removeChild(prev.getNode());
        } else if (next instanceof LeafPsiElement && next.getNode() != null && next.getNode().getElementType() == GroovyTokenTypes.mCOMMA) {
            next.delete();
        }
        if (parent instanceof GrVariableDeclaration && ((GrVariableDeclaration)parent).getVariables().length == 0) {
            parent.delete();
        }
    }

    public boolean hasModifierProperty(@NonNls @NotNull String property) {
        if (property == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/GrVariableBaseImpl.hasModifierProperty must not be null");
        }
        GrModifierList modifierList = this.getModifierList();
        return modifierList != null && modifierList.hasModifierProperty(property);
    }

    public String getElementToCompare() {
        return this.getName();
    }

    @NotNull
    public PsiType getType() {
        PsiType type = this.getDeclaredType();
        Object object = type != null ? type : TypesUtil.getJavaLangObject(this);
        if (object == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/GrVariableBaseImpl.getType must not return null");
        }
        return object;
    }

    @Override
    @Nullable
    public GrTypeElement getTypeElementGroovy() {
        PsiElement parent = this.getParent();
        if (parent instanceof GrTupleDeclaration || !(parent instanceof GrVariableDeclaration)) {
            return null;
        }
        return ((GrVariableDeclaration)parent).getTypeElementGroovy();
    }

    @Override
    @Nullable
    public PsiType getDeclaredType() {
        GrTypeElement typeElement = this.getTypeElementGroovy();
        if (typeElement != null) {
            return typeElement.getType();
        }
        return null;
    }

    @Override
    @Nullable
    public PsiType getTypeGroovy() {
        GrExpression initializer = this.getInitializerGroovy();
        PsiElement parent = this.getParent();
        if (parent instanceof GrTupleDeclaration && initializer != null) {
            return initializer.getType();
        }
        GrTypeElement typeElement = this.getTypeElementGroovy();
        PsiType declaredType = null;
        if (typeElement != null && !((declaredType = typeElement.getType()) instanceof PsiClassType)) {
            return declaredType;
        }
        if (initializer != null) {
            PsiClassType.ClassResolveResult initializerResult;
            PsiClass initializerClass;
            PsiClass declaredClass;
            PsiType initializerType = initializer.getType();
            if (initializerType != null && declaredType != null && initializerType instanceof PsiClassType && (declaredClass = ((PsiClassType)declaredType).resolve()) != null && (initializerClass = (initializerResult = ((PsiClassType)initializerType).resolveGenerics()).getElement()) != null && !com.intellij.psi.util.PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)initializerClass, (PsiSubstitutor)initializerResult.getSubstitutor())) {
                if (declaredClass == initializerClass) {
                    return initializerType;
                }
                PsiSubstitutor superSubstitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)declaredClass, (PsiClass)initializerClass, (PsiSubstitutor)initializerResult.getSubstitutor());
                if (superSubstitutor != null) {
                    return JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory().createType(declaredClass, superSubstitutor);
                }
            }
            if (declaredType == null) {
                declaredType = initializerType;
            }
        }
        return declaredType;
    }

    @Override
    public void setType(@Nullable PsiType type) {
        GrTypeElement typeElement = this.getTypeElementGroovy();
        if (type == null) {
            if (typeElement == null) {
                return;
            }
            ASTNode typeElementNode = typeElement.getNode();
            ASTNode parent = typeElementNode.getTreeParent();
            parent.addLeaf(GroovyTokenTypes.kDEF, (CharSequence)"def", typeElementNode);
            parent.removeChild(typeElementNode);
        } else {
            GrTypeElement newTypeElement;
            type = TypesUtil.unboxPrimitiveTypeWrapper(type);
            try {
                newTypeElement = GroovyPsiElementFactory.getInstance(this.getProject()).createTypeElement(type);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
                return;
            }
            ASTNode newTypeElementNode = newTypeElement.getNode();
            if (typeElement == null) {
                PsiElement defKeyword = this.findChildByType(GroovyTokenTypes.kDEF);
                if (defKeyword != null) {
                    ASTNode defKeywordNode = defKeyword.getNode();
                    assert (defKeywordNode != null);
                    defKeywordNode.getTreeParent().removeChild(defKeywordNode);
                }
                PsiElement nameID = this.getNameIdentifierGroovy();
                ASTNode nameIdNode = nameID.getNode();
                assert (nameIdNode != null);
                nameIdNode.getTreeParent().addChild(newTypeElementNode);
            } else {
                ASTNode typeElementNode = typeElement.getNode();
                ASTNode parent = typeElementNode.getTreeParent();
                parent.replaceChild(typeElementNode, newTypeElementNode);
            }
            PsiUtil.shortenReferences(newTypeElement);
        }
    }

    @Override
    @NotNull
    public PsiElement getNameIdentifierGroovy() {
        PsiElement ident = this.findChildByType(TokenSets.PROPERTY_NAMES);
        assert (ident != null) : this.getText();
        PsiElement psiElement = ident;
        if (psiElement == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/GrVariableBaseImpl.getNameIdentifierGroovy must not return null");
        }
        return psiElement;
    }

    @Override
    @Nullable
    public GrExpression getInitializerGroovy() {
        GrTupleDeclaration tuple;
        GrExpression initializer;
        PsiElement parent = this.getParent();
        if (parent instanceof GrTupleDeclaration && (initializer = (tuple = (GrTupleDeclaration)parent).getInitializerGroovy()) instanceof GrListOrMap) {
            int varNumber;
            GrListOrMap listOrMap = (GrListOrMap)initializer;
            GrExpression[] initializers = listOrMap.getInitializers();
            if (initializers.length < (varNumber = tuple.getVariableNumber(this)) + 1) {
                return null;
            }
            return initializers[varNumber];
        }
        return (GrExpression)this.findChildByClass(GrExpression.class);
    }

    public int getTextOffset() {
        return this.getNameIdentifierGroovy().getTextRange().getStartOffset();
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/GrVariableBaseImpl.setName must not be null");
        }
        PsiImplUtil.setName(name, this.getNameIdentifierGroovy());
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public SearchScope getUseScope() {
        SearchScope searchScope;
        GrVariableDeclarationOwner owner = (GrVariableDeclarationOwner)PsiTreeUtil.getParentOfType((PsiElement)this, GrVariableDeclarationOwner.class);
        if (owner != null) {
            searchScope = new LocalSearchScope((PsiElement)owner);
            if (searchScope == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/GrVariableBaseImpl.getUseScope must not return null");
            return searchScope;
        }
        searchScope = super.getUseScope();
        if (searchScope != null) return searchScope;
        throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/GrVariableBaseImpl.getUseScope must not return null");
    }

    @NotNull
    public String getName() {
        String string = PsiImplUtil.getName(this);
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/GrVariableBaseImpl.getName must not return null");
        }
        return string;
    }

    @NotNull
    public PsiIdentifier getNameIdentifier() {
        PsiIdentifier psiIdentifier = PsiUtil.getJavaNameIdentifier(this);
        if (psiIdentifier == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/GrVariableBaseImpl.getNameIdentifier must not return null");
        }
        return psiIdentifier;
    }

    @Nullable
    public GrModifierList getModifierList() {
        PsiElement parent = this.getParent();
        if (parent instanceof GrVariableDeclaration) {
            return ((GrVariableDeclaration)parent).getModifierList();
        }
        if (parent instanceof GrTupleDeclaration) {
            return ((GrVariableDeclaration)parent.getParent()).getModifierList();
        }
        return null;
    }

    @Nullable
    public Icon getIcon(int flags) {
        return GroovyIcons.VARIABLE;
    }

    public PsiType getTypeNoResolve() {
        return this.getType();
    }
}

