/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrNamedElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrPostfixExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrRelationalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSafeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTypeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.arithmetic.GrAdditiveExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.arithmetic.GrMultiplicativeExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.arithmetic.GrPowerExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.arithmetic.GrRangeExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.arithmetic.GrShiftExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.bitwise.GrAndExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.bitwise.GrExclusiveOrExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.bitwise.GrInclusiveOrExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.logical.GrLogicalAndExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.logical.GrLogicalOrExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.regex.GrRegexExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.relational.GrEqualityExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class PsiImplUtil {
    private static final Logger LOG = Logger.getInstance((String)"org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil");
    private static final String MAIN_METHOD = "main";

    private PsiImplUtil() {
    }

    public static GrExpression replaceExpression(GrExpression oldExpr, GrExpression newExpr, boolean removeUnnecessaryParentheses) {
        GroovyPsiElementFactory factory;
        ASTNode oldNode = oldExpr.getNode();
        PsiElement oldParent = oldExpr.getParent();
        if (oldParent == null) {
            throw new PsiInvalidElementAccessException((PsiElement)oldExpr);
        }
        ASTNode parentNode = oldParent.getNode();
        if (newExpr instanceof GrApplicationStatement && !(oldExpr instanceof GrApplicationStatement)) {
            factory = GroovyPsiElementFactory.getInstance(oldExpr.getProject());
            newExpr = factory.createMethodCallByAppCall((GrApplicationStatement)((Object)newExpr));
        }
        if (removeUnnecessaryParentheses && oldParent instanceof GrParenthesizedExpression) {
            return ((GrExpression)oldParent).replaceWithExpression(newExpr, removeUnnecessaryParentheses);
        }
        factory = GroovyPsiElementFactory.getInstance(oldExpr.getProject());
        if (GrStringUtil.isReplacedExpressionInGStringInjection(oldExpr)) {
            if (!(newExpr instanceof GrReferenceExpression)) {
                newExpr = factory.createExpressionFromText("{" + newExpr.getText() + "}");
            }
        } else if (oldParent instanceof GrExpression && !(oldParent instanceof GrParenthesizedExpression)) {
            GrBinaryExpression binaryExpression;
            int newPriorityLevel;
            GrExpression parentExpr = (GrExpression)oldParent;
            int parentPriorityLevel = PsiImplUtil.getExprPriorityLevel(parentExpr);
            if (parentPriorityLevel > (newPriorityLevel = PsiImplUtil.getExprPriorityLevel(newExpr))) {
                newExpr = factory.createParenthesizedExpr(newExpr);
            } else if (parentPriorityLevel == newPriorityLevel && parentPriorityLevel != 0 && parentExpr instanceof GrBinaryExpression && PsiImplUtil.isNotAssociative(binaryExpression = (GrBinaryExpression)parentExpr) && oldExpr.equals(binaryExpression.getRightOperand())) {
                newExpr = factory.createParenthesizedExpr(newExpr);
            }
        }
        ASTNode newNode = newExpr.copy().getNode();
        assert (newNode != null && parentNode != null);
        parentNode.replaceChild(oldNode, newNode);
        return (GrExpression)newNode.getPsi();
    }

    private static boolean isNotAssociative(GrBinaryExpression binaryExpression) {
        if (binaryExpression instanceof GrMultiplicativeExpressionImpl) {
            return binaryExpression.getOperationTokenType() != GroovyTokenTypes.mSTAR;
        }
        if (binaryExpression instanceof GrAdditiveExpressionImpl) {
            return binaryExpression.getOperationTokenType() == GroovyTokenTypes.mMINUS;
        }
        return binaryExpression instanceof GrEqualityExpressionImpl || binaryExpression instanceof GrRegexExpressionImpl || binaryExpression instanceof GrShiftExpressionImpl || binaryExpression instanceof GrPowerExpressionImpl;
    }

    @Nullable
    public static GrExpression getRuntimeQualifier(GrReferenceExpression refExpr) {
        GrExpression qualifier = refExpr.getQualifierExpression();
        if (qualifier == null) {
            GrClosableBlock closure = (GrClosableBlock)PsiTreeUtil.getParentOfType((PsiElement)refExpr, GrClosableBlock.class);
            while (closure != null) {
                GrExpression funExpr = null;
                PsiElement parent = closure.getParent();
                if (parent instanceof GrApplicationStatement) {
                    funExpr = ((GrApplicationStatement)parent).getFunExpression();
                } else if (parent instanceof GrMethodCallExpression) {
                    funExpr = ((GrMethodCallExpression)parent).getInvokedExpression();
                }
                if (funExpr instanceof GrReferenceExpression && (qualifier = ((GrReferenceExpression)funExpr).getQualifierExpression()) != null) break;
                closure = (GrClosableBlock)PsiTreeUtil.getParentOfType((PsiElement)closure, GrClosableBlock.class);
            }
        }
        return qualifier;
    }

    public static void removeVariable(GrVariable variable) {
        GrVariableDeclaration varDecl = (GrVariableDeclaration)variable.getParent();
        List<GrVariable> variables = Arrays.asList(varDecl.getVariables());
        if (!variables.contains(variable)) {
            throw new IllegalArgumentException();
        }
        ASTNode varDeclNode = varDecl.getNode();
        PsiElement parent = varDecl.getParent();
        ASTNode owner = parent.getNode();
        if (variables.size() == 1 && owner != null) {
            PsiElement next = varDecl.getNextSibling();
            while (next != null && next.getNode() != null && next.getNode().getElementType() == GroovyTokenTypes.mSEMI) {
                PsiElement tmpNext = next.getNextSibling();
                owner.removeChild(next.getNode());
                next = tmpNext;
            }
            PsiImplUtil.removeNewLineAfter(varDecl);
            owner.removeChild(varDeclNode);
            PsiUtil.reformatCode(parent);
            return;
        }
        ASTNode varNode = variable.getNode();
        if (varNode != null) {
            varDeclNode.removeChild(varNode);
        }
        PsiUtil.reformatCode(varDecl);
    }

    @Nullable
    public static PsiElement realPrevious(PsiElement previousLeaf) {
        while (previousLeaf != null && (previousLeaf instanceof PsiWhiteSpace || previousLeaf instanceof PsiComment || previousLeaf instanceof PsiErrorElement)) {
            previousLeaf = previousLeaf.getPrevSibling();
        }
        return previousLeaf;
    }

    private static int getExprPriorityLevel(GrExpression expr) {
        int priority = 0;
        if (expr instanceof GrPostfixExpression) {
            priority = 5;
        }
        if (expr instanceof GrUnaryExpression || expr instanceof GrTypeCastExpression) {
            priority = 6;
        }
        if (expr instanceof GrPowerExpressionImpl) {
            priority = 7;
        }
        if (expr instanceof GrMultiplicativeExpressionImpl) {
            priority = 8;
        }
        if (expr instanceof GrAdditiveExpressionImpl) {
            priority = 9;
        }
        if (expr instanceof GrShiftExpressionImpl) {
            priority = 10;
        }
        if (expr instanceof GrRangeExpressionImpl) {
            priority = 11;
        }
        if (expr instanceof GrRelationalExpression) {
            priority = 12;
        }
        if (expr instanceof GrEqualityExpressionImpl) {
            priority = 13;
        }
        if (expr instanceof GrRegexExpressionImpl) {
            priority = 14;
        }
        if (expr instanceof GrAndExpressionImpl) {
            priority = 15;
        }
        if (expr instanceof GrExclusiveOrExpressionImpl) {
            priority = 16;
        }
        if (expr instanceof GrInclusiveOrExpressionImpl) {
            priority = 17;
        }
        if (expr instanceof GrLogicalAndExpressionImpl) {
            priority = 18;
        }
        if (expr instanceof GrLogicalOrExpressionImpl) {
            priority = 19;
        }
        if (expr instanceof GrConditionalExpression) {
            priority = 20;
        }
        if (expr instanceof GrSafeCastExpression) {
            priority = 21;
        }
        if (expr instanceof GrAssignmentExpression) {
            priority = 22;
        }
        if (expr instanceof GrApplicationStatement) {
            priority = 23;
        }
        return -priority;
    }

    public static void setName(String name, PsiElement nameElement) {
        ASTNode node = nameElement.getNode();
        ASTNode newNameNode = GroovyPsiElementFactory.getInstance(nameElement.getProject()).createReferenceNameFromText(name).getNode();
        assert (newNameNode != null && node != null);
        node.getTreeParent().replaceChild(node, newNameNode);
    }

    public static boolean isExtendsSignature(MethodSignature superSignatureCandidate, MethodSignature subSignature) {
        return MethodSignatureUtil.isSubsignature((MethodSignature)superSignatureCandidate, (MethodSignature)subSignature);
    }

    @Nullable
    public static PsiElement getOriginalElement(PsiClass clazz, PsiFile containingFile) {
        VirtualFile vFile = containingFile.getVirtualFile();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)clazz.getProject());
        final ProjectFileIndex idx = ProjectRootManager.getInstance((Project)facade.getProject()).getFileIndex();
        if (vFile == null || !idx.isInLibrarySource(vFile)) {
            return clazz;
        }
        String qName = clazz.getQualifiedName();
        if (qName == null) {
            return null;
        }
        final List orderEntries = idx.getOrderEntriesForFile(vFile);
        PsiClass original = facade.findClass(qName, new GlobalSearchScope(facade.getProject()){

            public int compare(VirtualFile file1, VirtualFile file2) {
                return 0;
            }

            public boolean contains(VirtualFile file) {
                List entries = idx.getOrderEntriesForFile(file);
                for (int i = 0; i < entries.size(); ++i) {
                    OrderEntry entry = (OrderEntry)entries.get(i);
                    if (!orderEntries.contains(entry)) continue;
                    return true;
                }
                return false;
            }

            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                if (aModule == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/PsiImplUtil$1.isSearchInModuleContent must not be null");
                }
                return false;
            }

            public boolean isSearchInLibraries() {
                return true;
            }
        });
        return original != null ? original : clazz;
    }

    @Nullable
    public static PsiMethod extractUniqueElement(@NotNull GroovyResolveResult[] results) {
        if (results == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/PsiImplUtil.extractUniqueElement must not be null");
        }
        if (results.length != 1) {
            return null;
        }
        PsiElement element = results[0].getElement();
        return element instanceof PsiMethod ? (PsiMethod)element : null;
    }

    public static GroovyResolveResult extractUniqueResult(@NotNull GroovyResolveResult[] results) {
        if (results == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/PsiImplUtil.extractUniqueResult must not be null");
        }
        if (results.length != 1) {
            return GroovyResolveResult.EMPTY_RESULT;
        }
        return results[0];
    }

    public static PsiMethod[] mapToMethods(@Nullable List<CandidateInfo> list) {
        if (list == null) {
            return PsiMethod.EMPTY_ARRAY;
        }
        PsiMethod[] result = new PsiMethod[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = (PsiMethod)list.get(i).getElement();
        }
        return result;
    }

    public static String getName(GrNamedElement namedElement) {
        PsiElement nameElement = namedElement.getNameIdentifierGroovy();
        ASTNode node = nameElement.getNode();
        LOG.assertTrue(node != null);
        if (node.getElementType() == GroovyTokenTypes.mIDENT) {
            return nameElement.getText();
        }
        if (node.getElementType() == GroovyTokenTypes.mSTRING_LITERAL) {
            String text = nameElement.getText();
            return text.endsWith("'") ? text.substring(1, text.length() - 1) : text.substring(1);
        }
        LOG.assertTrue(node.getElementType() == GroovyTokenTypes.mGSTRING_LITERAL);
        String text = nameElement.getText();
        return text.endsWith("\"") ? text.substring(1, text.length() - 1) : text.substring(1);
    }

    public static void removeNewLineAfter(@NotNull GrStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/PsiImplUtil.removeNewLineAfter must not be null");
        }
        ASTNode parentNode = statement.getParent().getNode();
        ASTNode next = statement.getNode().getTreeNext();
        if (parentNode != null && next != null && GroovyTokenTypes.mNLS == next.getElementType()) {
            parentNode.removeChild(next);
        }
    }

    public static boolean isMainMethod(GrMethod method) {
        return method.getName().equals(MAIN_METHOD) && method.hasModifierProperty("static");
    }
}

