/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.dataFlow.types;

import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.HashMap;
import java.util.Arrays;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrInstanceOfExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.AssertionInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReadWriteVariableInstruction;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DfaInstance;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrTupleType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.TypeInferenceHelper;

public class TypeDfaInstance
implements DfaInstance<Map<String, PsiType>> {
    @Override
    public void fun(Map<String, PsiType> map, Instruction instruction) {
        AssertionInstruction assertionInstruction;
        PsiElement element;
        Computable<PsiType> computation;
        PsiElement element2;
        if (instruction instanceof ReadWriteVariableInstruction && ((ReadWriteVariableInstruction)instruction).isWrite() && (element2 = instruction.getElement()) != null && (computation = TypeDfaInstance.getInitializerTypeComputation(element2)) != null) {
            TypeInferenceHelper helper = GroovyPsiManager.getInstance(element2.getProject()).getTypeInferenceHelper();
            PsiType type = helper.doInference(computation, map);
            map.put(((ReadWriteVariableInstruction)instruction).getVariableName(), type);
        }
        if (instruction instanceof AssertionInstruction && (element = (assertionInstruction = (AssertionInstruction)instruction).getElement()) instanceof GrInstanceOfExpression && !assertionInstruction.isNegate()) {
            GrExpression operand = ((GrInstanceOfExpression)element).getOperand();
            GrTypeElement typeElement = ((GrInstanceOfExpression)element).getTypeElement();
            if (typeElement != null) {
                map.put(operand.getText(), typeElement.getType());
            }
        }
    }

    @Nullable
    private static Computable<PsiType> getInitializerTypeComputation(final PsiElement element) {
        if (element instanceof GrReferenceExpression && ((GrReferenceExpression)element).getQualifierExpression() == null) {
            GrListOrMap list;
            PsiElement parent = element.getParent();
            if (parent instanceof GrAssignmentExpression) {
                final GrExpression initializer = ((GrAssignmentExpression)parent).getRValue();
                if (initializer != null) {
                    return new Computable<PsiType>(){

                        @Nullable
                        public PsiType compute() {
                            return initializer.getType();
                        }
                    };
                }
                return null;
            }
            if (parent instanceof GrListOrMap && (list = (GrListOrMap)parent).getParent() instanceof GrAssignmentExpression) {
                GrExpression rValue = ((GrAssignmentExpression)list.getParent()).getRValue();
                int idx = Arrays.asList(list.getInitializers()).indexOf(element);
                if (idx >= 0 && rValue != null) {
                    return TypeDfaInstance.getMultipleAssignmentTypeComputation(rValue, idx);
                }
            }
            return null;
        }
        if (element instanceof GrVariable) {
            return new Computable<PsiType>(){

                @Nullable
                public PsiType compute() {
                    GrExpression initializer;
                    GrVariable variable = (GrVariable)element;
                    if (!(variable instanceof GrParameter) && (initializer = variable.getInitializerGroovy()) != null) {
                        return initializer.getType();
                    }
                    return variable.getTypeGroovy();
                }
            };
        }
        return null;
    }

    private static Computable<PsiType> getMultipleAssignmentTypeComputation(final GrExpression rValue, final int idx) {
        return new Computable<PsiType>(){

            @Nullable
            public PsiType compute() {
                PsiType rType = rValue.getType();
                if (rType instanceof GrTupleType) {
                    PsiType[] componentTypes = ((GrTupleType)rType).getComponentTypes();
                    if (idx < componentTypes.length) {
                        return componentTypes[idx];
                    }
                    return null;
                }
                return PsiUtil.extractIterableTypeParameter((PsiType)rType, (boolean)false);
            }
        };
    }

    @Override
    @NotNull
    public Map<String, PsiType> initial() {
        HashMap hashMap = new HashMap();
        if (hashMap == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/dataFlow/types/TypeDfaInstance.initial must not return null");
        }
        return hashMap;
    }

    @Override
    public boolean isForward() {
        return true;
    }
}

