/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.controlFlow;

import com.intellij.openapi.diagnostic.Logger;
import gnu.trove.TIntHashSet;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReadWriteVariableInstruction;

public class ControlFlowUtil {
    private static final Logger LOG = Logger.getInstance((String)"org.jetbrains.plugins.groovy.lang.psi.controlFlow.ControlFlowUtil");

    public static int[] postorder(Instruction[] flow) {
        int[] result = new int[flow.length];
        boolean[] visited = new boolean[flow.length];
        for (int i = 0; i < result.length; ++i) {
            visited[i] = false;
        }
        int N = flow.length;
        for (int i = 0; i < flow.length; ++i) {
            if (visited[i]) continue;
            N = ControlFlowUtil.doVisitForPostorder(flow[i], N, result, visited);
        }
        LOG.assertTrue(N == 0);
        return result;
    }

    private static int doVisitForPostorder(Instruction curr, int currN, int[] postorder, boolean[] visited) {
        visited[curr.num()] = true;
        for (Instruction instruction : curr.allSucc()) {
            if (visited[instruction.num()]) continue;
            currN = ControlFlowUtil.doVisitForPostorder(instruction, currN, postorder, visited);
        }
        postorder[curr.num()] = --currN;
        return currN;
    }

    public static ReadWriteVariableInstruction[] getReadsWithoutPriorWrites(Instruction[] flow) {
        ArrayList<ReadWriteVariableInstruction> result = new ArrayList<ReadWriteVariableInstruction>();
        TObjectIntHashMap<String> namesIndex = ControlFlowUtil.buildNamesIndex(flow);
        TIntHashSet[] definitelyAssigned = new TIntHashSet[flow.length];
        int[] postorder = ControlFlowUtil.postorder(flow);
        int[] invpostorder = ControlFlowUtil.invPostorder(postorder);
        ControlFlowUtil.findReadsBeforeWrites(flow, definitelyAssigned, result, namesIndex, postorder, invpostorder);
        return result.toArray(new ReadWriteVariableInstruction[result.size()]);
    }

    private static int[] invPostorder(int[] postorder) {
        int[] result = new int[postorder.length];
        for (int i = 0; i < postorder.length; ++i) {
            result[postorder[i]] = i;
        }
        return result;
    }

    private static TObjectIntHashMap<String> buildNamesIndex(Instruction[] flow) {
        TObjectIntHashMap namesIndex = new TObjectIntHashMap();
        int idx = 0;
        for (Instruction instruction : flow) {
            String name;
            if (!(instruction instanceof ReadWriteVariableInstruction) || namesIndex.contains((Object)(name = ((ReadWriteVariableInstruction)instruction).getVariableName()))) continue;
            namesIndex.put((Object)name, idx++);
        }
        return namesIndex;
    }

    private static void findReadsBeforeWrites(Instruction[] flow, TIntHashSet[] definitelyAssigned, List<ReadWriteVariableInstruction> result, TObjectIntHashMap<String> namesIndex, int[] postorder, int[] invpostorder) {
        int start = 0;
        while (invpostorder[start] != 0) {
            ++start;
        }
        for (int i = start; i < flow.length; ++i) {
            int j = invpostorder[i];
            Instruction curr = flow[j];
            if (curr instanceof ReadWriteVariableInstruction) {
                ReadWriteVariableInstruction readWriteInsn = (ReadWriteVariableInstruction)curr;
                int n = namesIndex.get((Object)readWriteInsn.getVariableName());
                TIntHashSet vars = definitelyAssigned[j];
                if (!readWriteInsn.isWrite()) {
                    if (vars == null || !vars.contains(n)) {
                        result.add(readWriteInsn);
                    }
                } else {
                    if (vars == null) {
                        definitelyAssigned[j] = vars = new TIntHashSet();
                    }
                    vars.add(n);
                }
            }
            for (Instruction instruction : curr.allSucc()) {
                if (postorder[instruction.num()] <= postorder[curr.num()]) continue;
                TIntHashSet currDefinitelyAssigned = definitelyAssigned[curr.num()];
                TIntHashSet succDefinitelyAssigned = definitelyAssigned[instruction.num()];
                if (currDefinitelyAssigned != null) {
                    int[] currArray = currDefinitelyAssigned.toArray();
                    if (succDefinitelyAssigned == null) {
                        succDefinitelyAssigned = new TIntHashSet();
                        succDefinitelyAssigned.addAll(currArray);
                        definitelyAssigned[instruction.num()] = succDefinitelyAssigned;
                        continue;
                    }
                    succDefinitelyAssigned.retainAll(currArray);
                    continue;
                }
                if (succDefinitelyAssigned != null) {
                    succDefinitelyAssigned.clear();
                    continue;
                }
                definitelyAssigned[instruction.num()] = succDefinitelyAssigned = new TIntHashSet();
            }
        }
    }
}

