/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.editor.actions;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.editor.HandlerUtils;
import org.jetbrains.plugins.groovy.lang.editor.actions.GroovyEditorActionUtil;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;

public class GroovyEnterHandler
implements EnterHandlerDelegate {
    private static final TokenSet AFTER_DOLLAR = TokenSet.create((IElementType[])new IElementType[]{GroovyTokenTypes.mLCURLY, GroovyTokenTypes.mIDENT, GroovyTokenTypes.mGSTRING_CONTENT, GroovyTokenTypes.mDOLLAR, GroovyTokenTypes.mGSTRING_END});
    private static final TokenSet ALL_STRINGS = TokenSet.create((IElementType[])new IElementType[]{GroovyTokenTypes.mSTRING_LITERAL, GroovyTokenTypes.mGSTRING_LITERAL, GroovyTokenTypes.mGSTRING_BEGIN, GroovyTokenTypes.mGSTRING_END, GroovyTokenTypes.mGSTRING_CONTENT, GroovyTokenTypes.mRCURLY, GroovyTokenTypes.mIDENT, GroovyTokenTypes.mDOLLAR});
    private static final TokenSet BEFORE_DOLLAR = TokenSet.create((IElementType[])new IElementType[]{GroovyTokenTypes.mGSTRING_BEGIN, GroovyTokenTypes.mGSTRING_CONTENT});
    private static final TokenSet EXPR_END = TokenSet.create((IElementType[])new IElementType[]{GroovyTokenTypes.mRCURLY, GroovyTokenTypes.mIDENT});
    private static final TokenSet AFTER_EXPR_END = TokenSet.create((IElementType[])new IElementType[]{GroovyTokenTypes.mGSTRING_END, GroovyTokenTypes.mGSTRING_CONTENT, GroovyTokenTypes.mDOLLAR});
    private static final TokenSet STRING_END = TokenSet.create((IElementType[])new IElementType[]{GroovyTokenTypes.mSTRING_LITERAL, GroovyTokenTypes.mGSTRING_LITERAL, GroovyTokenTypes.mGSTRING_END});

    public EnterHandlerDelegate.Result preprocessEnter(PsiFile file, Editor editor, Ref<Integer> caretOffset, Ref<Integer> caretAdvance, DataContext dataContext, EditorActionHandler originalHandler) {
        String text = editor.getDocument().getText();
        if (StringUtil.isEmpty((String)text)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        int caret = editor.getCaretModel().getOffset();
        EditorHighlighter highlighter = ((EditorEx)editor).getHighlighter();
        if (caret >= 1 && caret < text.length() && CodeInsightSettings.getInstance().SMART_INDENT_ON_ENTER) {
            boolean afterArrow;
            HighlighterIterator iterator = highlighter.createIterator(caret);
            iterator.retreat();
            while (!iterator.atEnd() && GroovyTokenTypes.mWS == iterator.getTokenType()) {
                iterator.retreat();
            }
            boolean bl = afterArrow = !iterator.atEnd() && iterator.getTokenType() == GroovyTokenTypes.mCLOSABLE_BLOCK_OP;
            if (afterArrow) {
                originalHandler.execute(editor, dataContext);
                PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(editor.getDocument());
                CodeStyleManager.getInstance((Project)file.getProject()).adjustLineIndent(file, editor.getCaretModel().getOffset());
            }
            iterator = highlighter.createIterator(editor.getCaretModel().getOffset());
            while (!iterator.atEnd() && GroovyTokenTypes.mWS == iterator.getTokenType()) {
                iterator.advance();
            }
            if (!iterator.atEnd() && GroovyTokenTypes.mRCURLY == iterator.getTokenType()) {
                PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(editor.getDocument());
                PsiElement element = file.findElementAt(iterator.getStart());
                if (element != null && element.getNode().getElementType() == GroovyTokenTypes.mRCURLY && element.getParent() instanceof GrClosableBlock && text.length() > caret) {
                    return EnterHandlerDelegate.Result.DefaultForceIndent;
                }
            }
            if (afterArrow) {
                return EnterHandlerDelegate.Result.Stop;
            }
        }
        if (GroovyEnterHandler.handleEnter(editor, dataContext, file.getProject(), originalHandler, file)) {
            return EnterHandlerDelegate.Result.Stop;
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    protected static boolean handleEnter(Editor editor, DataContext dataContext, @NotNull Project project, EditorActionHandler originalHandler, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/editor/actions/GroovyEnterHandler.handleEnter must not be null");
        }
        if (HandlerUtils.isReadOnly(editor)) {
            return false;
        }
        int caretOffset = editor.getCaretModel().getOffset();
        if (caretOffset < 1) {
            return false;
        }
        if (GroovyEnterHandler.handleBetweenSquareBraces(editor, caretOffset, dataContext, project, originalHandler)) {
            return true;
        }
        return GroovyEnterHandler.handleInString(editor, caretOffset, dataContext, originalHandler);
    }

    private static boolean handleBetweenSquareBraces(Editor editor, int caret, DataContext context, Project project, EditorActionHandler originalHandler) {
        String text = editor.getDocument().getText();
        if (text == null || text.length() == 0) {
            return false;
        }
        EditorHighlighter highlighter = ((EditorEx)editor).getHighlighter();
        if (caret < 1 || caret > text.length() - 1) {
            return false;
        }
        HighlighterIterator iterator = highlighter.createIterator(caret - 1);
        if (GroovyTokenTypes.mLBRACK == iterator.getTokenType() && text.length() > caret && GroovyTokenTypes.mRBRACK == (iterator = highlighter.createIterator(caret)).getTokenType()) {
            originalHandler.execute(editor, context);
            originalHandler.execute(editor, context);
            editor.getCaretModel().moveCaretRelatively(0, -1, false, false, true);
            GroovyEditorActionUtil.insertSpacesByGroovyContinuationIndent(editor, project);
            return true;
        }
        return false;
    }

    private static boolean handleInString(Editor editor, int caretOffset, DataContext dataContext, EditorActionHandler originalHandler) {
        Project project = (Project)DataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return false;
        }
        PsiFile file = PsiManager.getInstance((Project)project).findFile(FileDocumentManager.getInstance().getFile(editor.getDocument()));
        Document document = editor.getDocument();
        String fileText = document.getText();
        if (fileText.length() == caretOffset) {
            return false;
        }
        if (!GroovyEnterHandler.checkStringApplicable(editor, caretOffset)) {
            return false;
        }
        if (file == null) {
            return false;
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        PsiElement stringElement = file.findElementAt(caretOffset - 1);
        if (stringElement == null) {
            return false;
        }
        ASTNode node = stringElement.getNode();
        if (node == null) {
            return false;
        }
        if (GroovyTokenTypes.mSTRING_LITERAL == node.getElementType()) {
            if (GroovyEditorActionUtil.isPlainStringLiteral(node)) {
                String text = node.getText();
                String innerText = text.equals("''") ? "" : text.substring(1, text.length() - 1);
                TextRange literalRange = stringElement.getTextRange();
                document.replaceString(literalRange.getStartOffset(), literalRange.getEndOffset(), (CharSequence)("'''" + innerText + "'''"));
                editor.getCaretModel().moveToOffset(caretOffset + 2);
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"\n");
            } else {
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"\n");
            }
            return true;
        }
        if (!GroovyEditorActionUtil.GSTRING_TOKENS.contains(node.getElementType()) && GroovyEnterHandler.checkGStringInnerExpression(stringElement)) {
            if ((stringElement = stringElement.getParent().getParent().getNextSibling()) == null) {
                return false;
            }
            node = stringElement.getNode();
            if (node == null) {
                return false;
            }
        }
        if (GroovyEditorActionUtil.GSTRING_TOKENS.contains(node.getElementType())) {
            PsiElement parent;
            if (node.getElementType() == GroovyTokenTypes.mGSTRING_LITERAL) {
                parent = stringElement;
            } else {
                for (parent = stringElement.getParent(); parent != null && !(parent instanceof GrLiteral); parent = parent.getParent()) {
                }
            }
            if (parent == null || parent.getLastChild() instanceof PsiErrorElement) {
                return false;
            }
            if (GroovyEditorActionUtil.isPlainGString(parent.getNode())) {
                String text;
                boolean rightFromDollar;
                PsiElement exprSibling = stringElement.getNextSibling();
                boolean bl = rightFromDollar = exprSibling instanceof GrExpression && exprSibling.getTextRange().getStartOffset() == caretOffset;
                if (rightFromDollar) {
                    --caretOffset;
                }
                String innerText = (text = parent.getText()).equals("\"\"") ? "" : text.substring(1, text.length() - 1);
                TextRange parentRange = parent.getTextRange();
                document.replaceString(parentRange.getStartOffset(), parentRange.getEndOffset(), (CharSequence)("\"\"\"" + innerText + "\"\"\""));
                editor.getCaretModel().moveToOffset(caretOffset + 2);
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"\n");
                if (rightFromDollar) {
                    editor.getCaretModel().moveCaretRelatively(1, 0, false, false, true);
                }
            } else {
                originalHandler.execute(editor, dataContext);
            }
            return true;
        }
        return false;
    }

    private static boolean checkStringApplicable(Editor editor, int caret) {
        EditorHighlighter highlighter = ((EditorEx)editor).getHighlighter();
        HighlighterIterator iteratorLeft = highlighter.createIterator(caret - 1);
        HighlighterIterator iteratorRight = highlighter.createIterator(caret);
        if (iteratorLeft != null && !ALL_STRINGS.contains(iteratorLeft.getTokenType())) {
            return false;
        }
        if (iteratorLeft != null && BEFORE_DOLLAR.contains(iteratorLeft.getTokenType()) && iteratorRight != null && !AFTER_DOLLAR.contains(iteratorRight.getTokenType())) {
            return false;
        }
        if (iteratorLeft != null && EXPR_END.contains(iteratorLeft.getTokenType()) && iteratorRight != null && !AFTER_EXPR_END.contains(iteratorRight.getTokenType())) {
            return false;
        }
        return iteratorLeft == null || !STRING_END.contains(iteratorLeft.getTokenType()) || iteratorRight == null || STRING_END.contains(iteratorRight.getTokenType());
    }

    private static boolean checkGStringInnerExpression(PsiElement element) {
        if (element != null && (element.getParent() instanceof GrReferenceExpression || element.getParent() instanceof GrClosableBlock)) {
            PsiElement parent = element.getParent().getParent();
            if (!(parent instanceof GrStringInjection)) {
                return false;
            }
            PsiElement nextSibling = parent.getNextSibling();
            if (nextSibling == null) {
                return false;
            }
            return GroovyEditorActionUtil.GSTRING_TOKENS_INNER.contains(nextSibling.getNode().getElementType());
        }
        return false;
    }
}

