/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.editor;

import com.intellij.lang.ImportOptimizer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.HashSet;
import gnu.trove.TObjectIntHashMap;
import gnu.trove.TObjectIntProcedure;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyImportOptimizer
implements ImportOptimizer {
    private static final Logger LOG = Logger.getInstance((String)"org.jetbrains.plugins.groovy.lang.editor.GroovyImportOptimizer");
    private static final Comparator<GrImportStatement> IMPORT_STATEMENT_COMPARATOR = new Comparator<GrImportStatement>(){

        @Override
        public int compare(GrImportStatement statement1, GrImportStatement statement2) {
            String name2;
            GrCodeReferenceElement ref1 = statement1.getImportReference();
            GrCodeReferenceElement ref2 = statement2.getImportReference();
            String name1 = ref1 != null ? PsiUtil.getQualifiedReferenceText(ref1) : null;
            String string = name2 = ref2 != null ? PsiUtil.getQualifiedReferenceText(ref2) : null;
            if (name1 == null) {
                return name2 == null ? 0 : -1;
            }
            if (name2 == null) {
                return 1;
            }
            return name1.compareTo(name2);
        }
    };

    @NotNull
    public Runnable processFile(PsiFile file) {
        MyProcessor myProcessor = new MyProcessor((GroovyFile)file, false);
        if (myProcessor == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/editor/GroovyImportOptimizer.processFile must not return null");
        }
        return myProcessor;
    }

    public void removeUnusedImports(GroovyFile file) {
        new MyProcessor(file, true).run();
    }

    public boolean supports(PsiFile file) {
        return file instanceof GroovyFile;
    }

    private class MyProcessor
    implements Runnable {
        private final GroovyFile myFile;
        private final boolean myRemoveUnusedOnly;

        private MyProcessor(GroovyFile file, boolean removeUnusedOnly) {
            this.myFile = file;
            this.myRemoveUnusedOnly = removeUnusedOnly;
        }

        @Override
        public void run() {
            if (!ProjectRootManager.getInstance((Project)this.myFile.getProject()).getFileIndex().isInSource(this.myFile.getVirtualFile())) {
                return;
            }
            LinkedHashSet<String> importedClasses = new LinkedHashSet<String>();
            LinkedHashSet<String> staticallyImportedMembers = new LinkedHashSet<String>();
            HashSet usedImports = new HashSet();
            LinkedHashSet<String> implicitlyImported = new LinkedHashSet<String>();
            this.myFile.accept(new GroovyRecursiveElementVisitor((Set)usedImports, staticallyImportedMembers, importedClasses, implicitlyImported){
                final /* synthetic */ Set val$usedImports;
                final /* synthetic */ Set val$staticallyImportedMembers;
                final /* synthetic */ Set val$importedClasses;
                final /* synthetic */ Set val$implicitlyImported;
                {
                    this.val$usedImports = set;
                    this.val$staticallyImportedMembers = set2;
                    this.val$importedClasses = set3;
                    this.val$implicitlyImported = set4;
                }

                @Override
                public void visitCodeReferenceElement(GrCodeReferenceElement refElement) {
                    this.visitRefElement(refElement);
                    super.visitCodeReferenceElement(refElement);
                }

                @Override
                public void visitReferenceExpression(GrReferenceExpression referenceExpression) {
                    this.visitRefElement(referenceExpression);
                    super.visitReferenceExpression(referenceExpression);
                }

                private void visitRefElement(GrReferenceElement refElement) {
                    GroovyResolveResult[] resolveResults;
                    for (GroovyResolveResult resolveResult : resolveResults = refElement.multiResolve(false)) {
                        String qname;
                        GroovyPsiElement context = resolveResult.getCurrentFileResolveContext();
                        PsiElement element = resolveResult.getElement();
                        if (element == null) {
                            return;
                        }
                        if (context instanceof GrImportStatement) {
                            GrImportStatement importStatement = (GrImportStatement)context;
                            this.val$usedImports.add(importStatement);
                            if (importStatement.isAliasedImport()) continue;
                            String importedName = null;
                            if (importStatement.isOnDemand()) {
                                if (importStatement.isStatic()) {
                                    String name;
                                    String classQName;
                                    PsiMember member;
                                    PsiClass clazz;
                                    if (element instanceof PsiMember && (clazz = (member = (PsiMember)element).getContainingClass()) != null && (classQName = clazz.getQualifiedName()) != null && (name = member.getName()) != null) {
                                        importedName = classQName + "." + name;
                                    }
                                } else {
                                    importedName = MyProcessor.this.getTargetQualifiedName(element);
                                }
                            } else {
                                GrCodeReferenceElement importReference = importStatement.getImportReference();
                                if (importReference != null) {
                                    importedName = PsiUtil.getQualifiedReferenceText(importReference);
                                }
                            }
                            if (importedName == null) {
                                return;
                            }
                            if (importStatement.isStatic()) {
                                this.val$staticallyImportedMembers.add(importedName);
                                continue;
                            }
                            this.val$importedClasses.add(importedName);
                            continue;
                        }
                        if (context != null || refElement.getParent() instanceof GrImportStatement || refElement.getQualifier() != null || (qname = MyProcessor.this.getTargetQualifiedName(element)) == null) continue;
                        this.val$implicitlyImported.add(qname);
                        this.val$importedClasses.add(qname);
                    }
                }
            });
            ArrayList<GrImportStatement> oldImports = new ArrayList<GrImportStatement>();
            for (GrImportStatement statement : this.myFile.getImportStatements()) {
                GrCodeReferenceElement reference = statement.getImportReference();
                if (reference == null || reference.getCanonicalText() == null) continue;
                oldImports.add(statement);
            }
            if (this.myRemoveUnusedOnly) {
                for (GrImportStatement oldImport : oldImports) {
                    if (usedImports.contains(oldImport)) continue;
                    this.myFile.removeImport(oldImport);
                }
                return;
            }
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.myFile.getProject());
            ArrayList<GrImportStatement> aliased = new ArrayList<GrImportStatement>();
            for (GrImportStatement oldImport : oldImports) {
                if (!oldImport.isAliasedImport() || !usedImports.contains(oldImport)) continue;
                aliased.add(factory.createImportStatementFromText(oldImport.getText()));
            }
            GrImportStatement[] newImports = this.prepare(importedClasses, staticallyImportedMembers, implicitlyImported);
            for (GrImportStatement aliasedImport : aliased) {
                this.myFile.addImport(aliasedImport);
            }
            for (GrImportStatement newImport : newImports) {
                this.myFile.addImport(newImport);
            }
            this.myFile.removeImport(this.myFile.addImport(factory.createImportStatementFromText("import xxxx")));
            for (GrImportStatement importStatement : oldImports) {
                this.myFile.removeImport(importStatement);
            }
        }

        @Nullable
        private String getTargetQualifiedName(PsiElement element) {
            if (element instanceof PsiClass) {
                return ((PsiClass)element).getQualifiedName();
            }
            if (element instanceof PsiMethod && ((PsiMethod)element).isConstructor()) {
                return ((PsiMethod)element).getContainingClass().getQualifiedName();
            }
            return null;
        }

        private GrImportStatement[] prepare(Set<String> importedClasses, Set<String> staticallyImportedMembers, Set<String> implicitlyImported) {
            Project project = this.myFile.getProject();
            final CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)project);
            final GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(project);
            TObjectIntHashMap packageCountMap = new TObjectIntHashMap();
            TObjectIntHashMap classCountMap = new TObjectIntHashMap();
            for (String importedClass : importedClasses) {
                if (implicitlyImported.contains(importedClass)) continue;
                String packageName = StringUtil.getPackageName((String)importedClass);
                if (!packageCountMap.containsKey((Object)packageName)) {
                    packageCountMap.put((Object)packageName, 0);
                }
                packageCountMap.increment((Object)packageName);
            }
            for (String importedMember : staticallyImportedMembers) {
                String className = StringUtil.getPackageName((String)importedMember);
                if (!classCountMap.containsKey((Object)className)) {
                    classCountMap.put((Object)className, 0);
                }
                classCountMap.increment((Object)className);
            }
            HashSet onDemandImportedSimpleClassNames = new HashSet();
            final ArrayList<GrImportStatement> result = new ArrayList<GrImportStatement>();
            packageCountMap.forEachEntry((TObjectIntProcedure)new TObjectIntProcedure<String>((Set)onDemandImportedSimpleClassNames){
                final /* synthetic */ Set val$onDemandImportedSimpleClassNames;
                {
                    this.val$onDemandImportedSimpleClassNames = set;
                }

                public boolean execute(String s, int i) {
                    if (i >= settings.CLASS_COUNT_TO_USE_IMPORT_ON_DEMAND) {
                        result.add(factory.createImportStatementFromText(s, false, true, null));
                        PsiPackage aPackage = JavaPsiFacade.getInstance((Project)MyProcessor.this.myFile.getProject()).findPackage(s);
                        if (aPackage != null) {
                            for (PsiClass clazz : aPackage.getClasses(MyProcessor.this.myFile.getResolveScope())) {
                                this.val$onDemandImportedSimpleClassNames.add(clazz.getName());
                            }
                        }
                    }
                    return true;
                }
            });
            classCountMap.forEachEntry((TObjectIntProcedure)new TObjectIntProcedure<String>(){

                public boolean execute(String s, int i) {
                    if (i >= settings.NAMES_COUNT_TO_USE_IMPORT_ON_DEMAND) {
                        result.add(factory.createImportStatementFromText(s, true, true, null));
                    }
                    return true;
                }
            });
            ArrayList explicated = CollectionFactory.arrayList();
            for (String importedClass : importedClasses) {
                String parentName = StringUtil.getPackageName((String)importedClass);
                if (packageCountMap.get((Object)parentName) >= settings.CLASS_COUNT_TO_USE_IMPORT_ON_DEMAND || implicitlyImported.contains(importedClass) && !onDemandImportedSimpleClassNames.contains(StringUtil.getShortName((String)importedClass))) continue;
                explicated.add(factory.createImportStatementFromText(importedClass, false, false, null));
            }
            for (String importedMember : staticallyImportedMembers) {
                String className = StringUtil.getPackageName((String)importedMember);
                if (classCountMap.get((Object)className) >= settings.NAMES_COUNT_TO_USE_IMPORT_ON_DEMAND) continue;
                result.add(factory.createImportStatementFromText(importedMember, true, false, null));
            }
            Collections.sort(result, IMPORT_STATEMENT_COMPARATOR);
            Collections.sort(explicated, IMPORT_STATEMENT_COMPARATOR);
            explicated.addAll(result);
            return explicated.toArray(new GrImportStatement[explicated.size()]);
        }
    }
}

