/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion.filters.types;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.filters.ElementFilter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;

public class BuiltInTypeAsArgumentFilter
implements ElementFilter {
    public boolean isAcceptable(Object element, PsiElement context) {
        PsiElement previous = PsiImplUtil.realPrevious(context.getParent().getPrevSibling());
        if (context.getParent() instanceof GrReferenceElement && context.getParent().getParent() instanceof GrArgumentList) {
            PsiElement prevSibling = context.getPrevSibling();
            if (context.getParent() instanceof GrReferenceElement && prevSibling != null && prevSibling.getNode() != null) {
                ASTNode node = prevSibling.getNode();
                return !GroovyTokenTypes.DOTS.contains(node.getElementType());
            }
            return previous == null || !GroovyTokenTypes.mAT.equals(previous.getNode().getElementType());
        }
        return false;
    }

    public boolean isClassAcceptable(Class hintClass) {
        return true;
    }

    @NonNls
    public String toString() {
        return "built-in-types as arguments filter";
    }
}

