/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.style.parameterToEntry;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.intentions.GroovyIntentionsBundle;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.intentions.style.parameterToEntry.GroovyMapParameterDialog;
import org.jetbrains.plugins.groovy.lang.psi.GrNamedElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrParametersOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef.members.GrMethodImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.refactoring.GroovyValidationUtil;

public class ConvertParameterToMapEntryIntention
extends Intention {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.intentions.style.ConvertParameterToMapEntryIntention");
    @NonNls
    private static final String CLOSURE_CAPTION = "closure";
    @NonNls
    private static final String CLOSURE_CAPTION_CAP = "Closure";
    @NonNls
    private static final String METHOD_CAPTION = "method";
    @NonNls
    private static final String METHOD_CAPTION_CAP = "Method";
    @NonNls
    private static final String REFACTORING_NAME = "Convert Parameter to Map Entry";
    @NonNls
    private static final String MAP_TYPE_TEXT = "Map";
    @NonNls
    private static final String[] MY_POSSIBLE_NAMES = new String[]{"attrs", "args", "params", "map"};

    @Override
    protected void processIntention(final @NotNull PsiElement element) throws IncorrectOperationException {
        ArrayList<PsiElement> occurrences;
        GrParametersOwner owner;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/intentions/style/parameterToEntry/ConvertParameterToMapEntryIntention.processIntention must not be null");
        }
        final Project project = element.getProject();
        boolean success = ConvertParameterToMapEntryIntention.collectOwnerOccurrences(project, owner = (GrParametersOwner)PsiTreeUtil.getParentOfType((PsiElement)element, GrParametersOwner.class), occurrences = new ArrayList<PsiElement>());
        if (!success) {
            return;
        }
        boolean isClosure = owner instanceof GrClosableBlock;
        if (!ConvertParameterToMapEntryIntention.checkOwnerOccurences(project, occurrences, isClosure)) {
            return;
        }
        final GrParameter firstParam = ConvertParameterToMapEntryIntention.getFirstParameter(owner);
        switch (ConvertParameterToMapEntryIntention.analyzeForNamedArguments(owner, occurrences)) {
            case ERROR: {
                GrNamedElement namedElement = ConvertParameterToMapEntryIntention.getReferencedElement(owner);
                LOG.assertTrue(namedElement != null);
                String msg = GroovyIntentionsBundle.message("wrong.first.parameter.type", isClosure ? CLOSURE_CAPTION_CAP : METHOD_CAPTION_CAP, namedElement.getName(), firstParam.getName());
                ConvertParameterToMapEntryIntention.showErrorMessage(msg, project);
                return;
            }
            case MUST_BE_MAP: {
                if (firstParam == ConvertParameterToMapEntryIntention.getAppropriateParameter(element)) {
                    String msg = GroovyIntentionsBundle.message("convert.cannot.itself", new Object[0]);
                    ConvertParameterToMapEntryIntention.showErrorMessage(msg, project);
                    return;
                }
                ConvertParameterToMapEntryIntention.performRefactoring(element, owner, occurrences, false, null, false);
                break;
            }
            case IS_NOT_MAP: {
                if (!ApplicationManager.getApplication().isUnitTestMode()) {
                    String[] possibleNames = ConvertParameterToMapEntryIntention.generateValidNames(MY_POSSIBLE_NAMES, firstParam);
                    final GroovyMapParameterDialog dialog = new GroovyMapParameterDialog(project, possibleNames, true){

                        @Override
                        protected void doOKAction() {
                            String name = this.getEnteredName();
                            MultiMap conflicts = new MultiMap();
                            GroovyValidationUtil.validateNewParameterName(firstParam, (MultiMap<PsiElement, String>)conflicts, name);
                            if (ConvertParameterToMapEntryIntention.reportConflicts((MultiMap<PsiElement, String>)conflicts, project)) {
                                ConvertParameterToMapEntryIntention.performRefactoring(element, owner, occurrences, this.createNewFirst(), name, this.specifyTypeExplicitly());
                            }
                            super.doOKAction();
                        }
                    };
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            dialog.show();
                        }
                    });
                    break;
                }
                ConvertParameterToMapEntryIntention.performRefactoring(element, owner, occurrences, true, new GroovyValidationUtil.ParameterNameSuggester("attrs", firstParam).generateName(), false);
            }
        }
    }

    private static String[] generateValidNames(String[] names, final GrParameter param) {
        return (String[])ContainerUtil.map2Array((Object[])names, String.class, (Function)new Function<String, String>(){

            public String fun(String s) {
                return new GroovyValidationUtil.ParameterNameSuggester(s, param).generateName();
            }
        });
    }

    private static void performRefactoring(PsiElement element, final GrParametersOwner owner, final Collection<PsiElement> occurrences, final boolean createNewFirstParam, String mapParamName, final boolean specifyMapType) {
        final GrParameter param = ConvertParameterToMapEntryIntention.getAppropriateParameter(element);
        assert (param != null);
        final String paramName = param.getName();
        final String mapName = createNewFirstParam ? mapParamName : ConvertParameterToMapEntryIntention.getFirstParameter(owner).getName();
        final Project project = element.getProject();
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                GrExpression expr;
                int newIndex;
                GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(project);
                GrParameterList list = owner.getParameterList();
                assert (list != null);
                int index = list.getParameterNumber(param);
                int n = newIndex = createNewFirstParam ? index : index - 1;
                if (!createNewFirstParam && index <= 0) {
                    return;
                }
                Collection references = ReferencesSearch.search((PsiElement)param).findAll();
                for (PsiReference ref : references) {
                    PsiElement elt = ref.getElement();
                    if (!(elt instanceof GrReferenceExpression)) continue;
                    expr = (GrReferenceExpression)elt;
                    GrExpression newExpr = factory.createExpressionFromText(mapName + "." + paramName);
                    expr.replaceWithExpression(newExpr, true);
                }
                if (createNewFirstParam) {
                    try {
                        GrParameter newParam = factory.createParameter(mapName, specifyMapType ? ConvertParameterToMapEntryIntention.MAP_TYPE_TEXT : "", null);
                        list.addParameterToHead(newParam);
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                }
                list.removeParameter(param);
                List calls = ConvertParameterToMapEntryIntention.getCallOccurrences(occurrences);
                try {
                    for (GrCall call : calls) {
                        expr = call.removeArgument(newIndex);
                        if (expr == null) continue;
                        GrNamedArgument argument = factory.createNamedArgument(paramName, expr);
                        call.addNamedArgument(argument);
                    }
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
                PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                try {
                    for (GrCall call : calls) {
                        ConvertParameterToMapEntryIntention.reformatOwner(call.getArgumentList());
                    }
                    ConvertParameterToMapEntryIntention.reformatOwner(owner.getParameterList());
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
        };
        CommandProcessor.getInstance().executeCommand(project, new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(runnable);
            }
        }, REFACTORING_NAME, null);
    }

    private static List<GrCall> getCallOccurrences(Collection<PsiElement> occurrences) {
        List elementList = ContainerUtil.findAll(occurrences, (Condition)new Condition<PsiElement>(){

            public boolean value(PsiElement psiElement) {
                return psiElement instanceof GrReferenceExpression && psiElement.getParent() instanceof GrCall;
            }
        });
        return ContainerUtil.map((Iterable)elementList, (Function)new Function<PsiElement, GrCall>(){

            public GrCall fun(PsiElement psiElement) {
                return (GrCall)psiElement.getParent();
            }
        });
    }

    @Nullable
    private static GrParameter getAppropriateParameter(PsiElement element) {
        if (element instanceof GrParameter) {
            return (GrParameter)element;
        }
        if (element instanceof GrReferenceExpression) {
            GrReferenceExpression expr = (GrReferenceExpression)element;
            PsiElement resolved = expr.resolve();
            LOG.assertTrue(resolved instanceof GrParameter);
            return (GrParameter)resolved;
        }
        LOG.error("Selected expression is not resolved to methood/closure parameter");
        return null;
    }

    private static FIRST_PARAMETER_KIND analyzeForNamedArguments(GrParametersOwner owner, Collection<PsiElement> occurrences) {
        boolean thereAreNamedArguments = false;
        for (PsiElement occurrence : occurrences) {
            GrCall call;
            GrArgumentList args;
            if (occurrence instanceof GrReferenceExpression && occurrence.getParent() instanceof GrCall && (args = (call = (GrCall)occurrence.getParent()).getArgumentList()) != null && args.getNamedArguments().length > 0) {
                thereAreNamedArguments = true;
            }
            if (!thereAreNamedArguments) continue;
            break;
        }
        if (thereAreNamedArguments) {
            if (ConvertParameterToMapEntryIntention.firstOwnerParameterMustBeMap(owner)) {
                return FIRST_PARAMETER_KIND.MUST_BE_MAP;
            }
            return FIRST_PARAMETER_KIND.ERROR;
        }
        return FIRST_PARAMETER_KIND.IS_NOT_MAP;
    }

    private static boolean firstOwnerParameterMustBeMap(GrParametersOwner owner) {
        GrParameter first = ConvertParameterToMapEntryIntention.getFirstParameter(owner);
        PsiType type = first.getTypeGroovy();
        PsiClassType mapType = PsiUtil.createMapType(owner.getManager(), GlobalSearchScope.allScope((Project)owner.getProject()));
        return type == null || type.isConvertibleFrom((PsiType)mapType);
    }

    @NotNull
    private static GrParameter getFirstParameter(GrParametersOwner owner) {
        GrParameter[] params = owner.getParameters();
        LOG.assertTrue(params.length > 0);
        GrParameter grParameter = params[0];
        if (grParameter == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/intentions/style/parameterToEntry/ConvertParameterToMapEntryIntention.getFirstParameter must not return null");
        }
        return grParameter;
    }

    @Nullable
    private static GrNamedElement getReferencedElement(GrParametersOwner owner) {
        PsiElement parent;
        if (owner instanceof GrMethodImpl) {
            return (GrMethodImpl)owner;
        }
        if (owner instanceof GrClosableBlock && (parent = owner.getParent()) instanceof GrVariable && ((GrVariable)parent).getInitializerGroovy() == owner) {
            return (GrVariable)parent;
        }
        return null;
    }

    private static boolean checkOwnerOccurences(Project project, Collection<PsiElement> occurrences, boolean isClosure) {
        boolean result = true;
        StringBuffer msg = new StringBuffer();
        msg.append(GroovyIntentionsBundle.message("conversion.not.allowed.in.non.groovy.files", isClosure ? CLOSURE_CAPTION : METHOD_CAPTION));
        for (PsiElement element : occurrences) {
            PsiFile file = element.getContainingFile();
            if (file instanceof GroovyFileBase) continue;
            result = false;
            msg.append("\n").append(file.getName());
        }
        if (!result) {
            ConvertParameterToMapEntryIntention.showErrorMessage(msg.toString(), project);
            return false;
        }
        return true;
    }

    private static boolean collectOwnerOccurrences(Project project, GrParametersOwner owner, final Collection<PsiElement> occurrences) {
        final GrNamedElement namedElem = ConvertParameterToMapEntryIntention.getReferencedElement(owner);
        if (namedElem == null) {
            return true;
        }
        final Ref result = new Ref((Object)true);
        Task.Modal task = new Task.Modal(project, GroovyIntentionsBundle.message("find.method.ro.closure.usages.0", owner instanceof GrClosableBlock ? CLOSURE_CAPTION : METHOD_CAPTION), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/intentions/style/parameterToEntry/ConvertParameterToMapEntryIntention$8.run must not be null");
                }
                GlobalSearchScope projectScope = GlobalSearchScope.projectScope((Project)this.getProject());
                Query query = ReferencesSearch.search((PsiElement)namedElem, (SearchScope)projectScope);
                Collection references = query.findAll();
                for (PsiReference reference : references) {
                    PsiElement element = reference.getElement();
                    if (element == null) continue;
                    occurrences.add(element);
                }
            }

            public void onCancel() {
                result.set((Object)false);
            }

            public void onSuccess() {
                result.set((Object)true);
            }
        };
        ProgressManager.getInstance().run((Task)task);
        return (Boolean)result.get();
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        MyPsiElementPredicate myPsiElementPredicate = new MyPsiElementPredicate();
        if (myPsiElementPredicate == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/intentions/style/parameterToEntry/ConvertParameterToMapEntryIntention.getElementPredicate must not return null");
        }
        return myPsiElementPredicate;
    }

    private static boolean checkForMapParameters(GrParametersOwner owner) {
        GrParameter[] parameters = owner.getParameters();
        if (parameters.length != 1) {
            return true;
        }
        GrParameter parameter = parameters[0];
        PsiType type = parameter.getTypeGroovy();
        if (!(type instanceof PsiClassType)) {
            return true;
        }
        PsiClass psiClass = ((PsiClassType)type).resolve();
        return psiClass == null || !"java.util.Map".equals(psiClass.getQualifiedName());
    }

    private static void showErrorMessage(String message, Project project) {
        CommonRefactoringUtil.showErrorMessage((String)REFACTORING_NAME, (String)message, null, (Project)project);
    }

    private static void reformatOwner(PsiElement owner) throws IncorrectOperationException {
        if (owner == null) {
            return;
        }
        CodeStyleManager.getInstance((Project)owner.getProject()).reformat(owner);
    }

    private static boolean reportConflicts(MultiMap<PsiElement, String> conflicts, Project project) {
        if (conflicts.size() == 0) {
            return true;
        }
        ConflictsDialog conflictsDialog = new ConflictsDialog(project, conflicts);
        conflictsDialog.show();
        return conflictsDialog.isOK();
    }

    private static class MyPsiElementPredicate
    implements PsiElementPredicate {
        private MyPsiElementPredicate() {
        }

        @Override
        public boolean satisfiedBy(PsiElement element) {
            GrParametersOwner owner = null;
            if (element instanceof GrParameter) {
                owner = (GrParametersOwner)PsiTreeUtil.getParentOfType((PsiElement)element, GrParametersOwner.class);
            } else if (element instanceof GrReferenceExpression) {
                GrReferenceExpression expr = (GrReferenceExpression)element;
                if (expr.getQualifierExpression() != null) {
                    return false;
                }
                PsiElement resolved = expr.resolve();
                if (!(resolved instanceof GrParameter)) {
                    return false;
                }
                owner = (GrParametersOwner)PsiTreeUtil.getParentOfType((PsiElement)resolved, GrParametersOwner.class);
            }
            if (!(owner instanceof GrClosableBlock) && !(owner instanceof GrMethodImpl)) {
                return false;
            }
            return ConvertParameterToMapEntryIntention.checkForMapParameters(owner);
        }
    }

    protected static enum FIRST_PARAMETER_KIND {
        IS_NOT_MAP,
        MUST_BE_MAP,
        ERROR;

    }
}

