/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions;

import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.IntentionUtils;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.intentions.conversions.IndexedExpressionConversionPredicate;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;

public class IndexedExpressionConversionIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        IndexedExpressionConversionPredicate indexedExpressionConversionPredicate = new IndexedExpressionConversionPredicate();
        if (indexedExpressionConversionPredicate == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/intentions/conversions/IndexedExpressionConversionIntention.getElementPredicate must not return null");
        }
        return indexedExpressionConversionPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/intentions/conversions/IndexedExpressionConversionIntention.processIntention must not be null");
        }
        GrIndexProperty arrayIndexExpression = (GrIndexProperty)element;
        GrArgumentList argList = (GrArgumentList)arrayIndexExpression.getLastChild();
        assert (argList != null);
        GrExpression[] arguments = argList.getExpressionArguments();
        PsiElement parent = element.getParent();
        GrExpression arrayExpression = arrayIndexExpression.getSelectedExpression();
        if (!(parent instanceof GrAssignmentExpression)) {
            IndexedExpressionConversionIntention.rewriteAsGetAt(arrayIndexExpression, arrayExpression, arguments[0]);
            return;
        }
        GrAssignmentExpression assignmentExpression = (GrAssignmentExpression)parent;
        GrExpression rhs = assignmentExpression.getRValue();
        if (rhs.equals(element)) {
            IndexedExpressionConversionIntention.rewriteAsGetAt(arrayIndexExpression, arrayExpression, arguments[0]);
        } else {
            IndexedExpressionConversionIntention.rewriteAsSetAt(assignmentExpression, arrayExpression, arguments[0], rhs);
        }
    }

    private static void rewriteAsGetAt(GrIndexProperty arrayIndexExpression, GrExpression arrayExpression, GrExpression argument) throws IncorrectOperationException {
        IntentionUtils.replaceExpression(arrayExpression.getText() + ".getAt(" + argument.getText() + ')', arrayIndexExpression);
    }

    private static void rewriteAsSetAt(GrAssignmentExpression assignment, GrExpression arrayExpression, GrExpression argument, GrExpression value) throws IncorrectOperationException {
        IntentionUtils.replaceExpression(arrayExpression.getText() + ".putAt(" + argument.getText() + ", " + value.getText() + ')', assignment);
    }
}

