/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.findUsages;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.impl.light.LightMemberReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrConstructorInvocation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;

public class GroovyConstructorUsagesSearchHelper {
    private GroovyConstructorUsagesSearchHelper() {
    }

    public static boolean execute(final PsiMethod constructor, SearchScope searchScope, final Processor<PsiReference> consumer) {
        if (!constructor.isConstructor()) {
            return true;
        }
        PsiClass clazz = constructor.getContainingClass();
        if (clazz == null) {
            return true;
        }
        ReferencesSearch.search((PsiElement)clazz, (SearchScope)searchScope, (boolean)true).forEach((Processor)new Processor<PsiReference>(){

            public boolean process(PsiReference ref) {
                PsiElement element = ref.getElement();
                if (element instanceof GrCodeReferenceElement && element.getParent() instanceof GrNewExpression) {
                    GrNewExpression newExpression = (GrNewExpression)element.getParent();
                    PsiMethod resolvedConstructor = newExpression.resolveConstructor();
                    PsiManager manager = constructor.getManager();
                    if (manager.areElementsEquivalent((PsiElement)resolvedConstructor, (PsiElement)constructor) && !consumer.process((Object)ref)) {
                        return false;
                    }
                }
                return true;
            }
        });
        if (clazz instanceof GrTypeDefinition && !GroovyConstructorUsagesSearchHelper.processConstructors(constructor, consumer, clazz, true)) {
            return false;
        }
        return DirectClassInheritorsSearch.search((PsiClass)clazz, (SearchScope)searchScope).forEach((Processor)new Processor<PsiClass>(){

            public boolean process(PsiClass inheritor) {
                return !(inheritor instanceof GrTypeDefinition) || GroovyConstructorUsagesSearchHelper.processConstructors(constructor, (Processor<PsiReference>)consumer, inheritor, false);
            }
        });
    }

    private static boolean processConstructors(final PsiMethod constructor, final Processor<PsiReference> consumer, final PsiClass clazz, final boolean processThisRefs) {
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                return GroovyConstructorUsagesSearchHelper.processClassConstructors(clazz, constructor, (Processor<PsiReference>)consumer, processThisRefs);
            }
        });
    }

    private static boolean processClassConstructors(PsiClass clazz, PsiMethod searchedConstructor, Processor<PsiReference> consumer, boolean processThisRefs) {
        PsiMethod[] constructors = clazz.getConstructors();
        if (constructors.length == 0) {
            GroovyConstructorUsagesSearchHelper.processImplicitConstructorCall((PsiMember)clazz, consumer, searchedConstructor);
        }
        for (PsiMethod constructor : constructors) {
            GrOpenBlock block = ((GrMethod)constructor).getBlock();
            if (block == null) continue;
            GrStatement[] statements = block.getStatements();
            if (statements.length > 0 && statements[0] instanceof GrConstructorInvocation) {
                GrConstructorInvocation invocation = (GrConstructorInvocation)statements[0];
                if (invocation.isThisCall() != processThisRefs || !invocation.getManager().areElementsEquivalent((PsiElement)invocation.resolveConstructor(), (PsiElement)searchedConstructor) || consumer.process((Object)invocation)) continue;
                return false;
            }
            GroovyConstructorUsagesSearchHelper.processImplicitConstructorCall((PsiMember)constructor, consumer, searchedConstructor);
        }
        return true;
    }

    private static void processImplicitConstructorCall(final PsiMember usage, Processor<PsiReference> processor, PsiMethod constructor) {
        GrParameter[] grParameters;
        if (constructor instanceof GrMethod ? (grParameters = (GrParameter[])constructor.getParameterList().getParameters()).length > 0 && !grParameters[0].isOptional() : constructor.getParameterList().getParameters().length > 0) {
            return;
        }
        PsiManager manager = constructor.getManager();
        if (manager.areElementsEquivalent((PsiElement)usage, (PsiElement)constructor) || manager.areElementsEquivalent((PsiElement)constructor.getContainingClass(), (PsiElement)usage.getContainingClass())) {
            return;
        }
        processor.process((Object)new LightMemberReference(manager, usage, PsiSubstitutor.EMPTY){

            public PsiElement getElement() {
                return usage;
            }

            public TextRange getRangeInElement() {
                PsiIdentifier identifier;
                if (usage instanceof PsiClass) {
                    PsiIdentifier identifier2 = ((PsiClass)usage).getNameIdentifier();
                    if (identifier2 != null) {
                        return TextRange.from((int)identifier2.getStartOffsetInParent(), (int)identifier2.getTextLength());
                    }
                } else if (usage instanceof PsiMethod && (identifier = ((PsiMethod)usage).getNameIdentifier()) != null) {
                    return TextRange.from((int)identifier.getStartOffsetInParent(), (int)identifier.getTextLength());
                }
                return super.getRangeInElement();
            }
        });
    }
}

