/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.editor.selection;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.plugins.groovy.editor.selection.GroovyBasicSelectioner;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;

public class GroovyBlockStatementsSelectioner
extends GroovyBasicSelectioner {
    public boolean canSelect(PsiElement e) {
        return e instanceof GrCodeBlock;
    }

    @Override
    public List<TextRange> select(PsiElement e, CharSequence editorText, int cursorOffset, Editor editor) {
        List<TextRange> result = super.select(e, editorText, cursorOffset, editor);
        if (e instanceof GrCodeBlock) {
            GrCodeBlock block = (GrCodeBlock)e;
            int startOffset = GroovyBlockStatementsSelectioner.findOpeningBrace(block);
            int endOffset = GroovyBlockStatementsSelectioner.findClosingBrace(block, startOffset);
            TextRange range = new TextRange(startOffset, endOffset);
            result.addAll(GroovyBlockStatementsSelectioner.expandToWholeLine((CharSequence)editorText, (TextRange)range));
        }
        return result;
    }

    private static int findOpeningBrace(GrCodeBlock block) {
        PsiElement lbrace = block.getLBrace();
        if (lbrace == null) {
            return block.getTextRange().getStartOffset();
        }
        while (GroovyBlockStatementsSelectioner.isWhiteSpace(lbrace.getNextSibling())) {
            lbrace = lbrace.getNextSibling();
        }
        return lbrace.getTextRange().getEndOffset();
    }

    private static int findClosingBrace(GrCodeBlock block, int startOffset) {
        PsiElement rbrace = block.getRBrace();
        if (rbrace == null) {
            return block.getTextRange().getEndOffset();
        }
        while (GroovyBlockStatementsSelectioner.isWhiteSpace(rbrace.getPrevSibling()) && rbrace.getPrevSibling().getTextRange().getStartOffset() > startOffset) {
            rbrace = rbrace.getPrevSibling();
        }
        return rbrace.getTextRange().getStartOffset();
    }

    private static boolean isWhiteSpace(PsiElement element) {
        return element != null && GroovyTokenTypes.WHITE_SPACES_SET.contains(element.getNode().getElementType());
    }
}

