/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.compiler.generator;

import com.intellij.openapi.compiler.ValidityState;
import com.intellij.openapi.diagnostic.Logger;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.List;

class TopLevelDependencyValidityState
implements ValidityState {
    private final long myTimestamp;
    private final List<String> myMembers;
    private static final Logger LOG = Logger.getInstance((String)"org.jetbrains.plugins.groovy.compiler.generator.TopLevelDependencyValidityState");

    TopLevelDependencyValidityState(long timestamp, List<String> members) {
        this.myMembers = members;
        this.myTimestamp = timestamp;
    }

    public boolean equalsTo(ValidityState validityState) {
        if (!(validityState instanceof TopLevelDependencyValidityState)) {
            return false;
        }
        return ((TopLevelDependencyValidityState)validityState).myTimestamp == this.myTimestamp && ((Object)this.myMembers).equals(((TopLevelDependencyValidityState)validityState).myMembers);
    }

    public void save(DataOutput out) throws IOException {
        out.writeLong(this.myTimestamp);
        out.writeChar(10);
        for (String member : this.myMembers) {
            out.writeChar(10);
            out.writeUTF(member);
        }
    }

    public static TopLevelDependencyValidityState load(DataInputStream is) throws IOException {
        int ttype;
        long timestamp = -1L;
        InputStreamReader reader = new InputStreamReader(is);
        StreamTokenizer tokenizer = new StreamTokenizer(reader);
        ArrayList<String> members = new ArrayList<String>();
        block7: do {
            ttype = tokenizer.nextToken();
            switch (ttype) {
                case -2: {
                    try {
                        timestamp = (long)tokenizer.nval;
                    }
                    catch (NumberFormatException e) {
                        LOG.error((Throwable)e);
                    }
                    continue block7;
                }
                case -3: {
                    members.add(tokenizer.sval);
                    break;
                }
                case 10: {
                    break;
                }
            }
        } while (ttype != -1);
        return new TopLevelDependencyValidityState(timestamp, members);
    }
}

