/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.utils;

import java.awt.Toolkit;
import javax.swing.InputMap;
import javax.swing.JFormattedTextField;
import javax.swing.KeyStroke;

public class FormattedTextFieldMacFix {
    private FormattedTextFieldMacFix() {
    }

    public static void apply(JFormattedTextField field) {
        if (FormattedTextFieldMacFix.isMacOs()) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            int commandKeyMask = toolkit.getMenuShortcutKeyMask();
            InputMap inputMap = field.getInputMap();
            KeyStroke copyKeyStroke = KeyStroke.getKeyStroke(67, commandKeyMask);
            inputMap.put(copyKeyStroke, "copy-to-clipboard");
            KeyStroke pasteKeyStroke = KeyStroke.getKeyStroke(86, commandKeyMask);
            inputMap.put(pasteKeyStroke, "paste-from-clipboard");
            KeyStroke cutKeyStroke = KeyStroke.getKeyStroke(88, commandKeyMask);
            inputMap.put(cutKeyStroke, "cut-to-clipboard");
        }
    }

    private static boolean isMacOs() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName == null) {
            return false;
        }
        return osName.startsWith("mac os x");
    }
}

