/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.unusedDef;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntProcedure;
import gnu.trove.TObjectProcedure;
import java.util.ArrayList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.codeInspection.GroovyLocalInspectionBase;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrClassInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrPostfixExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReadWriteVariableInstruction;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DFAEngine;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs.ReachingDefinitionsDfaInstance;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs.ReachingDefinitionsSemilattice;

public class UnusedDefInspection
extends GroovyLocalInspectionBase {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = GroovyInspectionBundle.message("groovy.dfa.issues", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/unusedDef/UnusedDefInspection.getGroupDisplayName must not return null");
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = GroovyInspectionBundle.message("unused.assignment", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/unusedDef/UnusedDefInspection.getDisplayName must not return null");
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("GroovyUnusedAssignment" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/unusedDef/UnusedDefInspection.getShortName must not return null");
        }
        return "GroovyUnusedAssignment";
    }

    @Override
    protected void check(GrControlFlowOwner owner, final ProblemsHolder problemsHolder) {
        final Instruction[] flow = owner.getControlFlow();
        ReachingDefinitionsDfaInstance dfaInstance = new ReachingDefinitionsDfaInstance(flow);
        ReachingDefinitionsSemilattice lattice = new ReachingDefinitionsSemilattice();
        DFAEngine<TIntObjectHashMap<TIntHashSet>> engine = new DFAEngine<TIntObjectHashMap<TIntHashSet>>(flow, dfaInstance, lattice);
        ArrayList<TIntObjectHashMap<TIntHashSet>> dfaResult = engine.performDFA();
        final TIntHashSet unusedDefs = new TIntHashSet();
        for (Instruction instruction : flow) {
            if (!(instruction instanceof ReadWriteVariableInstruction) || !((ReadWriteVariableInstruction)instruction).isWrite()) continue;
            unusedDefs.add(instruction.num());
        }
        for (int i = 0; i < dfaResult.size(); ++i) {
            ReadWriteVariableInstruction varInsn;
            Instruction instruction = flow[i];
            if (!(instruction instanceof ReadWriteVariableInstruction) || (varInsn = (ReadWriteVariableInstruction)instruction).isWrite()) continue;
            final String varName = varInsn.getVariableName();
            TIntObjectHashMap<TIntHashSet> e = dfaResult.get(i);
            e.forEachValue((TObjectProcedure)new TObjectProcedure<TIntHashSet>(){

                public boolean execute(TIntHashSet reaching) {
                    reaching.forEach(new TIntProcedure(){

                        public boolean execute(int defNum) {
                            String defName = ((ReadWriteVariableInstruction)flow[defNum]).getVariableName();
                            if (varName.equals(defName)) {
                                unusedDefs.remove(defNum);
                            }
                            return true;
                        }
                    });
                    return true;
                }
            });
        }
        unusedDefs.forEach(new TIntProcedure(){

            public boolean execute(int num) {
                ReadWriteVariableInstruction instruction = (ReadWriteVariableInstruction)flow[num];
                PsiElement element = instruction.getElement();
                if (UnusedDefInspection.this.isLocalAssignment(element) && UnusedDefInspection.this.isUsedInToplevelFlowOnly(element)) {
                    if (element instanceof GrReferenceExpression) {
                        PsiElement parent = element.getParent();
                        GrExpression toHighlight = null;
                        if (parent instanceof GrAssignmentExpression) {
                            toHighlight = ((GrAssignmentExpression)parent).getLValue();
                        }
                        if (parent instanceof GrPostfixExpression) {
                            toHighlight = parent;
                        }
                        if (toHighlight == null) {
                            toHighlight = element;
                        }
                        problemsHolder.registerProblem((PsiElement)toHighlight, GroovyInspectionBundle.message("unused.assignment.tooltip", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[0]);
                    } else if (element instanceof GrVariable) {
                        problemsHolder.registerProblem(((GrVariable)element).getNameIdentifierGroovy(), GroovyInspectionBundle.message("unused.assignment.tooltip", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[0]);
                    }
                }
                return true;
            }
        });
    }

    private boolean isUsedInToplevelFlowOnly(PsiElement element) {
        PsiElement resolved;
        GrVariable var = null;
        if (element instanceof GrVariable) {
            var = (GrVariable)element;
        } else if (element instanceof GrReferenceExpression && (resolved = ((GrReferenceExpression)element).resolve()) instanceof GrVariable) {
            var = (GrVariable)resolved;
        }
        if (var != null) {
            final GroovyPsiElement scope = this.getScope(var);
            assert (scope != null);
            return ReferencesSearch.search((PsiElement)var, (SearchScope)new LocalSearchScope((PsiElement)scope)).forEach((Processor)new Processor<PsiReference>(){

                public boolean process(PsiReference ref) {
                    return UnusedDefInspection.this.getScope(ref.getElement()) == scope;
                }
            });
        }
        return true;
    }

    private GroovyPsiElement getScope(PsiElement var) {
        return (GroovyPsiElement)PsiTreeUtil.getParentOfType((PsiElement)var, (Class[])new Class[]{GrClosableBlock.class, GrMethod.class, GrClassInitializer.class, GroovyFileBase.class});
    }

    private boolean isLocalAssignment(PsiElement element) {
        if (element instanceof GrVariable) {
            return this.isLocalVariable((GrVariable)element, false);
        }
        if (element instanceof GrReferenceExpression) {
            PsiElement resolved = ((GrReferenceExpression)element).resolve();
            return resolved instanceof GrVariable && this.isLocalVariable((GrVariable)resolved, true);
        }
        return false;
    }

    private boolean isLocalVariable(GrVariable var, boolean parametersAllowed) {
        if (var instanceof GrField) {
            return false;
        }
        return !(var instanceof GrParameter) || parametersAllowed;
    }

    public boolean isEnabledByDefault() {
        return true;
    }
}

