/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.threading;

import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSynchronizedStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrThisReferenceExpression;

public class GroovySynchronizationOnThisInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Threading issues" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/threading/GroovySynchronizationOnThisInspection.getGroupDisplayName must not return null");
        }
        return "Threading issues";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Synchronization on 'this'" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/threading/GroovySynchronizationOnThisInspection.getDisplayName must not return null");
        }
        return "Synchronization on 'this'";
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "Synchronization on '#ref' #loc";
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitSynchronizedStatement(GrSynchronizedStatement synchronizedStatement) {
            super.visitSynchronizedStatement(synchronizedStatement);
            GrExpression lock = synchronizedStatement.getMonitor();
            if (lock == null || !(lock instanceof GrThisReferenceExpression)) {
                return;
            }
            this.registerError(lock);
        }
    }
}

