/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.confusing;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.utils.SingleIntegerFieldOptionsPanel;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;

public class GroovyOverlyComplexBooleanExpressionInspection
extends BaseInspection {
    private static final int TERM_LIMIT = 3;
    public int m_limit = 3;

    @NotNull
    public String getDisplayName() {
        if ("Overly complex boolean expression" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyOverlyComplexBooleanExpressionInspection.getDisplayName must not return null");
        }
        return "Overly complex boolean expression";
    }

    @NotNull
    public String getGroupDisplayName() {
        if ("Potentially confusing code constructs" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyOverlyComplexBooleanExpressionInspection.getGroupDisplayName must not return null");
        }
        return "Potentially confusing code constructs";
    }

    private int getLimit() {
        return this.m_limit;
    }

    public JComponent createOptionsPanel() {
        return new SingleIntegerFieldOptionsPanel("Maximum number of terms", this, "m_limit");
    }

    @Override
    protected String buildErrorString(Object ... args) {
        return "Overly complex boolean expression #loc";
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitBinaryExpression(@NotNull GrBinaryExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyOverlyComplexBooleanExpressionInspection$Visitor.visitBinaryExpression must not be null");
            }
            super.visitBinaryExpression(expression);
            this.checkExpression(expression);
        }

        @Override
        public void visitUnaryExpression(@NotNull GrUnaryExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyOverlyComplexBooleanExpressionInspection$Visitor.visitUnaryExpression must not be null");
            }
            super.visitUnaryExpression(expression);
            this.checkExpression(expression);
        }

        @Override
        public void visitParenthesizedExpression(GrParenthesizedExpression expression) {
            super.visitParenthesizedExpression(expression);
            this.checkExpression(expression);
        }

        private void checkExpression(GrExpression expression) {
            if (!this.isBoolean(expression)) {
                return;
            }
            if (this.isParentBoolean(expression)) {
                return;
            }
            int numTerms = this.countTerms(expression);
            if (numTerms <= GroovyOverlyComplexBooleanExpressionInspection.this.getLimit()) {
                return;
            }
            this.registerError(expression);
        }

        private int countTerms(GrExpression expression) {
            if (expression == null) {
                return 0;
            }
            if (!this.isBoolean(expression)) {
                return 1;
            }
            if (expression instanceof GrBinaryExpression) {
                GrBinaryExpression binaryExpression = (GrBinaryExpression)expression;
                GrExpression lhs = binaryExpression.getLeftOperand();
                GrExpression rhs = binaryExpression.getRightOperand();
                return this.countTerms(lhs) + this.countTerms(rhs);
            }
            if (expression instanceof GrUnaryExpression) {
                GrUnaryExpression prefixExpression = (GrUnaryExpression)expression;
                GrExpression operand = prefixExpression.getOperand();
                return this.countTerms(operand);
            }
            if (expression instanceof GrParenthesizedExpression) {
                GrParenthesizedExpression parenthesizedExpression = (GrParenthesizedExpression)expression;
                GrExpression contents = parenthesizedExpression.getOperand();
                return this.countTerms(contents);
            }
            return 1;
        }

        private boolean isParentBoolean(GrExpression expression) {
            PsiElement parent = expression.getParent();
            if (!(parent instanceof GrExpression)) {
                return false;
            }
            return this.isBoolean((GrExpression)parent);
        }

        private boolean isBoolean(GrExpression expression) {
            if (expression instanceof GrBinaryExpression) {
                GrBinaryExpression binaryExpression = (GrBinaryExpression)expression;
                IElementType sign = binaryExpression.getOperationTokenType();
                return GroovyTokenTypes.mLAND.equals(sign) || GroovyTokenTypes.mLOR.equals(sign);
            }
            if (expression instanceof GrUnaryExpression) {
                GrUnaryExpression prefixExpression = (GrUnaryExpression)expression;
                IElementType sign = prefixExpression.getOperationTokenType();
                return GroovyTokenTypes.mLNOT.equals(sign);
            }
            if (expression instanceof GrParenthesizedExpression) {
                GrParenthesizedExpression parenthesizedExpression = (GrParenthesizedExpression)expression;
                GrExpression contents = parenthesizedExpression.getOperand();
                return this.isBoolean(contents);
            }
            return false;
        }
    }
}

