/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.assignment;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyAssignabilityCheckInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Assignment issues" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyAssignabilityCheckInspection.getGroupDisplayName must not return null");
        }
        return "Assignment issues";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Incompatible Types Assignments Inspection" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyAssignabilityCheckInspection.getDisplayName must not return null");
        }
        return "Incompatible Types Assignments Inspection";
    }

    @Override
    protected String buildErrorString(Object ... args) {
        return GroovyBundle.message("cannot.assign", args);
    }

    @Override
    protected BaseInspectionVisitor buildVisitor() {
        return new MyVisitor();
    }

    private static boolean isListAssignment(GrExpression lValue) {
        if (lValue instanceof GrReferenceExpression) {
            GrReferenceExpression expression = (GrReferenceExpression)lValue;
            PsiElement dot = expression.getDotToken();
            if (dot != null && dot.getNode().getElementType() == GroovyTokenTypes.mSPREAD_DOT) {
                return true;
            }
            GrExpression qual = expression.getQualifierExpression();
            if (qual != null) {
                return GroovyAssignabilityCheckInspection.isListAssignment(qual);
            }
        }
        return false;
    }

    private static class MyVisitor
    extends BaseInspectionVisitor {
        private MyVisitor() {
        }

        private void checkAssignability(@NotNull PsiType expectedType, @NotNull GrExpression expression, GroovyPsiElement element) {
            if (expectedType == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyAssignabilityCheckInspection$MyVisitor.checkAssignability must not be null");
            }
            if (expression == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyAssignabilityCheckInspection$MyVisitor.checkAssignability must not be null");
            }
            if (PsiUtil.isRawClassMemberAccess(expression)) {
                return;
            }
            PsiType rType = expression.getType();
            if (rType == null || rType == PsiType.VOID) {
                return;
            }
            if (!TypesUtil.isAssignable(expectedType, rType, element)) {
                this.registerError(element, rType.getPresentableText(), expectedType.getPresentableText());
            }
        }

        @Override
        public void visitOpenBlock(GrOpenBlock block) {
            super.visitOpenBlock(block);
            PsiElement element = block.getParent();
            if (!(element instanceof GrMethod)) {
                return;
            }
            GrMethod method = (GrMethod)element;
            final PsiType expectedType = method.getReturnType();
            if (expectedType == null || PsiType.VOID.equals(expectedType)) {
                return;
            }
            ControlFlowUtils.visitAllExitPoints(block, new ControlFlowUtils.ExitPointVisitor(){

                @Override
                public boolean visit(Instruction instruction) {
                    PsiElement psiElement = instruction.getElement();
                    if (psiElement instanceof GrExpression) {
                        MyVisitor.this.checkAssignability(expectedType, (GrExpression)psiElement, (GrExpression)psiElement);
                    }
                    return true;
                }
            });
        }

        @Override
        public void visitReturnStatement(GrReturnStatement returnStatement) {
            super.visitReturnStatement(returnStatement);
            PsiElement parent = returnStatement.getParent();
            if (!(parent instanceof GrOpenBlock)) {
                return;
            }
            PsiElement element = parent.getParent();
            if (!(element instanceof GrMethod)) {
                return;
            }
            GrMethod method = (GrMethod)element;
            GrExpression value = returnStatement.getReturnValue();
            PsiType expectedType = method.getReturnType();
            if (value == null || expectedType == null) {
                return;
            }
            this.checkAssignability(expectedType, value, returnStatement);
        }

        @Override
        public void visitNamedArgument(GrNamedArgument argument) {
            super.visitNamedArgument(argument);
            GrArgumentLabel label = argument.getLabel();
            if (label == null) {
                return;
            }
            PsiType expectedType = label.getExpectedArgumentType();
            if (expectedType == null) {
                return;
            }
            expectedType = TypeConversionUtil.erasure((PsiType)expectedType);
            GrExpression expr = argument.getExpression();
            if (expr == null) {
                return;
            }
            PsiType argType = expr.getType();
            if (argType == null) {
                return;
            }
            PsiClassType listType = JavaPsiFacade.getInstance((Project)argument.getProject()).getElementFactory().createTypeByFQClassName("java.util.List", argument.getResolveScope());
            if (listType.isAssignableFrom(argType)) {
                return;
            }
            this.checkAssignability(expectedType, expr, argument);
        }

        @Override
        public void visitAssignmentExpression(GrAssignmentExpression assignment) {
            super.visitAssignmentExpression(assignment);
            GrExpression lValue = assignment.getLValue();
            if (!PsiUtil.mightBeLVlaue(lValue)) {
                return;
            }
            IElementType opToken = assignment.getOperationToken();
            if (opToken != GroovyTokenTypes.mASSIGN) {
                return;
            }
            GrExpression rValue = assignment.getRValue();
            if (rValue == null) {
                return;
            }
            PsiType lType = lValue.getNominalType();
            PsiType rType = rValue.getType();
            if (GroovyAssignabilityCheckInspection.isListAssignment(lValue) && lType != null && lType instanceof PsiClassType) {
                PsiType[] types;
                PsiClassType pct = (PsiClassType)lType;
                PsiClass clazz = pct.resolve();
                if (clazz != null && "java.util.List".equals(clazz.getQualifiedName()) && (types = pct.getParameters()).length == 1 && types[0] != null && rType != null) {
                    this.checkAssignability(types[0], rValue, rValue);
                }
                return;
            }
            if (lValue instanceof GrReferenceExpression && ((GrReferenceExpression)lValue).resolve() instanceof GrReferenceExpression) {
                return;
            }
            if (lType != null && rType != null) {
                this.checkAssignability(lType, rValue, rValue);
            }
        }

        @Override
        public void visitVariable(GrVariable variable) {
            super.visitVariable(variable);
            PsiType varType = variable.getType();
            GrExpression initializer = variable.getInitializerGroovy();
            if (initializer == null) {
                return;
            }
            PsiType rType = initializer.getType();
            if (rType == null) {
                return;
            }
            this.checkAssignability(varType, initializer, initializer);
        }
    }
}

