/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.intentions.CreateClassActionBase;
import org.jetbrains.plugins.groovy.annotator.intentions.GroovyCreateClassDialog;
import org.jetbrains.plugins.groovy.intentions.base.IntentionUtils;
import org.jetbrains.plugins.groovy.lang.editor.template.expressions.ChooseTypeExpression;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrMemberOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.SupertypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public abstract class CreateClassFix {
    public static IntentionAction createClassFromNewAction(final GrNewExpression expression) {
        return new CreateClassActionBase(expression.getReferenceElement()){
            GrNewExpression myNewExpression;
            {
                super(x0);
                this.myNewExpression = expression;
            }

            public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
                if (project == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/annotator/intentions/CreateClassFix$1.invoke must not be null");
                }
                if (!(file instanceof GroovyFileBase)) {
                    return;
                }
                GroovyFileBase groovyFile = (GroovyFileBase)file;
                String qualifier = groovyFile instanceof GroovyFile ? groovyFile.getPackageName() : "";
                PsiManager manager = this.myRefElement.getManager();
                String name = this.myRefElement.getReferenceName();
                assert (name != null);
                Module module = ModuleUtil.findModuleForPsiElement((PsiElement)file);
                PsiDirectory targetDirectory = CreateClassFix.getTargetDirectory(project, qualifier, name, module);
                if (targetDirectory == null) {
                    return;
                }
                PsiClass targetClass = 1.createClassByType(targetDirectory, name, manager, this.myRefElement);
                GrArgumentList argList = expression.getArgumentList();
                if (argList != null && argList.getNamedArguments().length + argList.getExpressionArguments().length > 0 && targetClass instanceof GrMemberOwner) {
                    PsiType[] argTypes = PsiUtil.getArgumentTypes(this.myRefElement, false);
                    assert (argTypes != null);
                    ChooseTypeExpression[] paramTypesExpressions = new ChooseTypeExpression[argTypes.length];
                    String[] paramTypes = new String[argTypes.length];
                    String[] paramNames = new String[argTypes.length];
                    for (int i = 0; i < argTypes.length; ++i) {
                        PsiType argType = argTypes[i];
                        if (argType == null) {
                            argType = TypesUtil.getJavaLangObject(this.myRefElement);
                        }
                        paramTypes[i] = "Object";
                        paramNames[i] = "o" + i;
                        paramTypesExpressions[i] = new ChooseTypeExpression(new TypeConstraint[]{SupertypeConstraint.create(argType)}, this.myRefElement.getManager());
                    }
                    GrMethod method = GroovyPsiElementFactory.getInstance(project).createConstructorFromText(name, paramTypes, paramNames, "{\n}");
                    GrMemberOwner owner = (GrMemberOwner)targetClass;
                    method = owner.addMemberDeclaration(method, null);
                    IntentionUtils.createTemplateForMethod(argTypes, paramTypesExpressions, method, owner, new TypeConstraint[0], true);
                } else {
                    1.putCursor(project, targetClass.getContainingFile(), (PsiElement)targetClass);
                }
                CreateClassFix.addImportForClass(groovyFile, qualifier, targetClass);
            }
        };
    }

    public static IntentionAction createClassFixAction(GrReferenceElement refElement) {
        return new CreateClassActionBase(refElement){

            public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
                Module module;
                if (project == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/annotator/intentions/CreateClassFix$2.invoke must not be null");
                }
                if (!(file instanceof GroovyFileBase)) {
                    return;
                }
                GroovyFileBase groovyFile = (GroovyFileBase)file;
                String qualifier = groovyFile instanceof GroovyFile ? groovyFile.getPackageName() : "";
                PsiManager manager = PsiManager.getInstance((Project)project);
                String name = this.myRefElement.getReferenceName();
                PsiDirectory targetDirectory = CreateClassFix.getTargetDirectory(project, qualifier, name, module = ModuleUtil.findModuleForPsiElement((PsiElement)file));
                if (targetDirectory == null) {
                    return;
                }
                PsiClass targetClass = 2.createClassByType(targetDirectory, name, manager, this.myRefElement);
                if (targetClass != null) {
                    CreateClassFix.addImportForClass(groovyFile, qualifier, targetClass);
                    2.putCursor(project, targetClass.getContainingFile(), (PsiElement)targetClass);
                }
            }
        };
    }

    private static PsiDirectory getTargetDirectory(Project project, String qualifier, String name, Module module) {
        String title = GroovyBundle.message("create.class.family.name", new Object[0]);
        GroovyCreateClassDialog dialog = new GroovyCreateClassDialog(project, title, name, qualifier, module);
        dialog.show();
        if (dialog.getExitCode() != 0) {
            return null;
        }
        return dialog.getTargetDirectory();
    }

    protected static void addImportForClass(GroovyFileBase groovyFile, String qualifier, PsiClass targetClass) throws IncorrectOperationException {
        String packageName;
        String qualifiedName;
        if (targetClass != null && (qualifiedName = targetClass.getQualifiedName()) != null && qualifiedName.contains(".") && !(packageName = qualifiedName.substring(0, qualifiedName.lastIndexOf("."))).equals(qualifier)) {
            groovyFile.addImportForClass(targetClass);
        }
    }
}

