/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.visibility;

import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.ui.MultipleCheckboxOptionsPanel;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ParameterHidingMemberVariableInspection
extends BaseInspection {
    public boolean m_ignoreInvisibleFields = true;
    public boolean m_ignoreStaticMethodParametersHidingInstanceFields = false;
    public boolean m_ignoreForConstructors = false;
    public boolean m_ignoreForPropertySetters = false;
    public boolean m_ignoreForAbstractMethods = false;

    @NotNull
    public String getID() {
        if ("ParameterHidesMemberVariable" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/visibility/ParameterHidingMemberVariableInspection.getID must not return null");
        }
        return "ParameterHidesMemberVariable";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("parameter.hides.member.variable.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/visibility/ParameterHidingMemberVariableInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RenameFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("parameter.hides.member.variable.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/visibility/ParameterHidingMemberVariableInspection.buildErrorString must not return null");
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel(this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("parameter.hides.member.variable.ignore.setters.option", new Object[0]), "m_ignoreForPropertySetters");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("parameter.hides.member.variable.ignore.superclass.option", new Object[0]), "m_ignoreInvisibleFields");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("parameter.hides.member.variable.ignore.constructors.option", new Object[0]), "m_ignoreForConstructors");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("parameter.hides.member.variable.ignore.abstract.methods.option", new Object[0]), "m_ignoreForAbstractMethods");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("parameter.hides.member.variable.ignore.static.parameters.option", new Object[0]), "m_ignoreStaticMethodParametersHidingInstanceFields");
        return optionsPanel;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ParameterHidingMemberVariableVisitor();
    }

    private class ParameterHidingMemberVariableVisitor
    extends BaseInspectionVisitor {
        private ParameterHidingMemberVariableVisitor() {
        }

        public void visitParameter(@NotNull PsiParameter variable) {
            PsiField[] fields;
            PsiClass aClass;
            if (variable == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/visibility/ParameterHidingMemberVariableInspection$ParameterHidingMemberVariableVisitor.visitParameter must not be null");
            }
            super.visitParameter(variable);
            if (variable.getDeclarationScope() instanceof PsiCatchSection) {
                return;
            }
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiMethod.class);
            if (method == null) {
                return;
            }
            if (ParameterHidingMemberVariableInspection.this.m_ignoreForConstructors && method.isConstructor()) {
                return;
            }
            if (ParameterHidingMemberVariableInspection.this.m_ignoreForAbstractMethods) {
                if (method.hasModifierProperty("abstract")) {
                    return;
                }
                PsiClass containingClass = method.getContainingClass();
                if (containingClass.isInterface()) {
                    return;
                }
            }
            if (ParameterHidingMemberVariableInspection.this.m_ignoreForPropertySetters) {
                String methodName = method.getName();
                PsiType returnType = method.getReturnType();
                if (methodName.startsWith("set") && PsiType.VOID.equals(returnType)) {
                    return;
                }
            }
            if ((aClass = ClassUtils.getContainingClass((PsiElement)variable)) == null) {
                return;
            }
            String variableName = variable.getName();
            for (PsiField field : fields = aClass.getAllFields()) {
                if (!this.checkFieldName(field, variableName, aClass) || ParameterHidingMemberVariableInspection.this.m_ignoreStaticMethodParametersHidingInstanceFields && !field.hasModifierProperty("static") && method.hasModifierProperty("static")) continue;
                this.registerVariableError((PsiVariable)variable, new Object[0]);
            }
        }

        private boolean checkFieldName(PsiField field, String variableName, PsiClass aClass) {
            if (field == null) {
                return false;
            }
            String fieldName = field.getName();
            if (fieldName == null) {
                return false;
            }
            if (!fieldName.equals(variableName)) {
                return false;
            }
            return !ParameterHidingMemberVariableInspection.this.m_ignoreInvisibleFields || ClassUtils.isFieldVisible(field, aClass);
        }
    }
}

